/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.ECPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.ECPairFactorTransform;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECNewRandomnessTransform
implements ECPairFactorTransform {
    private ECPublicKeyParameters key;
    private SecureRandom random;
    private BigInteger lastK;

    @Override
    public void init(CipherParameters cipherParameters) {
        block5: {
            block4: {
                block2: {
                    block3: {
                        if (!(cipherParameters instanceof ParametersWithRandom)) break block2;
                        if (!(((ParametersWithRandom)(cipherParameters = (ParametersWithRandom)cipherParameters)).getParameters() instanceof ECPublicKeyParameters)) break block3;
                        this.key = (ECPublicKeyParameters)((ParametersWithRandom)cipherParameters).getParameters();
                        this.random = ((ParametersWithRandom)cipherParameters).getRandom();
                        break block4;
                    }
                    throw new IllegalArgumentException("ECPublicKeyParameters are required for new randomness transform.");
                }
                if (!(cipherParameters instanceof ECPublicKeyParameters)) break block5;
                ECNewRandomnessTransform eCNewRandomnessTransform = this;
                eCNewRandomnessTransform.key = (ECPublicKeyParameters)cipherParameters;
                eCNewRandomnessTransform.random = CryptoServicesRegistrar.getSecureRandom();
            }
            return;
        }
        throw new IllegalArgumentException("ECPublicKeyParameters are required for new randomness transform.");
    }

    @Override
    public ECPair transform(ECPair eCPair) {
        Object object = ((ECNewRandomnessTransform)((Object)eCPoint)).key;
        if (object != null) {
            object = ((ECKeyParameters)object).getParameters();
            ECNewRandomnessTransform eCNewRandomnessTransform = eCPoint;
            ECMultiplier eCMultiplier = eCNewRandomnessTransform.createBasePointMultiplier();
            BigInteger bigInteger = ECUtil.generateK(((ECDomainParameters)object).getN(), eCNewRandomnessTransform.random);
            ECPoint[] eCPointArray = new ECPoint[2];
            ECPoint[] eCPointArray2 = eCPointArray;
            eCPointArray2[0] = eCMultiplier.multiply(((ECDomainParameters)object).getG(), bigInteger).add(ECAlgorithms.cleanPoint(((ECDomainParameters)object).getCurve(), eCPair.getX()));
            eCPointArray[1] = ((ECNewRandomnessTransform)((Object)eCPoint)).key.getQ().multiply(bigInteger).add(ECAlgorithms.cleanPoint(((ECDomainParameters)object).getCurve(), eCPair.getY()));
            ((ECDomainParameters)object).getCurve().normalizeAll(eCPointArray2);
            ((ECNewRandomnessTransform)((Object)eCPoint)).lastK = bigInteger;
            ECPoint eCPoint = eCPointArray2[0];
            return new ECPair(eCPoint, eCPointArray2[1]);
        }
        throw new IllegalStateException("ECNewRandomnessTransform not initialised");
    }

    @Override
    public BigInteger getTransformValue() {
        return this.lastK;
    }

    public ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

