/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.ChaChaEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.Salsa20Engine;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class ChaCha7539Engine
extends Salsa20Engine {
    @Override
    public String getAlgorithmName() {
        return "ChaCha7539";
    }

    @Override
    public int getNonceSize() {
        return 12;
    }

    @Override
    public void advanceCounter(long l) {
        int n = (int)l;
        if ((int)(l >>> 32) <= 0) {
            Object object = ((Salsa20Engine)object).engineState;
            int n2 = ((Salsa20Engine)object).engineState[12];
            int n3 = n2 + n;
            object[12] = n3;
            if (n2 != 0 && n3 < n2) {
                throw new IllegalStateException("attempt to increase counter past 2^32.");
            }
            return;
        }
        throw new IllegalStateException("attempt to increase counter past 2^32.");
    }

    @Override
    public void advanceCounter() {
        Object object = ((Salsa20Engine)object).engineState;
        int n = ((Salsa20Engine)object).engineState[12] + 1;
        object[12] = n;
        if (n != 0) {
            return;
        }
        throw new IllegalStateException("attempt to increase counter past 2^32.");
    }

    @Override
    public void retreatCounter(long l) {
        int n = (int)l;
        if ((int)(l >>> 32) == 0) {
            Object object = ((Salsa20Engine)object).engineState;
            int n2 = ((Salsa20Engine)object).engineState[12];
            if (((long)n2 & 0xFFFFFFFFL) >= ((long)n & 0xFFFFFFFFL)) {
                object[12] = n2 - n;
                return;
            }
            throw new IllegalStateException("attempt to reduce counter past zero.");
        }
        throw new IllegalStateException("attempt to reduce counter past zero.");
    }

    @Override
    public void retreatCounter() {
        Object object = ((Salsa20Engine)object).engineState;
        int n = ((Salsa20Engine)object).engineState[12];
        if (n != 0) {
            object[12] = n - 1;
            return;
        }
        throw new IllegalStateException("attempt to reduce counter past zero.");
    }

    @Override
    public long getCounter() {
        return (long)this.engineState[12] & 0xFFFFFFFFL;
    }

    @Override
    public void resetCounter() {
        this.engineState[12] = 0;
    }

    @Override
    public void setKey(byte[] byArray, byte[] byArray2) {
        if (byArray != null) {
            if (byArray.length == 32) {
                ChaCha7539Engine chaCha7539Engine = this;
                int n = byArray.length;
                chaCha7539Engine.packTauOrSigma(n, chaCha7539Engine.engineState, 0);
                Pack.littleEndianToInt(byArray, 0, chaCha7539Engine.engineState, 4, 8);
            } else {
                throw new IllegalArgumentException(this.getAlgorithmName() + " requires 256 bit key");
            }
        }
        Pack.littleEndianToInt(byArray2, 0, this.engineState, 13, 3);
    }

    @Override
    public void generateKeyStream(byte[] byArray) {
        ChaCha7539Engine chaCha7539Engine = object;
        ChaCha7539Engine chaCha7539Engine2 = object;
        Object object = chaCha7539Engine2.engineState;
        ChaChaEngine.chachaCore(chaCha7539Engine.rounds, (int[])object, chaCha7539Engine2.x);
        Pack.intToLittleEndian(chaCha7539Engine.x, byArray, 0);
    }
}

