/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ElGamalKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ElGamalEngine
implements AsymmetricBlockCipher {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private ElGamalKeyParameters key;
    private SecureRandom random;
    private boolean forEncryption;
    private int bitSize;

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        block9: {
            block8: {
                block7: {
                    if (cipherParameters instanceof ParametersWithRandom) {
                        ElGamalEngine elGamalEngine = this;
                        cipherParameters = (ParametersWithRandom)cipherParameters;
                        elGamalEngine.key = (ElGamalKeyParameters)((ParametersWithRandom)cipherParameters).getParameters();
                        elGamalEngine.random = ((ParametersWithRandom)cipherParameters).getRandom();
                    } else {
                        ElGamalEngine elGamalEngine = this;
                        elGamalEngine.key = (ElGamalKeyParameters)cipherParameters;
                        elGamalEngine.random = CryptoServicesRegistrar.getSecureRandom();
                    }
                    this.forEncryption = bl;
                    this.bitSize = this.key.getParameters().getP().bitLength();
                    if (!bl) break block7;
                    if (!(this.key instanceof ElGamalPublicKeyParameters)) {
                        throw new IllegalArgumentException("ElGamalPublicKeyParameters are required for encryption.");
                    }
                    break block8;
                }
                if (!(this.key instanceof ElGamalPrivateKeyParameters)) break block9;
            }
            return;
        }
        throw new IllegalArgumentException("ElGamalPrivateKeyParameters are required for decryption.");
    }

    @Override
    public int getInputBlockSize() {
        if (this.forEncryption) {
            return (this.bitSize - 1) / 8;
        }
        return (this.bitSize + 7) / 8 * 2;
    }

    @Override
    public int getOutputBlockSize() {
        if (this.forEncryption) {
            return (this.bitSize + 7) / 8 * 2;
        }
        return (this.bitSize - 1) / 8;
    }

    @Override
    public byte[] processBlock(byte[] object, int n, int n2) {
        if (((ElGamalEngine)object2).key != null) {
            int n3 = ((ElGamalEngine)object2).forEncryption ? (((ElGamalEngine)object2).bitSize - 1 + 7) / 8 : ((ElGamalEngine)object2).getInputBlockSize();
            if (n2 <= n3) {
                BigInteger bigInteger;
                Object object2;
                ElGamalEngine elGamalEngine = object2;
                BigInteger bigInteger2 = elGamalEngine.key.getParameters().getP();
                if (elGamalEngine.key instanceof ElGamalPrivateKeyParameters) {
                    BigInteger bigInteger3;
                    BigInteger bigInteger4;
                    int n4 = n2 / 2;
                    byte[] byArray = new byte[n4];
                    byte[] byArray2 = new byte[n4];
                    System.arraycopy(object, n, byArray, 0, n4);
                    System.arraycopy(object, n + n4, byArray2, 0, n4);
                    Object object3 = bigInteger4;
                    ElGamalEngine elGamalEngine2 = object2;
                    ((BigInteger)object3)(1, byArray);
                    object2 = bigInteger3;
                    bigInteger3 = new BigInteger(1, byArray2);
                    object3 = (ElGamalPrivateKeyParameters)elGamalEngine2.key;
                    return BigIntegers.asUnsignedByteArray(bigInteger4.modPow(bigInteger2.subtract(ONE).subtract(((ElGamalPrivateKeyParameters)object3).getX()), bigInteger2).multiply((BigInteger)object2).mod(bigInteger2));
                }
                if (n != 0 || n2 != ((byte[])object).length) {
                    byte[] byArray = object;
                    object = new byte[n2];
                    System.arraycopy(byArray, n, object, 0, n2);
                }
                BigInteger bigInteger5 = bigInteger;
                bigInteger5(1, (byte[])object);
                if (bigInteger.compareTo(bigInteger2) < 0) {
                    object = (ElGamalPublicKeyParameters)((ElGamalEngine)object2).key;
                    n2 = bigInteger2.bitLength();
                    BigInteger bigInteger6 = BigIntegers.createRandomBigInteger(n2, ((ElGamalEngine)object2).random);
                    while (true) {
                        if (!bigInteger6.equals(ZERO) && bigInteger6.compareTo(bigInteger2.subtract(TWO)) <= 0) {
                            int n5;
                            Object object4 = object2;
                            object2 = ((ElGamalEngine)object2).key.getParameters().getG().modPow(bigInteger6, bigInteger2);
                            object2 = ((BigInteger)object2).toByteArray();
                            object = bigInteger5.multiply(object.getY().modPow(bigInteger6, bigInteger2)).mod(bigInteger2).toByteArray();
                            int n6 = ((ElGamalEngine)object4).getOutputBlockSize();
                            byte[] byArray = new byte[n6];
                            int n7 = n6 / 2;
                            if (((Object)object2).length > n7) {
                                Object object5 = object2;
                                n5 = n7 - (((Object)object2).length - 1);
                                int n8 = ((Object)object5).length - 1;
                                System.arraycopy(object5, 1, byArray, n5, n8);
                            } else {
                                Object object6 = object2;
                                n5 = n7 - ((Object)object2).length;
                                int n9 = ((Object)object6).length;
                                System.arraycopy(object6, 0, byArray, n5, n9);
                            }
                            if (((byte[])object).length > n7) {
                                n5 = n6 - (((byte[])object).length - 1);
                                int n10 = ((byte[])object).length - 1;
                                System.arraycopy(object, 1, byArray, n5, n10);
                            } else {
                                n5 = n6 - ((byte[])object).length;
                                int n11 = ((byte[])object).length;
                                System.arraycopy(object, 0, byArray, n5, n11);
                            }
                            return byArray;
                        }
                        bigInteger6 = BigIntegers.createRandomBigInteger(n2, ((ElGamalEngine)object2).random);
                    }
                }
                throw new DataLengthException("input too large for ElGamal cipher.\n");
            }
            throw new DataLengthException("input too large for ElGamal cipher.\n");
        }
        throw new IllegalStateException("ElGamal engine not initialised");
    }
}

