/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class Grain128Engine
implements StreamCipher {
    private static final int STATE_SIZE = 4;
    private byte[] workingKey;
    private byte[] workingIV;
    private byte[] out;
    private int[] lfsr;
    private int[] nfsr;
    private int output;
    private int index = 4;
    private boolean initialised = false;

    private void initGrain() {
        for (int k = 0; k < 8; ++k) {
            Grain128Engine grain128Engine = this;
            grain128Engine.output = grain128Engine.getOutput();
            grain128Engine.nfsr = grain128Engine.shift(grain128Engine.nfsr, this.getOutputNFSR() ^ this.lfsr[0] ^ this.output);
            grain128Engine.lfsr = grain128Engine.shift(grain128Engine.lfsr, this.getOutputLFSR() ^ this.output);
        }
        this.initialised = true;
    }

    private int getOutputNFSR() {
        Object object = ((Grain128Engine)object).nfsr;
        int n = ((Grain128Engine)object).nfsr[0];
        int n2 = n;
        Object object2 = object;
        int n3 = n2 >>> 3;
        Object object3 = object2[1];
        int n4 = n2;
        n2 = n3 | object3 << 29;
        n3 = n4 >>> 11 | object3 << 21;
        int n5 = n4 >>> 13 | object3 << 19;
        int n6 = n4 >>> 17 | object3 << 15;
        int n7 = n4 >>> 18 | object3 << 14;
        int n8 = n4 >>> 26 | object3 << 6;
        int n9 = n4 >>> 27 | object3 << 5;
        Object object4 = object3 >>> 8;
        Object object5 = object2[2];
        int n10 = n8;
        Object object6 = object5;
        Object object7 = object3;
        object3 = object4 | object5 << 24;
        n8 = object7 >>> 16 | object5 << 16;
        object4 = object7 >>> 24 | object5 << 8;
        int n11 = object7 >>> 27 | object5 << 5;
        object5 = object7 >>> 29 | object5 << 3;
        Object object8 = object[3];
        int n12 = object6 >>> 1 | object8 << 31;
        int n13 = object6 >>> 3 | object8 << 29;
        int n14 = object6 >>> 4 | object8 << 28;
        int n15 = object6 >>> 20 | object8 << 12;
        int n16 = object6 >>> 27 | object8 << 5;
        return n ^ n10 ^ object4 ^ n16 ^ object8 ^ n2 & n13 ^ n3 & n5 ^ n6 & n7 ^ n9 & n11 ^ object3 & n8 ^ object5 & n12 ^ n14 & n15;
    }

    private int getOutputLFSR() {
        Object object = ((Grain128Engine)object).lfsr;
        int n = ((Grain128Engine)object).lfsr[0];
        int n2 = n;
        Object object2 = object;
        n2 >>>= 7;
        Object object3 = object2[1];
        Object object4 = object3 >>> 6;
        Object object5 = object2[2];
        int n3 = n2 |= object3 << 25;
        Object object6 = object5;
        n2 = object4 | object5 << 26;
        Object object7 = object[3];
        object4 = object6 >>> 6 | object7 << 26;
        object5 = object6 >>> 17 | object7 << 15;
        return n ^ n3 ^ n2 ^ object4 ^ object5 ^ object7;
    }

    private int getOutput() {
        int[] nArray = this.nfsr;
        int n = this.nfsr[0];
        int n2 = nArray[1];
        int n3 = n >>> 2 | n2 << 30;
        int n4 = n >>> 12 | n2 << 20;
        int n5 = n >>> 15 | n2 << 17;
        n = n2 >>> 4;
        int n6 = nArray[2];
        n |= n6 << 28;
        n2 = n2 >>> 13 | n6 << 19;
        int n7 = nArray[3];
        int n8 = n6 >>> 9 | n7 << 23;
        int n9 = n6 >>> 25 | n7 << 7;
        n7 = n6 >>> 31 | n7 << 1;
        int[] nArray2 = this.lfsr;
        int n10 = this.lfsr[0];
        int n11 = n10 >>> 8;
        int n12 = nArray2[1];
        int n13 = n10;
        n10 = n11 | n12 << 24;
        n11 = n13 >>> 13 | n12 << 19;
        int n14 = n13 >>> 20 | n12 << 12;
        int n15 = n12 >>> 10;
        int n16 = this.lfsr[2];
        int n17 = n10;
        int n18 = n16;
        n10 = n15 | n16 << 22;
        n12 = n12 >>> 28 | n16 << 4;
        int n19 = nArray2[3];
        n15 = n18 >>> 15 | n19 << 17;
        n16 = n18 >>> 29 | n19 << 3;
        n19 = n18 >>> 31 | n19 << 1;
        return n4 & n17 ^ n11 & n14 ^ n7 & n10 ^ n12 & n15 ^ n4 & n7 & n19 ^ n16 ^ n3 ^ n5 ^ n ^ n2 ^ n6 ^ n8 ^ n9;
    }

    private int[] shift(int[] nArray, int n) {
        int[] nArray2 = nArray;
        int[] nArray3 = nArray;
        nArray3[0] = nArray2[1];
        nArray3[1] = nArray2[2];
        nArray3[2] = nArray2[3];
        nArray2[3] = n;
        return nArray3;
    }

    private void setKey(byte[] byArray, byte[] byArray2) {
        Grain128Engine grain128Engine = this;
        byte[] byArray3 = byArray2;
        byte[] byArray4 = byArray2;
        byArray3[12] = -1;
        byArray4[13] = -1;
        byArray3[14] = -1;
        byArray4[15] = -1;
        grain128Engine.workingKey = byArray;
        grain128Engine.workingIV = byArray2;
        int n = 0;
        int n2 = 0;
        while (true) {
            Object[] objectArray = this.nfsr;
            if (n2 >= this.nfsr.length) break;
            int[] nArray = objectArray;
            objectArray = this.workingKey;
            int n3 = n + 3;
            int n4 = n + 2;
            int n5 = n + 1;
            nArray[n2] = this.workingKey[n3] << 24 | objectArray[n4] << 16 & 0xFF0000 | objectArray[n5] << 8 & 0xFF00 | objectArray[n] & 0xFF;
            objectArray = this.workingIV;
            this.lfsr[n2] = this.workingIV[n3] << 24 | objectArray[n4] << 16 & 0xFF0000 | objectArray[n5] << 8 & 0xFF00 | objectArray[n] & 0xFF;
            n += 4;
            ++n2;
        }
    }

    private void oneRound() {
        int n;
        Grain128Engine grain128Engine = object;
        grain128Engine.output = n = grain128Engine.getOutput();
        byte[] byArray = grain128Engine.out;
        byArray[0] = (byte)n;
        byArray[1] = (byte)(n >> 8);
        byArray[2] = (byte)(n >> 16);
        grain128Engine.out[3] = (byte)(n >> 24);
        grain128Engine.nfsr = grain128Engine.shift(grain128Engine.nfsr, ((Grain128Engine)object).getOutputNFSR() ^ ((Grain128Engine)object).lfsr[0]);
        Object object = grain128Engine.lfsr;
        grain128Engine.lfsr = grain128Engine.shift((int[])object, grain128Engine.getOutputLFSR());
    }

    private byte getKeyStream() {
        if (this.index > 3) {
            this.oneRound();
            this.index = 0;
        }
        int n = this.index;
        this.index = n + 1;
        return this.out[n];
    }

    @Override
    public String getAlgorithmName() {
        return "Grain-128";
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        if (object instanceof ParametersWithIV) {
            CipherParameters cipherParameters = (ParametersWithIV)object;
            byte[] byArray = ((ParametersWithIV)cipherParameters).getIV();
            object = byArray;
            if (byArray != null && ((Object)object).length == 12) {
                if (((ParametersWithIV)cipherParameters).getParameters() instanceof KeyParameter) {
                    Grain128Engine grain128Engine = object3;
                    Object object2 = object;
                    cipherParameters = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
                    ((Grain128Engine)object3).workingIV = new byte[((KeyParameter)cipherParameters).getKey().length];
                    ((Grain128Engine)object3).workingKey = new byte[((KeyParameter)cipherParameters).getKey().length];
                    ((Grain128Engine)object3).lfsr = new int[4];
                    ((Grain128Engine)object3).nfsr = new int[4];
                    ((Grain128Engine)object3).out = new byte[4];
                    object = ((Grain128Engine)object3).workingIV;
                    int n = ((Object)object2).length;
                    System.arraycopy(object2, 0, object, 0, n);
                    Object object3 = ((Grain128Engine)object3).workingKey;
                    int n2 = ((KeyParameter)cipherParameters).getKey().length;
                    System.arraycopy(((KeyParameter)cipherParameters).getKey(), 0, object3, 0, n2);
                    grain128Engine.reset();
                    return;
                }
                throw new IllegalArgumentException("Grain-128 Init parameters must include a key");
            }
            throw new IllegalArgumentException("Grain-128  requires exactly 12 bytes of IV");
        }
        throw new IllegalArgumentException("Grain-128 Init parameters must include an IV");
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (this.initialised) {
            if (n + n2 <= byArray.length) {
                if (n3 + n2 <= byArray2.length) {
                    for (int k = 0; k < n2; ++k) {
                        int n4 = n3 + k;
                        byArray2[n4] = (byte)(byArray[n + k] ^ this.getKeyStream());
                    }
                    return n2;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public void reset() {
        Grain128Engine grain128Engine = object;
        grain128Engine.index = 4;
        Object object = grain128Engine.workingKey;
        grain128Engine.setKey((byte[])object, grain128Engine.workingIV);
        grain128Engine.initGrain();
    }

    @Override
    public byte returnByte(byte by) {
        if (this.initialised) {
            return (byte)(by ^ this.getKeyStream());
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }
}

