/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class NoekeonEngine
implements BlockCipher {
    private static final int SIZE = 16;
    private static final byte[] roundConstants = new byte[]{-128, 27, 54, 108, -40, -85, 77, -102, 47, 94, -68, 99, -58, -105, 53, 106, -44};
    private final int[] k = new int[4];
    private boolean _initialised = false;
    private boolean _forEncryption;

    private int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n;
        int n4 = Pack.bigEndianToInt(byArray, n);
        int n5 = Pack.bigEndianToInt(byArray, n + 4);
        n = Pack.bigEndianToInt(byArray, n + 8);
        int n6 = Pack.bigEndianToInt(byArray, n3 + 12);
        int n7 = this.k[0];
        int n8 = this.k[1];
        int n9 = this.k[2];
        int n10 = this.k[3];
        int n11 = 0;
        while (true) {
            int n12 = n;
            int n13 = n5;
            n5 = (n4 ^= roundConstants[n11] & 0xFF) ^ n;
            int n14 = n5 ^ (Integers.rotateLeft(n5, 8) ^ Integers.rotateLeft(n5, 24));
            n5 = n14;
            int n15 = n4;
            n4 = n6 ^ n5;
            n5 = n15 ^ n7;
            n = n13 ^ n14 ^ n8;
            int n16 = n5;
            n5 = n ^ (n4 ^= n10);
            n5 ^= Integers.rotateLeft(n5, 8) ^ Integers.rotateLeft(n5, 24);
            n6 = n16 ^ n5;
            n5 = n12 ^ n9 ^ n5;
            if (++n11 > 16) {
                Pack.intToBigEndian(n6, byArray2, n2);
                Pack.intToBigEndian(n, byArray2, n2 + 4);
                Pack.intToBigEndian(n5, byArray2, n2 + 8);
                Pack.intToBigEndian(n4, byArray2, n2 + 12);
                return 16;
            }
            int n17 = n5;
            n5 = Integers.rotateLeft(n, 1);
            n = Integers.rotateLeft(n17, 5);
            n4 = Integers.rotateLeft(n4, 2);
            n6 ^= n & (n5 ^= ~n4 & ~n);
            n ^= n4 ^ n5 ^ n6;
            n4 ^= n & (n5 ^= ~n6 & ~n);
            n5 = Integers.rotateLeft(n5, 31);
            n = Integers.rotateLeft(n, 27);
            n6 = Integers.rotateLeft(n6, 30);
        }
    }

    private int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n;
        int n4 = Pack.bigEndianToInt(byArray, n);
        int n5 = Pack.bigEndianToInt(byArray, n + 4);
        n = Pack.bigEndianToInt(byArray, n + 8);
        int n6 = Pack.bigEndianToInt(byArray, n3 + 12);
        int n7 = this.k[0];
        int n8 = this.k[1];
        int n9 = this.k[2];
        int n10 = this.k[3];
        int n11 = 16;
        while (true) {
            int n12 = n4;
            n4 ^= n;
            n4 ^= Integers.rotateLeft(n4, 8) ^ Integers.rotateLeft(n4, 24);
            n5 ^= n4;
            n4 = n6 ^ n4;
            int n13 = n4;
            n4 = n ^ n9;
            n = n13 ^ n10;
            n6 = (n5 ^= n8) ^ n;
            n6 ^= Integers.rotateLeft(n6, 8) ^ Integers.rotateLeft(n6, 24);
            n4 ^= n6;
            n6 = n12 ^ n7 ^ n6 ^ roundConstants[n11] & 0xFF;
            if ((n11 += -1) < 0) {
                Pack.intToBigEndian(n6, byArray2, n2);
                Pack.intToBigEndian(n5, byArray2, n2 + 4);
                Pack.intToBigEndian(n4, byArray2, n2 + 8);
                Pack.intToBigEndian(n, byArray2, n2 + 12);
                return 16;
            }
            int n14 = n4;
            n4 = Integers.rotateLeft(n5, 1);
            n5 = Integers.rotateLeft(n14, 5);
            int n15 = n4;
            n4 = Integers.rotateLeft(n, 2);
            n = n15 ^ ~n4 & ~n5;
            int n16 = n5 ^ (n4 ^ n ^ (n6 ^= n5 & n));
            n5 = n16;
            n4 ^= n5 & (n ^= ~n6 & ~n5);
            n5 = Integers.rotateLeft(n, 31);
            n = Integers.rotateLeft(n16, 27);
            n6 = Integers.rotateLeft(n6, 30);
        }
    }

    @Override
    public String getAlgorithmName() {
        return "Noekeon";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        void var2_9;
        if (var2_9 instanceof KeyParameter) {
            Object object;
            NoekeonEngine noekeonEngine = object;
            noekeonEngine._forEncryption = bl;
            noekeonEngine._initialised = true;
            Pack.bigEndianToInt(((KeyParameter)var2_9).getKey(), 0, ((NoekeonEngine)object).k, 0, 4);
            if (!bl) {
                NoekeonEngine noekeonEngine2 = object;
                object = noekeonEngine2.k;
                int n = noekeonEngine2.k[0];
                int n2 = noekeonEngine2.k[1];
                int n3 = noekeonEngine2.k[2];
                int n4 = n3;
                Object object2 = object[3];
                int n6 = n ^ n4;
                n6 = n6 ^ (Integers.rotateLeft(n6, 8) ^ Integers.rotateLeft(n6, 24));
                int n7 = object2 ^ n6;
                object2 = n7;
                int n9 = (n2 ^= n6) ^ n7;
                n9 = n9 ^ (Integers.rotateLeft(n9, 8) ^ Integers.rotateLeft(n9, 24));
                n4 = n ^ n9;
                int n10 = n3 ^ n9;
                int[] nArray2 = noekeonEngine2.k;
                nArray2 = noekeonEngine2.k;
                nArray[0] = n4;
                nArray2[1] = n2;
                nArray[2] = n10;
                nArray2[3] = (int)object2;
            }
            return;
        }
        throw new IllegalArgumentException(a.a((CipherParameters)var2_9, b.a("invalid parameter passed to Noekeon init - ")));
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this._initialised) {
            if (n <= byArray.length - 16) {
                if (n2 <= byArray2.length - 16) {
                    return this._forEncryption ? this.encryptBlock(byArray, n, byArray2, n2) : this.decryptBlock(byArray, n, byArray2, n2);
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public void reset() {
    }
}

