/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;

public class RC6Engine
implements BlockCipher {
    private static final int wordSize = 32;
    private static final int bytesPerWord = 4;
    private static final int _noRounds = 20;
    private static final int P32 = -1209970333;
    private static final int Q32 = -1640531527;
    private static final int LGW = 5;
    private int[] _S = null;
    private boolean forEncryption;

    private void setKey(byte[] byArray) {
        int[] nArray;
        int n;
        int cfr_ignored_0 = (byArray.length + 3) / 4;
        int n2 = (byArray.length + 4 - 1) / 4;
        int[] nArray2 = new int[n2];
        for (int k = byArray.length - 1; k >= 0; --k) {
            n = k / 4;
            nArray2[n] = (nArray2[n] << 8) + (byArray[k] & 0xFF);
        }
        int[] nArray3 = new int[44];
        this._S = nArray3;
        nArray3[0] = -1209970333;
        int n3 = 1;
        while (true) {
            nArray = this._S;
            if (n3 >= this._S.length) break;
            nArray[n3] = nArray[n3 - 1] + -1640531527;
            ++n3;
        }
        n3 = n2 > nArray.length ? n2 * 3 : nArray.length * 3;
        int n4 = 0;
        n = 0;
        int n5 = 0;
        int n6 = 0;
        for (int k = 0; k < n3; ++k) {
            RC6Engine rC6Engine = this;
            int[] nArray4 = rC6Engine._S;
            n4 = rC6Engine.rotateLeft(rC6Engine._S[n5] + n4 + n, 3);
            int n7 = n;
            nArray4[n5] = n4;
            n = nArray2[n6] + n4 + n;
            nArray2[n6] = n = rC6Engine.rotateLeft(n, n4 + n7);
            n5 = (n5 + 1) % this._S.length;
            n6 = (n6 + 1) % n2;
        }
    }

    private int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n;
        int n4 = n;
        int n5 = this.bytesToWord(byArray, n);
        n = this.bytesToWord(byArray, n + 4);
        int n6 = this.bytesToWord(byArray, n4 + 8);
        n += this._S[0];
        int n7 = this.bytesToWord(byArray, n3 + 12) + this._S[1];
        for (int k = 1; k <= 20; ++k) {
            int n8 = n6;
            int n9 = n5;
            n5 = this.rotateLeft((n * 2 + 1) * n, 5);
            n6 = this.rotateLeft((n7 * 2 + 1) * n7, 5);
            int n10 = k * 2;
            int n11 = this.rotateLeft(n9 ^ n5, n6) + this._S[n10];
            n5 = this.rotateLeft(n8 ^ n6, n5) + this._S[n10 + 1];
            int n12 = n;
            int n13 = n7;
            n7 = n11;
            n = n5;
            n6 = n13;
            n5 = n12;
        }
        RC6Engine rC6Engine = this;
        int n14 = n5 + this._S[42];
        n5 = n6 + this._S[43];
        this.wordToBytes(n14, byArray2, n2);
        rC6Engine.wordToBytes(n, byArray2, n2 + 4);
        rC6Engine.wordToBytes(n5, byArray2, n2 + 8);
        this.wordToBytes(n7, byArray2, n2 + 12);
        return 16;
    }

    private int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.bytesToWord(byArray, n);
        RC6Engine rC6Engine = this;
        int n4 = n;
        int n5 = this.bytesToWord(byArray, n + 4);
        n = this.bytesToWord(byArray, n + 8);
        int n6 = rC6Engine.bytesToWord(byArray, n4 + 12);
        int n7 = n3 - rC6Engine._S[42];
        int n8 = n7;
        n7 = n -= rC6Engine._S[43];
        n = n8;
        for (int k = 20; k >= 1; --k) {
            int n9 = n6;
            RC6Engine rC6Engine2 = this;
            int n10 = n5;
            RC6Engine rC6Engine3 = this;
            n5 = this.rotateLeft((n * 2 + 1) * n, 5);
            n6 = rC6Engine3.rotateLeft((n7 * 2 + 1) * n7, 5);
            int n11 = k * 2;
            int n12 = rC6Engine2.rotateRight(n10 - rC6Engine3._S[n11 + 1], n5) ^ n6;
            n5 = this.rotateRight(n9 - rC6Engine2._S[n11], n6) ^ n5;
            int n13 = n7;
            int n14 = n;
            n7 = n12;
            n = n5;
            n5 = n14;
            n6 = n13;
        }
        RC6Engine rC6Engine4 = this;
        RC6Engine rC6Engine5 = this;
        int n15 = n6 - this._S[1];
        rC6Engine5.wordToBytes(n, byArray2, n2);
        rC6Engine5.wordToBytes(n5 -= this._S[0], byArray2, n2 + 4);
        rC6Engine4.wordToBytes(n7, byArray2, n2 + 8);
        rC6Engine4.wordToBytes(n15, byArray2, n2 + 12);
        return 16;
    }

    private int rotateLeft(int n, int n2) {
        return n << n2 | n >>> -n2;
    }

    private int rotateRight(int n, int n2) {
        return n >>> n2 | n << -n2;
    }

    private int bytesToWord(byte[] byArray, int n) {
        int n2 = 0;
        for (int k = 3; k >= 0; --k) {
            n2 = (n2 << 8) + (byArray[k + n] & 0xFF);
        }
        return n2;
    }

    private void wordToBytes(int n, byte[] byArray, int n2) {
        for (int k = 0; k < 4; ++k) {
            int n3 = n;
            int n4 = n;
            n = k + n2;
            byArray[n] = (byte)n4;
            n = n3 >>> 8;
        }
    }

    @Override
    public String getAlgorithmName() {
        return "RC6";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            RC6Engine rC6Engine = keyParameter;
            KeyParameter keyParameter = (KeyParameter)cipherParameters;
            rC6Engine.forEncryption = bl;
            rC6Engine.setKey(keyParameter.getKey());
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("invalid parameter passed to RC6 init - ")));
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        RC6Engine rC6Engine = this;
        int n3 = rC6Engine.getBlockSize();
        if (rC6Engine._S != null) {
            if (n + n3 <= byArray.length) {
                if (n2 + n3 <= byArray2.length) {
                    return this.forEncryption ? this.encryptBlock(byArray, n, byArray2, n2) : this.decryptBlock(byArray, n, byArray2, n2);
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException("RC6 engine not initialised");
    }

    @Override
    public void reset() {
    }
}

