/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Wrapper;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class RFC3394WrapEngine
implements Wrapper {
    private BlockCipher engine;
    private boolean wrapCipherMode;
    private KeyParameter param;
    private boolean forWrapping;
    private byte[] iv = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};

    public RFC3394WrapEngine(BlockCipher blockCipher) {
        this(blockCipher, false);
    }

    public RFC3394WrapEngine(BlockCipher blockCipher, boolean bl) {
        this.engine = blockCipher;
        this.wrapCipherMode = bl ^ true;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        ((RFC3394WrapEngine)((Object)parametersWithIV)).forWrapping = bl;
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters = ((ParametersWithRandom)cipherParameters).getParameters();
        }
        if (cipherParameters instanceof KeyParameter) {
            ((RFC3394WrapEngine)((Object)parametersWithIV)).param = (KeyParameter)cipherParameters;
        } else if (cipherParameters instanceof ParametersWithIV) {
            RFC3394WrapEngine rFC3394WrapEngine = parametersWithIV;
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            rFC3394WrapEngine.iv = parametersWithIV.getIV();
            rFC3394WrapEngine.param = (KeyParameter)parametersWithIV.getParameters();
            if (rFC3394WrapEngine.iv.length != 8) {
                throw new IllegalArgumentException("IV not equal to 8");
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.engine.getAlgorithmName();
    }

    @Override
    public byte[] wrap(byte[] byArray, int n, int n2) {
        if (this.forWrapping) {
            int n3 = n2 / 8;
            if (n3 * 8 == n2) {
                byte[] byArray2 = byArray;
                RFC3394WrapEngine rFC3394WrapEngine = this;
                byArray = new byte[n2 + rFC3394WrapEngine.iv.length];
                byte[] byArray3 = new byte[rFC3394WrapEngine.iv.length + 8];
                int n4 = rFC3394WrapEngine.iv.length;
                System.arraycopy(rFC3394WrapEngine.iv, 0, byArray, 0, n4);
                System.arraycopy(byArray2, n, byArray, rFC3394WrapEngine.iv.length, n2);
                RFC3394WrapEngine rFC3394WrapEngine2 = this;
                n2 = rFC3394WrapEngine2.wrapCipherMode ? 1 : 0;
                this.engine.init(n2 != 0, rFC3394WrapEngine2.param);
                for (n2 = 0; n2 != 6; ++n2) {
                    for (n4 = 1; n4 <= n3; ++n4) {
                        int n5 = this.iv.length;
                        System.arraycopy(byArray, 0, byArray3, 0, n5);
                        n5 = n4 * 8;
                        System.arraycopy(byArray, n5, byArray3, this.iv.length, 8);
                        this.engine.processBlock(byArray3, 0, byArray3, 0);
                        int n6 = n3 * n2 + n4;
                        int n7 = 1;
                        while (n6 != 0) {
                            int n8 = n6;
                            n6 = (byte)n6;
                            int n9 = this.iv.length - n7;
                            byArray3[n9] = (byte)(byArray3[n9] ^ n6);
                            n6 = n8 >>> 8;
                            ++n7;
                        }
                        System.arraycopy(byArray3, 0, byArray, 0, 8);
                        System.arraycopy(byArray3, 8, byArray, n5, 8);
                    }
                }
                return byArray;
            }
            throw new DataLengthException("wrap data must be a multiple of 8 bytes");
        }
        throw new IllegalStateException("not set for wrapping");
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n, int n2) {
        if (!this.forWrapping) {
            int n3 = n2 / 8;
            if (n3 * 8 == n2) {
                int n4 = n3;
                byte[] byArray2 = byArray;
                byte[] byArray3 = byArray;
                byArray = new byte[n2 - this.iv.length];
                byte[] byArray4 = new byte[this.iv.length];
                byte[] byArray5 = new byte[this.iv.length + 8];
                n3 = this.iv.length;
                System.arraycopy(byArray3, n, byArray4, 0, n3);
                byte[] byArray6 = this.iv;
                int n5 = n + this.iv.length;
                int n6 = n2 - byArray6.length;
                System.arraycopy(byArray2, n5, byArray, 0, n6);
                RFC3394WrapEngine rFC3394WrapEngine = this;
                n6 = rFC3394WrapEngine.wrapCipherMode ^ 1;
                this.engine.init(n6 != 0, rFC3394WrapEngine.param);
                n6 = n4 - 1;
                for (n5 = 5; n5 >= 0; --n5) {
                    for (int k = n6; k >= 1; --k) {
                        int n7 = this.iv.length;
                        System.arraycopy(byArray4, 0, byArray5, 0, n7);
                        n7 = (k - 1) * 8;
                        System.arraycopy(byArray, n7, byArray5, this.iv.length, 8);
                        int n8 = n6 * n5 + k;
                        int n9 = 1;
                        while (n8 != 0) {
                            int n10 = n8;
                            n8 = (byte)n8;
                            int n11 = this.iv.length - n9;
                            byArray5[n11] = (byte)(byArray5[n11] ^ n8);
                            n8 = n10 >>> 8;
                            ++n9;
                        }
                        this.engine.processBlock(byArray5, 0, byArray5, 0);
                        System.arraycopy(byArray5, 0, byArray4, 0, 8);
                        System.arraycopy(byArray5, 8, byArray, n7, 8);
                    }
                }
                if (Arrays.constantTimeAreEqual(byArray4, this.iv)) {
                    return byArray;
                }
                throw new InvalidCipherTextException("checksum failed");
            }
            throw new InvalidCipherTextException("unwrap data must be a multiple of 8 bytes");
        }
        throw new IllegalStateException("not set for unwrapping");
    }
}

