/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

class RSACoreEngine {
    private RSAKeyParameters key;
    private boolean forEncryption;

    public void init(boolean bl, CipherParameters cipherParameters) {
        this.key = cipherParameters instanceof ParametersWithRandom ? (RSAKeyParameters)((ParametersWithRandom)cipherParameters).getParameters() : (RSAKeyParameters)cipherParameters;
        this.forEncryption = bl;
    }

    public int getInputBlockSize() {
        RSACoreEngine rSACoreEngine = this;
        int n = rSACoreEngine.key.getModulus().bitLength();
        if (rSACoreEngine.forEncryption) {
            return (n + 7) / 8 - 1;
        }
        return (n + 7) / 8;
    }

    public int getOutputBlockSize() {
        RSACoreEngine rSACoreEngine = this;
        int n = rSACoreEngine.key.getModulus().bitLength();
        if (rSACoreEngine.forEncryption) {
            return (n + 7) / 8;
        }
        return (n + 7) / 8 - 1;
    }

    public BigInteger convertInput(byte[] byArray, int n, int n2) {
        if (n2 <= this.getInputBlockSize() + 1) {
            BigInteger bigInteger;
            if (n2 == this.getInputBlockSize() + 1 && !this.forEncryption) {
                throw new DataLengthException("input too large for RSA cipher.");
            }
            if (n != 0 || n2 != byArray.length) {
                byte[] byArray2 = byArray;
                byArray = new byte[n2];
                System.arraycopy(byArray2, n, byArray, 0, n2);
            }
            BigInteger bigInteger2 = bigInteger;
            bigInteger2(1, byArray);
            if (bigInteger.compareTo(this.key.getModulus()) < 0) {
                return bigInteger2;
            }
            throw new DataLengthException("input too large for RSA cipher.");
        }
        throw new DataLengthException("input too large for RSA cipher.");
    }

    public byte[] convertOutput(BigInteger object) {
        byte[] byArray;
        object = ((BigInteger)object).toByteArray();
        if (this.forEncryption) {
            if (object[0] == false && ((Object)object).length > this.getOutputBlockSize()) {
                int n = ((Object)object).length - 1;
                byte[] byArray2 = new byte[n];
                System.arraycopy(object, 1, byArray2, 0, n);
                return byArray2;
            }
            if (((Object)object).length < this.getOutputBlockSize()) {
                int n = this.getOutputBlockSize();
                byte[] byArray3 = new byte[n];
                Object object2 = object;
                int n2 = ((Object)object2).length;
                System.arraycopy(object2, 0, byArray3, n -= ((Object)object).length, n2);
                return byArray3;
            }
            return object;
        }
        if (object[0] == false) {
            Object object3 = object;
            int n = ((Object)object3).length - 1;
            byArray = new byte[n];
            System.arraycopy(object3, 1, byArray, 0, n);
        } else {
            Object object4 = object;
            int n = ((Object)object4).length;
            byArray = new byte[n];
            System.arraycopy(object4, 0, byArray, 0, n);
        }
        Arrays.fill((byte[])object, (byte)0);
        return byArray;
    }

    public BigInteger processBlock(BigInteger bigInteger) {
        Object object = ((RSACoreEngine)((Object)bigInteger2)).key;
        if (object instanceof RSAPrivateCrtKeyParameters) {
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)object;
            BigInteger bigInteger2 = rSAPrivateCrtKeyParameters.getP();
            object = rSAPrivateCrtKeyParameters.getQ();
            BigInteger bigInteger3 = rSAPrivateCrtKeyParameters.getDP();
            BigInteger bigInteger4 = rSAPrivateCrtKeyParameters.getDQ();
            BigInteger bigInteger5 = rSAPrivateCrtKeyParameters.getQInv();
            BigInteger bigInteger6 = bigInteger.remainder(bigInteger2).modPow(bigInteger3, bigInteger2);
            bigInteger = bigInteger.remainder((BigInteger)object).modPow(bigInteger4, (BigInteger)object);
            return bigInteger6.subtract(bigInteger).multiply(bigInteger5).mod(bigInteger2).multiply((BigInteger)object).add(bigInteger);
        }
        return bigInteger.modPow(((RSAKeyParameters)object).getExponent(), ((RSACoreEngine)((Object)bigInteger2)).key.getModulus());
    }
}

