/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.TweakableBlockCipherParameters;

public class ThreefishEngine
implements BlockCipher {
    public static final int BLOCKSIZE_256 = 256;
    public static final int BLOCKSIZE_512 = 512;
    public static final int BLOCKSIZE_1024 = 1024;
    private static final int TWEAK_SIZE_BYTES = 16;
    private static final int TWEAK_SIZE_WORDS = 2;
    private static final int ROUNDS_256 = 72;
    private static final int ROUNDS_512 = 72;
    private static final int ROUNDS_1024 = 80;
    private static final int MAX_ROUNDS = 80;
    private static final long C_240 = 2004413935125273122L;
    private static int[] MOD9 = new int[80];
    private static int[] MOD17 = new int[MOD9.length];
    private static int[] MOD5 = new int[MOD9.length];
    private static int[] MOD3 = new int[MOD9.length];
    private int blocksizeBytes;
    private int blocksizeWords;
    private long[] currentBlock;
    private long[] t;
    private long[] kw;
    private ThreefishCipher cipher;
    private boolean forEncryption;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ThreefishEngine(int n) {
        Object object;
        int n2;
        long[] lArray = new long[5];
        ((ThreefishEngine)object).t = lArray;
        ((ThreefishEngine)object).blocksizeBytes = n / 8;
        ((ThreefishEngine)object).blocksizeWords = n2 = ((ThreefishEngine)object).blocksizeBytes / 8;
        ((ThreefishEngine)object).currentBlock = new long[n2];
        long[] lArray2 = new long[n2 * 2 + 1];
        ((ThreefishEngine)object).kw = lArray2;
        if (n != 256) {
            if (n != 512) {
                Threefish1024Cipher threefish1024Cipher;
                if (n != 1024) throw new IllegalArgumentException("Invalid blocksize - Threefish is defined with block size of 256, 512, or 1024 bits");
                Object object2 = object;
                object = threefish1024Cipher;
                threefish1024Cipher = new Threefish1024Cipher(lArray2, lArray);
                ((ThreefishEngine)object2).cipher = object;
                return;
            } else {
                Threefish512Cipher threefish512Cipher;
                ThreefishEngine threefishEngine = object;
                object = threefish512Cipher;
                threefish512Cipher = new Threefish512Cipher(lArray2, lArray);
                threefishEngine.cipher = object;
            }
            return;
        } else {
            Threefish256Cipher threefish256Cipher;
            ThreefishEngine threefishEngine = object;
            object = threefish256Cipher;
            threefish256Cipher = new Threefish256Cipher(lArray2, lArray);
            threefishEngine.cipher = object;
        }
    }

    private void setKey(long[] lArray) {
        if (lArray.length == ((ThreefishEngine)object).blocksizeWords) {
            int n;
            long l = 2004413935125273122L;
            for (int k = 0; k < (n = ((ThreefishEngine)object).blocksizeWords); ++k) {
                long l2 = l;
                ((ThreefishEngine)object).kw[k] = l = lArray[k];
                l = l2 ^ l;
            }
            long[] lArray2 = ((ThreefishEngine)object).kw;
            Object object = lArray2;
            lArray2[n] = l;
            int n2 = n + 1;
            System.arraycopy(((ThreefishEngine)object).kw, 0, object, n2, n);
            return;
        }
        throw new IllegalArgumentException(b.a(b.b.a("Threefish key must be same size as block ("), ((ThreefishEngine)object).blocksizeWords, " words)"));
    }

    private void setTweak(long[] lArray) {
        if (lArray.length == 2) {
            long l;
            long[] lArray2 = ((ThreefishEngine)object).t;
            long[] lArray3 = ((ThreefishEngine)object).t;
            Object object = lArray2;
            long l2 = lArray[0];
            object[0] = l2;
            long l3 = lArray[1];
            object[1] = l3;
            lArray3[2] = l = l2 ^ l3;
            lArray2[3] = l2;
            lArray3[4] = l3;
            return;
        }
        throw new IllegalArgumentException("Tweak must be 2 words.");
    }

    public static long bytesToWord(byte[] byArray, int n) {
        if (n + 8 <= byArray.length) {
            return (long)byArray[n++] & 0xFFL | ((long)byArray[n++] & 0xFFL) << 8 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n] & 0xFFL) << 56;
        }
        throw new IllegalArgumentException();
    }

    public static void wordToBytes(long l, byte[] byArray, int n) {
        if (n + 8 <= byArray.length) {
            int n2 = n + 1;
            byArray[n] = (byte)l;
            int n3 = n2 + 1;
            byArray[n2] = (byte)(l >> 8);
            n2 = n3 + 1;
            byArray[n3] = (byte)(l >> 16);
            n3 = n2 + 1;
            byArray[n2] = (byte)(l >> 24);
            n2 = n3 + 1;
            byArray[n3] = (byte)(l >> 32);
            n3 = n2 + 1;
            byArray[n2] = (byte)(l >> 40);
            n2 = n3 + 1;
            byArray[n3] = (byte)(l >> 48);
            byArray[n2] = (byte)(l >> 56);
            return;
        }
        throw new IllegalArgumentException();
    }

    public static long rotlXor(long l, int n, long l2) {
        return (l << n | l >>> -n) ^ l2;
    }

    public static long xorRotr(long l, int n, long l2) {
        return (l ^= l2) >>> n | l << -n;
    }

    static {
        int n = 0;
        while (true) {
            int[] nArray = MOD9;
            if (n >= MOD9.length) break;
            int n2 = n;
            int n3 = n;
            ThreefishEngine.MOD17[n3] = n3 % 17;
            nArray[n2] = n2 % 9;
            int n4 = n;
            ThreefishEngine.MOD5[n4] = n4 % 5;
            int n5 = n++;
            ThreefishEngine.MOD3[n5] = n5 % 3;
        }
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        block12: {
            byte[] byArray;
            block11: {
                block10: {
                    if (!(object instanceof TweakableBlockCipherParameters)) break block10;
                    TweakableBlockCipherParameters tweakableBlockCipherParameters = (TweakableBlockCipherParameters)object;
                    object = tweakableBlockCipherParameters.getKey().getKey();
                    byArray = tweakableBlockCipherParameters.getTweak();
                    break block11;
                }
                if (!(object instanceof KeyParameter)) break block12;
                object = ((KeyParameter)object).getKey();
                byArray = null;
            }
            long[] lArray = null;
            long[] lArray2 = null;
            if (object != null) {
                if (((Object)object).length == this.blocksizeBytes) {
                    int n = this.blocksizeWords;
                    long[] lArray3 = new long[n];
                    for (int k = 0; k < n; ++k) {
                        lArray3[k] = ThreefishEngine.bytesToWord((byte[])object, k * 8);
                    }
                    lArray = lArray3;
                } else {
                    throw new IllegalArgumentException(b.a(b.b.a("Threefish key must be same size as block ("), this.blocksizeBytes, " bytes)"));
                }
            }
            if (byArray != null) {
                if (byArray.length == 16) {
                    long l;
                    long[] lArray4 = new long[2];
                    lArray2 = lArray4;
                    lArray2[0] = l = ThreefishEngine.bytesToWord(byArray, 0);
                    lArray4[1] = l = ThreefishEngine.bytesToWord(byArray, 8);
                } else {
                    throw new IllegalArgumentException("Threefish tweak must be 16 bytes");
                }
            }
            this.init(bl, lArray, lArray2);
            return;
        }
        throw new IllegalArgumentException(a.a((CipherParameters)object, b.b.a("Invalid parameter passed to Threefish init - ")));
    }

    public void init(boolean bl, long[] lArray, long[] lArray2) {
        this.forEncryption = bl;
        if (lArray != null) {
            this.setKey(lArray);
        }
        if (lArray2 != null) {
            this.setTweak(lArray2);
        }
    }

    @Override
    public String getAlgorithmName() {
        return b.b.a("Threefish-").append(this.blocksizeBytes * 8).toString();
    }

    @Override
    public int getBlockSize() {
        return this.blocksizeBytes;
    }

    @Override
    public void reset() {
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.blocksizeBytes;
        if (n + n3 <= byArray.length) {
            if (n2 + n3 <= byArray2.length) {
                for (n3 = 0; n3 < this.blocksizeBytes; n3 += 8) {
                    long l;
                    int n4 = n3;
                    int n5 = n4 >> 3;
                    this.currentBlock[n5] = l = ThreefishEngine.bytesToWord(byArray, n + n4);
                }
                ThreefishEngine threefishEngine = this;
                threefishEngine.processBlock(threefishEngine.currentBlock, threefishEngine.currentBlock);
                for (int k = 0; k < (n = this.blocksizeBytes); k += 8) {
                    ThreefishEngine.wordToBytes(this.currentBlock[k >> 3], byArray2, n2 + k);
                }
                return n;
            }
            throw new OutputLengthException("Output buffer too short");
        }
        throw new DataLengthException("Input buffer too short");
    }

    public int processBlock(long[] lArray, long[] lArray2) {
        int n = this.blocksizeWords;
        if (this.kw[n] != 0L) {
            if (lArray.length == n) {
                if (lArray2.length == n) {
                    if (this.forEncryption) {
                        this.cipher.encryptBlock(lArray, lArray2);
                    } else {
                        this.cipher.decryptBlock(lArray, lArray2);
                    }
                    return this.blocksizeWords;
                }
                throw new OutputLengthException("Output buffer too short");
            }
            throw new DataLengthException("Input buffer too short");
        }
        throw new IllegalStateException("Threefish engine not initialised");
    }

    public static final class Threefish1024Cipher
    extends ThreefishCipher {
        private static final int ROTATION_0_0 = 24;
        private static final int ROTATION_0_1 = 13;
        private static final int ROTATION_0_2 = 8;
        private static final int ROTATION_0_3 = 47;
        private static final int ROTATION_0_4 = 8;
        private static final int ROTATION_0_5 = 17;
        private static final int ROTATION_0_6 = 22;
        private static final int ROTATION_0_7 = 37;
        private static final int ROTATION_1_0 = 38;
        private static final int ROTATION_1_1 = 19;
        private static final int ROTATION_1_2 = 10;
        private static final int ROTATION_1_3 = 55;
        private static final int ROTATION_1_4 = 49;
        private static final int ROTATION_1_5 = 18;
        private static final int ROTATION_1_6 = 23;
        private static final int ROTATION_1_7 = 52;
        private static final int ROTATION_2_0 = 33;
        private static final int ROTATION_2_1 = 4;
        private static final int ROTATION_2_2 = 51;
        private static final int ROTATION_2_3 = 13;
        private static final int ROTATION_2_4 = 34;
        private static final int ROTATION_2_5 = 41;
        private static final int ROTATION_2_6 = 59;
        private static final int ROTATION_2_7 = 17;
        private static final int ROTATION_3_0 = 5;
        private static final int ROTATION_3_1 = 20;
        private static final int ROTATION_3_2 = 48;
        private static final int ROTATION_3_3 = 41;
        private static final int ROTATION_3_4 = 47;
        private static final int ROTATION_3_5 = 28;
        private static final int ROTATION_3_6 = 16;
        private static final int ROTATION_3_7 = 25;
        private static final int ROTATION_4_0 = 41;
        private static final int ROTATION_4_1 = 9;
        private static final int ROTATION_4_2 = 37;
        private static final int ROTATION_4_3 = 31;
        private static final int ROTATION_4_4 = 12;
        private static final int ROTATION_4_5 = 47;
        private static final int ROTATION_4_6 = 44;
        private static final int ROTATION_4_7 = 30;
        private static final int ROTATION_5_0 = 16;
        private static final int ROTATION_5_1 = 34;
        private static final int ROTATION_5_2 = 56;
        private static final int ROTATION_5_3 = 51;
        private static final int ROTATION_5_4 = 4;
        private static final int ROTATION_5_5 = 53;
        private static final int ROTATION_5_6 = 42;
        private static final int ROTATION_5_7 = 41;
        private static final int ROTATION_6_0 = 31;
        private static final int ROTATION_6_1 = 44;
        private static final int ROTATION_6_2 = 47;
        private static final int ROTATION_6_3 = 46;
        private static final int ROTATION_6_4 = 19;
        private static final int ROTATION_6_5 = 42;
        private static final int ROTATION_6_6 = 44;
        private static final int ROTATION_6_7 = 25;
        private static final int ROTATION_7_0 = 9;
        private static final int ROTATION_7_1 = 48;
        private static final int ROTATION_7_2 = 35;
        private static final int ROTATION_7_3 = 52;
        private static final int ROTATION_7_4 = 23;
        private static final int ROTATION_7_5 = 31;
        private static final int ROTATION_7_6 = 37;
        private static final int ROTATION_7_7 = 20;

        public Threefish1024Cipher(long[] lArray, long[] lArray2) {
            super(lArray, lArray2);
        }

        @Override
        public void encryptBlock(long[] lArray, long[] lArray2) {
            Threefish1024Cipher threefish1024Cipher = object;
            Object object = threefish1024Cipher.kw;
            long[] lArray3 = threefish1024Cipher.t;
            int[] nArray = MOD17;
            int[] nArray2 = MOD3;
            if (((Object)object).length == 33) {
                if (lArray3.length == 5) {
                    long l = lArray[0];
                    long l2 = lArray[1];
                    long l3 = lArray[2];
                    long l4 = lArray[3];
                    long l5 = lArray[4];
                    long l6 = lArray[5];
                    long l7 = lArray[6];
                    long l8 = lArray[7];
                    long l9 = lArray[8];
                    long l10 = lArray[9];
                    long l11 = lArray[10];
                    long l12 = lArray[11];
                    long l13 = lArray[12];
                    Object object2 = lArray[13];
                    Object object3 = lArray[14];
                    Object object4 = object;
                    l += object[0];
                    l2 += object[1];
                    l3 += object[2];
                    l4 += object[3];
                    l5 += object[4];
                    l6 += object[5];
                    l7 += object[6];
                    l8 += object[7];
                    l9 += object[8];
                    l10 += object[9];
                    l11 += object[10];
                    l12 += object[11];
                    l13 += object[12];
                    object2 = object4[13] + lArray3[0] + object2;
                    object3 = object4[14] + lArray3[1] + object3;
                    Object object5 = lArray[15] + object4[15];
                    for (int k = 1; k < 20; k += 2) {
                        int n = nArray[k];
                        Object object6 = object;
                        int n2 = nArray2[k];
                        long l14 = l + l2;
                        long l15 = ThreefishEngine.rotlXor(l2, 24, l14);
                        long l16 = l3 + l4;
                        long l17 = ThreefishEngine.rotlXor(l4, 13, l16);
                        Object object7 = l5 + l6;
                        long l18 = ThreefishEngine.rotlXor(l6, 8, object7);
                        Object object8 = l7 + l8;
                        long l19 = ThreefishEngine.rotlXor(l8, 47, object8);
                        long l20 = l9 + l10;
                        long l21 = ThreefishEngine.rotlXor(l10, 8, l20);
                        long l22 = l11 + l12;
                        long l23 = ThreefishEngine.rotlXor(l12, 17, l22);
                        long l24 = l13 + object2;
                        long l25 = l19;
                        long l26 = l22;
                        long l27 = l19;
                        l19 = ThreefishEngine.rotlXor(object2, 22, l24);
                        l22 = object3 + object5;
                        Object object9 = ThreefishEngine.rotlXor(object5, 37, l22);
                        long l28 = object7;
                        long l29 = object8;
                        long l30 = l16;
                        l16 = ThreefishEngine.rotlXor(l21, 38, l14 += l21);
                        object7 = l30 + l19;
                        object8 = ThreefishEngine.rotlXor(l19, 19, object7);
                        l19 = l29 + l23;
                        l21 = ThreefishEngine.rotlXor(l23, 10, l19);
                        l23 = l28 + object9;
                        object9 = ThreefishEngine.rotlXor(object9, 55, l23);
                        long l31 = l26 + l27;
                        long l32 = ThreefishEngine.rotlXor(l25, 49, l31);
                        long l33 = l15;
                        long l34 = l15;
                        l15 = ThreefishEngine.rotlXor(l17, 18, l24 += l17);
                        l17 = l22 + l18;
                        l18 = ThreefishEngine.rotlXor(l18, 23, l17);
                        long l35 = ThreefishEngine.rotlXor(l33, 52, l20 += l34);
                        l22 = l35;
                        long l36 = l19;
                        long l37 = l22;
                        long l38 = l15;
                        long l39 = l15;
                        l15 = ThreefishEngine.rotlXor(l32, 33, l14 += l32);
                        object7 += l18;
                        l18 = ThreefishEngine.rotlXor(l18, 4, object7);
                        l19 = l23 + l39;
                        l22 = ThreefishEngine.rotlXor(l38, 51, l19);
                        l23 = l36 + l37;
                        l32 = ThreefishEngine.rotlXor(l35, 13, l23);
                        l24 += object9;
                        long l40 = l22;
                        long l41 = l21;
                        long l42 = l20;
                        long l43 = object8;
                        long l44 = l17;
                        l17 = ThreefishEngine.rotlXor(object9, 34, l24);
                        object8 = l44 + object8;
                        l20 = ThreefishEngine.rotlXor(l43, 41, object8);
                        l21 = l42 + l21;
                        object9 = ThreefishEngine.rotlXor(l41, 59, l21);
                        l31 += l16;
                        long l45 = l22;
                        long l46 = l18;
                        long l47 = l21;
                        long l48 = l18;
                        long l49 = object8;
                        long l50 = ThreefishEngine.rotlXor(l16, 17, l31);
                        long l51 = l16 = l50;
                        l16 = ThreefishEngine.rotlXor(l17, 5, l14 += l17);
                        l17 = object7 + object9;
                        object7 = ThreefishEngine.rotlXor(object9, 20, l17);
                        l18 = l23 + l20;
                        object8 = ThreefishEngine.rotlXor(l20, 48, l18);
                        l20 = ThreefishEngine.rotlXor(l50, 41, l19 += l51);
                        l21 = l49 + l32;
                        l22 = ThreefishEngine.rotlXor(l32, 47, l21);
                        l23 = l47 + l48;
                        object9 = ThreefishEngine.rotlXor(l46, 28, l23);
                        l32 = ThreefishEngine.rotlXor(l40, 16, l31 += l45);
                        long l52 = l24 + l15;
                        l24 = l52;
                        long l53 = object7;
                        long l54 = l20;
                        long l55 = l19;
                        long l56 = l17;
                        l14 += object[n];
                        int n3 = n + 1;
                        l17 = l22 + object[n3];
                        int n4 = n + 2;
                        object7 = l56 + object[n4];
                        int n5 = n + 3;
                        l19 = l32 + object[n5];
                        int n6 = n + 4;
                        l20 = l55 + object[n6];
                        int n7 = n + 5;
                        l12 = object9 + object[n7];
                        int n8 = n + 6;
                        object9 = l18 + object[n8];
                        int n9 = n + 7;
                        object3 = ThreefishEngine.rotlXor(l15, 25, l24) + object[n9];
                        int n10 = n + 8;
                        l24 = l23 + object[n10];
                        int n11 = n + 9;
                        long l57 = l54 + object[n11];
                        int n12 = n + 10;
                        long l58 = l31 + object[n12];
                        int n13 = n + 11;
                        long l59 = l53 + object[n13];
                        int n14 = n + 12;
                        long l60 = l59;
                        long l61 = l58;
                        long l62 = l59;
                        Object object10 = object3;
                        long l63 = object9;
                        Object object11 = object3;
                        long l64 = l12;
                        long l65 = l20;
                        long l66 = l12;
                        long l67 = l19;
                        long l68 = l19;
                        long l69 = l17;
                        long l70 = l17;
                        Object object12 = object;
                        int n15 = n + 13;
                        l17 = (long)(object12[n15] + lArray3[n2] + object8);
                        int n16 = n + 14;
                        int n17 = n2 + 1;
                        object8 = object12[n16] + lArray3[n17] + l21;
                        int n18 = n + 15;
                        l19 = k;
                        l16 = (long)(object12[n18] + l19 + l16);
                        l20 = l14 + l70;
                        l21 = ThreefishEngine.rotlXor(l69, 41, l20);
                        l12 = object7 + l68;
                        object9 = ThreefishEngine.rotlXor(l67, 9, l12);
                        object3 = l65 + l66;
                        long l71 = ThreefishEngine.rotlXor(l64, 37, object3);
                        long l72 = l63 + object11;
                        l58 = ThreefishEngine.rotlXor(object10, 31, l72);
                        l59 = l24 + l57;
                        long l73 = ThreefishEngine.rotlXor(l57, 12, l59);
                        long l74 = l61 + l62;
                        long l75 = ThreefishEngine.rotlXor(l60, 47, l74);
                        long l76 = l52 + object[n14] + l17;
                        long l77 = l58;
                        long l78 = l58;
                        Object object13 = l16;
                        Object object14 = l16;
                        l16 = ThreefishEngine.rotlXor(l17, 44, l76);
                        l17 = object8 + object14;
                        long l79 = ThreefishEngine.rotlXor(object13, 30, l17);
                        object8 = l79;
                        Object object15 = object3;
                        long l80 = object8;
                        long l81 = l16;
                        long l82 = l16;
                        l16 = l20 + l73;
                        object8 = ThreefishEngine.rotlXor(l73, 16, l16);
                        l20 = l12 + l82;
                        l12 = ThreefishEngine.rotlXor(l81, 34, l20);
                        object3 = l72 + l75;
                        l72 = ThreefishEngine.rotlXor(l75, 56, object3);
                        l58 = object15 + l80;
                        l73 = ThreefishEngine.rotlXor(l79, 51, l58);
                        l75 = ThreefishEngine.rotlXor(l77, 4, l74 += l78);
                        long l83 = l21;
                        long l84 = l21;
                        long l85 = l17;
                        l17 = ThreefishEngine.rotlXor(object9, 53, l76 += object9);
                        l21 = l85 + l71;
                        object9 = ThreefishEngine.rotlXor(l71, 42, l21);
                        l71 = l59 + l84;
                        long l86 = ThreefishEngine.rotlXor(l83, 41, l71);
                        l59 = l86;
                        Object object16 = object3;
                        long l87 = l17;
                        long l88 = l17;
                        l17 = ThreefishEngine.rotlXor(l75, 31, l16 += l75);
                        l20 += object9;
                        object9 = ThreefishEngine.rotlXor(object9, 44, l20);
                        object3 = l58 + l88;
                        l58 = ThreefishEngine.rotlXor(l87, 47, object3);
                        l59 = object16 + l59;
                        l75 = ThreefishEngine.rotlXor(l86, 46, l59);
                        l76 += l73;
                        long l89 = l58;
                        long l90 = l72;
                        long l91 = l71;
                        long l92 = l12;
                        long l93 = l21;
                        l21 = ThreefishEngine.rotlXor(l73, 19, l76);
                        l12 = l93 + l12;
                        l71 = ThreefishEngine.rotlXor(l92, 42, l12);
                        l72 = l91 + l72;
                        l73 = ThreefishEngine.rotlXor(l90, 44, l72);
                        l74 += object8;
                        long l94 = l58;
                        long l95 = object9;
                        long l96 = l72;
                        long l97 = object9;
                        long l98 = l12;
                        long l99 = ThreefishEngine.rotlXor(object8, 25, l74);
                        Object object17 = object8 = l99;
                        object8 = ThreefishEngine.rotlXor(l21, 9, l16 += l21);
                        l21 = ThreefishEngine.rotlXor(l73, 48, l20 += l73);
                        l12 = l59 + l71;
                        object9 = ThreefishEngine.rotlXor(l71, 35, l12);
                        l71 = ThreefishEngine.rotlXor(l99, 52, object3 += object17);
                        l72 = l98 + l75;
                        l58 = ThreefishEngine.rotlXor(l75, 23, l72);
                        l59 = l96 + l97;
                        l73 = ThreefishEngine.rotlXor(l95, 31, l59);
                        l75 = ThreefishEngine.rotlXor(l89, 37, l74 += l94);
                        long l100 = l21;
                        long l101 = ThreefishEngine.rotlXor(l17, 20, l76 += l17);
                        l14 = l16 + object[n3];
                        l15 = l58 + object[n4];
                        l16 = l20 + object[n5];
                        l17 = l75 + object[n6];
                        l18 = object3 + object[n7];
                        l20 = l73 + object[n8];
                        l21 = l12 + object[n9];
                        l22 = l101 + object[n10];
                        l23 = l59 + object[n11];
                        l31 = l71 + object[n12];
                        l32 = l74 + object[n13];
                        long l102 = l100 + object[n14];
                        long l103 = l76 + object[n15];
                        object9 = object6[n16] + lArray3[n17] + object9;
                        object7 = object6[n18] + lArray3[n2 + 2] + l72;
                        object8 = object[n + 16] + l19 + 1L + object8;
                        object5 = object8;
                        object3 = object7;
                        object2 = object9;
                        l13 = l103;
                        l12 = l102;
                        l11 = l32;
                        l10 = l31;
                        l9 = l23;
                        l8 = l22;
                        l7 = l21;
                        l6 = l20;
                        l5 = l18;
                        l4 = l17;
                        l3 = l16;
                        l2 = l15;
                        l = l14;
                    }
                    long[] lArray4 = lArray2;
                    long[] lArray5 = lArray2;
                    lArray4[0] = l;
                    lArray5[1] = l2;
                    lArray4[2] = l3;
                    lArray5[3] = l4;
                    lArray4[4] = l5;
                    lArray5[5] = l6;
                    lArray4[6] = l7;
                    lArray5[7] = l8;
                    lArray4[8] = l9;
                    lArray5[9] = l10;
                    lArray4[10] = l11;
                    lArray5[11] = l12;
                    lArray4[12] = l13;
                    lArray5[13] = object2;
                    lArray4[14] = object3;
                    lArray5[15] = object5;
                    return;
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void decryptBlock(long[] lArray, long[] lArray2) {
            Threefish1024Cipher threefish1024Cipher = object;
            Object object = threefish1024Cipher.kw;
            long[] lArray3 = threefish1024Cipher.t;
            int[] nArray = MOD17;
            int[] nArray2 = MOD3;
            if (((Object)object).length == 33) {
                if (lArray3.length == 5) {
                    long l = lArray[0];
                    long l2 = lArray[1];
                    long l3 = lArray[2];
                    long l4 = lArray[3];
                    long l5 = lArray[4];
                    long l6 = lArray[5];
                    long l7 = lArray[6];
                    long l8 = lArray[7];
                    long l9 = lArray[8];
                    long l10 = lArray[9];
                    long l11 = lArray[10];
                    long l12 = lArray[11];
                    long l13 = lArray[12];
                    long l14 = lArray[13];
                    long l15 = lArray[14];
                    long l16 = lArray[15];
                    for (int k = 19; k >= 1; k -= 2) {
                        long l17 = l13;
                        long l18 = l10;
                        long l19 = l7;
                        long l20 = l4;
                        int n = nArray[k];
                        int n2 = nArray2[k];
                        int n3 = n + 1;
                        long l21 = l - object[n3];
                        int n4 = n + 2;
                        l4 = l2 - object[n4];
                        int n5 = n + 3;
                        long l22 = l3 - object[n5];
                        int n6 = n + 4;
                        l7 = l20 - object[n6];
                        int n7 = n + 5;
                        long l23 = l5 - object[n7];
                        int n8 = n + 6;
                        l10 = l6 - object[n8];
                        int n9 = n + 7;
                        long l24 = l19 - object[n9];
                        int n10 = n + 8;
                        l13 = l8 - object[n10];
                        int n11 = n + 9;
                        long l25 = l9 - object[n11];
                        int n12 = n + 10;
                        long l26 = l18 - object[n12];
                        int n13 = n + 11;
                        long l27 = l11 - object[n13];
                        int n14 = n + 12;
                        long l28 = l12 - object[n14];
                        int n15 = n + 13;
                        long l29 = l17 - object[n15];
                        int n16 = n + 14;
                        int n17 = n2 + 1;
                        long l30 = l14 - (object[n16] + lArray3[n17]);
                        int n18 = n + 15;
                        long l31 = l15 - (object[n18] + lArray3[n2 + 2]);
                        long l32 = l31;
                        long l33 = l4;
                        long l34 = l23;
                        long l35 = l26;
                        long l36 = l24;
                        long l37 = l22;
                        long l38 = l21;
                        l4 = k;
                        l21 = ThreefishEngine.xorRotr(l16 - (object[n + 16] + l4 + 1L), 9, l21);
                        l16 = l38 - l21;
                        l22 = ThreefishEngine.xorRotr(l28, 48, l22);
                        l26 = l37 - l22;
                        l24 = ThreefishEngine.xorRotr(l30, 35, l24);
                        l28 = l36 - l24;
                        l23 = ThreefishEngine.xorRotr(l35, 52, l23);
                        l30 = l34 - l23;
                        l32 = ThreefishEngine.xorRotr(l33, 23, l32);
                        long l39 = l31 - l32;
                        long l40 = l24;
                        long l41 = l13;
                        long l42 = l7;
                        l7 = ThreefishEngine.xorRotr(l10, 31, l25);
                        l10 = l25 - l7;
                        l24 = ThreefishEngine.xorRotr(l42, 37, l27);
                        l13 = l27 - l24;
                        l25 = ThreefishEngine.xorRotr(l41, 20, l29);
                        long l43 = l29 - l25;
                        l27 = l43;
                        long l44 = l21;
                        long l45 = l28;
                        long l46 = l24;
                        long l47 = l7;
                        l21 = ThreefishEngine.xorRotr(l25, 31, l16);
                        l7 = l16 - l21;
                        l24 = ThreefishEngine.xorRotr(l47, 44, l26);
                        l25 = l26 - l24;
                        l16 = ThreefishEngine.xorRotr(l46, 47, l30);
                        l26 = l30 - l16;
                        l28 = ThreefishEngine.xorRotr(l32, 46, l28);
                        l29 = l45 - l28;
                        l27 = ThreefishEngine.xorRotr(l44, 19, l27);
                        l30 = l43 - l27;
                        l32 = ThreefishEngine.xorRotr(l40, 42, l39);
                        l39 -= l32;
                        long l48 = l24;
                        long l49 = l16;
                        long l50 = l23;
                        l22 = ThreefishEngine.xorRotr(l22, 44, l10);
                        l23 = l10 - l22;
                        l10 = ThreefishEngine.xorRotr(l50, 25, l13);
                        long l51 = l13 - l10;
                        l24 = l51;
                        long l52 = l21;
                        long l53 = l22;
                        l21 = ThreefishEngine.xorRotr(l10, 16, l7);
                        l22 = l7 - l21;
                        l7 = ThreefishEngine.xorRotr(l32, 34, l25);
                        l10 = l25 - l7;
                        l13 = ThreefishEngine.xorRotr(l53, 56, l29);
                        l25 = l29 - l13;
                        l16 = ThreefishEngine.xorRotr(l27, 51, l26);
                        l26 -= l16;
                        l24 = ThreefishEngine.xorRotr(l52, 4, l24);
                        l27 = l51 - l24;
                        l29 = ThreefishEngine.xorRotr(l49, 53, l30);
                        l30 -= l29;
                        l32 = ThreefishEngine.xorRotr(l48, 42, l39);
                        l39 -= l32;
                        long l54 = l16;
                        long l55 = l7;
                        long l56 = l27;
                        long l57 = l13;
                        l7 = ThreefishEngine.xorRotr(l28, 41, l23);
                        long l58 = l23 - l7;
                        l23 = l58;
                        long l59 = l21;
                        long l60 = l25;
                        long l61 = l24;
                        l21 = ThreefishEngine.xorRotr(l7, 41, l22);
                        l22 -= l21;
                        l7 = ThreefishEngine.xorRotr(l29, 9, l10);
                        l10 -= l7;
                        l24 = ThreefishEngine.xorRotr(l32, 37, l26);
                        l13 = l26 - l24;
                        l25 = ThreefishEngine.xorRotr(l61, 31, l25);
                        l16 = l60 - l25;
                        l23 = ThreefishEngine.xorRotr(l59, 12, l23);
                        l26 = l58 - l23;
                        l27 = ThreefishEngine.xorRotr(l57, 47, l27);
                        l28 = l56 - l27;
                        l29 = ThreefishEngine.xorRotr(l55, 44, l30);
                        l30 -= l29;
                        l32 = ThreefishEngine.xorRotr(l54, 30, l39);
                        l2 = l22 - object[n];
                        l3 = l21 - object[n3];
                        l5 = l10 - object[n4];
                        l6 = l7 - object[n5];
                        l7 = l13 - object[n6];
                        l8 = l24 - object[n7];
                        l9 = l16 - object[n8];
                        l10 = l25 - object[n9];
                        l11 = l26 - object[n10];
                        l12 = l23 - object[n11];
                        l13 = l28 - object[n12];
                        l14 = l27 - object[n13];
                        l15 = l30 - object[n14];
                        l = l29 - (object[n15] + lArray3[n2]);
                        l16 = l39 - l32 - (object[n16] + lArray3[n17]);
                        long l62 = l3;
                        long l63 = l7;
                        long l64 = l;
                        l = ThreefishEngine.xorRotr(l32 - (object[n18] + l4), 5, l2);
                        l2 -= l;
                        l3 = ThreefishEngine.xorRotr(l14, 20, l5);
                        l4 = l5 - l3;
                        l5 = ThreefishEngine.xorRotr(l64, 48, l9);
                        l9 -= l5;
                        l7 = ThreefishEngine.xorRotr(l12, 41, l7);
                        l12 = l63 - l7;
                        l14 = ThreefishEngine.xorRotr(l62, 47, l16);
                        l16 -= l14;
                        long l65 = l5;
                        long l66 = l10;
                        long l67 = l6;
                        l5 = ThreefishEngine.xorRotr(l8, 28, l11);
                        l6 = l11 - l5;
                        l8 = ThreefishEngine.xorRotr(l67, 16, l13);
                        l10 = l13 - l8;
                        l11 = ThreefishEngine.xorRotr(l66, 25, l15);
                        long l68 = l15 - l11;
                        l13 = l68;
                        long l69 = l;
                        long l70 = l9;
                        long l71 = l4;
                        l = ThreefishEngine.xorRotr(l11, 33, l2);
                        l2 -= l;
                        l4 = ThreefishEngine.xorRotr(l5, 4, l4);
                        l5 = l71 - l4;
                        l8 = ThreefishEngine.xorRotr(l8, 51, l12);
                        l11 = l12 - l8;
                        l9 = ThreefishEngine.xorRotr(l14, 13, l9);
                        l12 = l70 - l9;
                        l13 = ThreefishEngine.xorRotr(l69, 34, l13);
                        l14 = l68 - l13;
                        l15 = ThreefishEngine.xorRotr(l65, 41, l16);
                        l16 -= l15;
                        long l72 = l4;
                        long l73 = l8;
                        l3 = ThreefishEngine.xorRotr(l3, 59, l6);
                        l4 = l6 - l3;
                        l6 = ThreefishEngine.xorRotr(l7, 17, l10);
                        long l74 = l10 - l6;
                        l7 = l74;
                        long l75 = l;
                        long l76 = l3;
                        l = ThreefishEngine.xorRotr(l6, 38, l2);
                        l2 -= l;
                        l3 = ThreefishEngine.xorRotr(l15, 19, l5);
                        l5 -= l3;
                        l6 = ThreefishEngine.xorRotr(l76, 10, l12);
                        l8 = l12 - l6;
                        l10 = ThreefishEngine.xorRotr(l13, 55, l11);
                        l11 -= l10;
                        l7 = ThreefishEngine.xorRotr(l75, 49, l7);
                        l12 = l74 - l7;
                        l13 = ThreefishEngine.xorRotr(l73, 18, l14);
                        l15 = ThreefishEngine.xorRotr(l72, 23, l16);
                        long l77 = l16 - l15;
                        l16 = l77;
                        long l78 = l10;
                        long l79 = l14 -= l13;
                        long l80 = l3;
                        long l81 = l12;
                        long l82 = l6;
                        l3 = ThreefishEngine.xorRotr(l9, 52, l4);
                        l4 -= l3;
                        long l83 = l;
                        long l84 = l8;
                        long l85 = l7;
                        long l86 = l2;
                        l2 = ThreefishEngine.xorRotr(l3, 24, l2);
                        l = l86 - l2;
                        l3 = ThreefishEngine.xorRotr(l13, 13, l5);
                        l5 -= l3;
                        l6 = ThreefishEngine.xorRotr(l15, 8, l11);
                        l7 = l11 - l6;
                        l8 = ThreefishEngine.xorRotr(l85, 47, l8);
                        l9 = l84 - l8;
                        l10 = ThreefishEngine.xorRotr(l83, 8, l4);
                        l4 -= l10;
                        l12 = ThreefishEngine.xorRotr(l82, 17, l12);
                        l11 = l81 - l12;
                        l14 = ThreefishEngine.xorRotr(l80, 22, l14);
                        l13 = l79 - l14;
                        l16 = ThreefishEngine.xorRotr(l78, 37, l16);
                        l15 = l77 - l16;
                        long l87 = l5;
                        long l88 = l7;
                        long l89 = l9;
                        l9 = l4;
                        l7 = l89;
                        l5 = l88;
                        l4 = l3;
                        l3 = l87;
                    }
                    long[] lArray4 = lArray2;
                    long[] lArray5 = lArray2;
                    long l90 = l - object[0];
                    long l91 = l2 - object[1];
                    l = l3 - object[2];
                    l2 = l4 - object[3];
                    l3 = l5 - object[4];
                    l4 = l6 - object[5];
                    l5 = l7 - object[6];
                    l6 = l8 - object[7];
                    l7 = l9 - object[8];
                    l8 = l10 - object[9];
                    l9 = l11 - object[10];
                    l10 = l12 - object[11];
                    l11 = l13 - object[12];
                    l12 = l14 - (object[13] + lArray3[0]);
                    l13 = l15 - (object[14] + lArray3[1]);
                    l14 = l16 - object[15];
                    lArray4[0] = l90;
                    lArray5[1] = l91;
                    lArray4[2] = l;
                    lArray5[3] = l2;
                    lArray4[4] = l3;
                    lArray5[5] = l4;
                    lArray4[6] = l5;
                    lArray5[7] = l6;
                    lArray4[8] = l7;
                    lArray5[9] = l8;
                    lArray4[10] = l9;
                    lArray5[11] = l10;
                    lArray4[12] = l11;
                    lArray5[13] = l12;
                    lArray4[14] = l13;
                    lArray5[15] = l14;
                    return;
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }
    }

    public static final class Threefish512Cipher
    extends ThreefishCipher {
        private static final int ROTATION_0_0 = 46;
        private static final int ROTATION_0_1 = 36;
        private static final int ROTATION_0_2 = 19;
        private static final int ROTATION_0_3 = 37;
        private static final int ROTATION_1_0 = 33;
        private static final int ROTATION_1_1 = 27;
        private static final int ROTATION_1_2 = 14;
        private static final int ROTATION_1_3 = 42;
        private static final int ROTATION_2_0 = 17;
        private static final int ROTATION_2_1 = 49;
        private static final int ROTATION_2_2 = 36;
        private static final int ROTATION_2_3 = 39;
        private static final int ROTATION_3_0 = 44;
        private static final int ROTATION_3_1 = 9;
        private static final int ROTATION_3_2 = 54;
        private static final int ROTATION_3_3 = 56;
        private static final int ROTATION_4_0 = 39;
        private static final int ROTATION_4_1 = 30;
        private static final int ROTATION_4_2 = 34;
        private static final int ROTATION_4_3 = 24;
        private static final int ROTATION_5_0 = 13;
        private static final int ROTATION_5_1 = 50;
        private static final int ROTATION_5_2 = 10;
        private static final int ROTATION_5_3 = 17;
        private static final int ROTATION_6_0 = 25;
        private static final int ROTATION_6_1 = 29;
        private static final int ROTATION_6_2 = 39;
        private static final int ROTATION_6_3 = 43;
        private static final int ROTATION_7_0 = 8;
        private static final int ROTATION_7_1 = 35;
        private static final int ROTATION_7_2 = 56;
        private static final int ROTATION_7_3 = 22;

        public Threefish512Cipher(long[] lArray, long[] lArray2) {
            super(lArray, lArray2);
        }

        @Override
        public void encryptBlock(long[] lArray, long[] lArray2) {
            Threefish512Cipher threefish512Cipher = object;
            Object object = threefish512Cipher.kw;
            long[] lArray3 = threefish512Cipher.t;
            int[] nArray = MOD9;
            int[] nArray2 = MOD3;
            if (((Object)object).length == 17) {
                if (lArray3.length == 5) {
                    long l = lArray[0];
                    long l2 = lArray[1];
                    long l3 = lArray[2];
                    long l4 = lArray[3];
                    long l5 = lArray[4];
                    Object object2 = lArray[5];
                    Object object3 = lArray[6];
                    Object object4 = object;
                    l += object[0];
                    l2 += object[1];
                    l3 += object[2];
                    l4 += object[3];
                    l5 += object[4];
                    object2 = object4[5] + lArray3[0] + object2;
                    object3 = object4[6] + lArray3[1] + object3;
                    Object object5 = lArray[7] + object4[7];
                    for (int k = 1; k < 18; k += 2) {
                        int n = nArray[k];
                        Object object6 = object;
                        int n2 = nArray2[k];
                        long l6 = l + l2;
                        long l7 = ThreefishEngine.rotlXor(l2, 46, l6);
                        long l8 = l3 + l4;
                        long l9 = ThreefishEngine.rotlXor(l4, 36, l8);
                        Object object7 = l5 + object2;
                        long l10 = l7;
                        long l11 = l8;
                        long l12 = l7;
                        l7 = ThreefishEngine.rotlXor(object2, 19, object7);
                        l8 = object3 + object5;
                        long l13 = ThreefishEngine.rotlXor(object5, 37, l8);
                        Object object8 = l11 + l12;
                        long l14 = ThreefishEngine.rotlXor(l10, 33, object8);
                        long l15 = l9;
                        long l16 = l6;
                        long l17 = l7;
                        l6 = ThreefishEngine.rotlXor(l13, 27, object7 += l13);
                        l7 = l8 + l7;
                        l8 = ThreefishEngine.rotlXor(l17, 14, l7);
                        l9 = l16 + l9;
                        l13 = ThreefishEngine.rotlXor(l15, 42, l9);
                        long l18 = l8;
                        long l19 = l9;
                        long l20 = l8;
                        long l21 = l7;
                        l7 = ThreefishEngine.rotlXor(l14, 17, object7 += l14);
                        l8 = l21 + l13;
                        l9 = ThreefishEngine.rotlXor(l13, 49, l8);
                        l13 = l19 + l20;
                        l14 = ThreefishEngine.rotlXor(l18, 36, l13);
                        long l22 = ThreefishEngine.rotlXor(l6, 39, object8 += l6);
                        long l23 = l6 = l22;
                        l6 = l8 + l7;
                        l7 = ThreefishEngine.rotlXor(l7, 44, l6);
                        l8 = l13 + l23;
                        l13 = ThreefishEngine.rotlXor(l22, 9, l8);
                        object8 += l14;
                        l14 = ThreefishEngine.rotlXor(l14, 54, object8);
                        long l24 = object7 + l9;
                        object7 = l24;
                        long l25 = l7;
                        l7 = l8 + object[n];
                        int n3 = n + 1;
                        l4 = l25 + object[n3];
                        int n4 = n + 2;
                        object8 += object[n4];
                        int n5 = n + 3;
                        object7 = ThreefishEngine.rotlXor(l9, 56, object7) + object[n5];
                        int n6 = n + 4;
                        long l26 = l4;
                        long l27 = l4;
                        Object object9 = object;
                        int n7 = n + 5;
                        l4 = (long)(object9[n7] + lArray3[n2] + l14);
                        int n8 = n + 6;
                        int n9 = n2 + 1;
                        l6 = (long)(object9[n8] + lArray3[n9] + l6);
                        int n10 = n + 7;
                        l14 = k;
                        l13 = (long)(object9[n10] + l14 + l13);
                        long l28 = l7 + l27;
                        long l29 = ThreefishEngine.rotlXor(l26, 39, l28);
                        long l30 = object8 + object7;
                        long l31 = ThreefishEngine.rotlXor(object7, 30, l30);
                        long l32 = l24 + object[n6] + l4;
                        long l33 = l29;
                        Object object10 = l6;
                        l6 = ThreefishEngine.rotlXor(l4, 34, l32);
                        l4 = object10 + l13;
                        l13 = ThreefishEngine.rotlXor(l13, 24, l4);
                        l29 = l30 + l29;
                        l30 = ThreefishEngine.rotlXor(l33, 13, l29);
                        long l34 = l6;
                        long l35 = l6;
                        l6 = ThreefishEngine.rotlXor(l13, 50, l32 += l13);
                        l13 = ThreefishEngine.rotlXor(l34, 10, l4 += l35);
                        l28 += l31;
                        l31 = ThreefishEngine.rotlXor(l31, 17, l28);
                        long l36 = l13;
                        long l37 = l28;
                        long l38 = l13;
                        long l39 = l4;
                        l4 = ThreefishEngine.rotlXor(l30, 25, l32 += l30);
                        l13 = l39 + l31;
                        l28 = ThreefishEngine.rotlXor(l31, 29, l13);
                        l30 = l37 + l38;
                        l31 = ThreefishEngine.rotlXor(l36, 39, l30);
                        long l40 = l29 + l6;
                        l29 = l40;
                        long l41 = ThreefishEngine.rotlXor(l6, 43, l29);
                        long l42 = l6 = l41;
                        l6 = l13 + l4;
                        l4 = ThreefishEngine.rotlXor(l4, 8, l6);
                        l13 = l30 + l42;
                        l29 = ThreefishEngine.rotlXor(l41, 35, l13);
                        l30 = l40 + l31;
                        l31 = ThreefishEngine.rotlXor(l31, 56, l30);
                        l7 = l13 + object[n3];
                        l8 = l4 + object[n4];
                        l9 = l30 + object[n5];
                        l13 = ThreefishEngine.rotlXor(l28, 22, l32 += l28) + object[n6];
                        long l43 = l32 + object[n7];
                        object7 = object6[n8] + lArray3[n9] + l31;
                        l = (long)(object6[n10] + lArray3[n2 + 2] + l6);
                        object8 = object[n + 8] + l14 + 1L + l29;
                        object5 = object8;
                        object3 = l;
                        object2 = object7;
                        l5 = l43;
                        l4 = l13;
                        l3 = l9;
                        l2 = l8;
                        l = l7;
                    }
                    long[] lArray4 = lArray2;
                    long[] lArray5 = lArray2;
                    lArray4[0] = l;
                    lArray5[1] = l2;
                    lArray4[2] = l3;
                    lArray5[3] = l4;
                    lArray4[4] = l5;
                    lArray5[5] = object2;
                    lArray4[6] = object3;
                    lArray5[7] = object5;
                    return;
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void decryptBlock(long[] lArray, long[] lArray2) {
            Threefish512Cipher threefish512Cipher = object;
            Object object = threefish512Cipher.kw;
            long[] lArray3 = threefish512Cipher.t;
            int[] nArray = MOD9;
            int[] nArray2 = MOD3;
            if (((Object)object).length == 17) {
                if (lArray3.length == 5) {
                    long l = lArray[0];
                    long l2 = lArray[1];
                    long l3 = lArray[2];
                    long l4 = lArray[3];
                    long l5 = lArray[4];
                    long l6 = lArray[5];
                    long l7 = lArray[6];
                    long l8 = lArray[7];
                    for (int k = 17; k >= 1; k -= 2) {
                        long l9 = l7;
                        long l10 = l4;
                        int n = nArray[k];
                        int n2 = nArray2[k];
                        int n3 = n + 1;
                        long l11 = l - object[n3];
                        int n4 = n + 2;
                        l4 = l2 - object[n4];
                        int n5 = n + 3;
                        long l12 = l3 - object[n5];
                        int n6 = n + 4;
                        l7 = l10 - object[n6];
                        int n7 = n + 5;
                        long l13 = l5 - object[n7];
                        int n8 = n + 6;
                        int n9 = n2 + 1;
                        long l14 = l6 - (object[n8] + lArray3[n9]);
                        int n10 = n + 7;
                        long l15 = l9 - (object[n10] + lArray3[n2 + 2]);
                        long l16 = l15;
                        long l17 = l4;
                        l4 = k;
                        l8 -= object[n + 8] + l4 + 1L;
                        l16 = ThreefishEngine.xorRotr(l17, 8, l16);
                        long l18 = l15 - l16;
                        long l19 = l7;
                        long l20 = l12;
                        long l21 = l11;
                        l11 = ThreefishEngine.xorRotr(l8, 35, l11);
                        l7 = l21 - l11;
                        l12 = ThreefishEngine.xorRotr(l14, 56, l12);
                        l8 = l20 - l12;
                        long l22 = ThreefishEngine.xorRotr(l19, 22, l13);
                        l14 = l22;
                        long l23 = l13 - l14;
                        l13 = l23;
                        l13 = ThreefishEngine.xorRotr(l16, 25, l13);
                        l14 = l23 - l13;
                        l16 = ThreefishEngine.xorRotr(l22, 29, l18);
                        l18 -= l16;
                        long l24 = ThreefishEngine.xorRotr(l12, 39, l7);
                        l12 = l24;
                        long l25 = l11;
                        l11 = l7 - l12;
                        long l26 = ThreefishEngine.xorRotr(l25, 43, l8);
                        l12 = l26;
                        long l27 = l8 - l12;
                        l12 = l27;
                        l12 = ThreefishEngine.xorRotr(l13, 13, l12);
                        l7 = l27 - l12;
                        l8 = ThreefishEngine.xorRotr(l26, 50, l14);
                        l13 = l14 - l8;
                        l14 = ThreefishEngine.xorRotr(l24, 10, l18);
                        l18 -= l14;
                        long l28 = l8;
                        long l29 = l13;
                        long l30 = l7;
                        l8 = ThreefishEngine.xorRotr(l16, 17, l11);
                        long l31 = l11 - l8;
                        l11 = l31;
                        l11 = ThreefishEngine.xorRotr(l12, 39, l11);
                        l12 = l31 - l11;
                        l7 = ThreefishEngine.xorRotr(l8, 30, l7);
                        l8 = l30 - l7;
                        l13 = ThreefishEngine.xorRotr(l14, 34, l13);
                        l14 = l29 - l13;
                        l16 = ThreefishEngine.xorRotr(l28, 24, l18);
                        l2 = l12 - object[n];
                        l3 = l11 - object[n3];
                        l5 = l8 - object[n4];
                        l6 = l7 - object[n5];
                        l7 = l14 - object[n6];
                        l = l13 - (object[n7] + lArray3[n2]);
                        l8 = l18 - l16 - (object[n8] + lArray3[n9]);
                        long l32 = l3;
                        l3 = l16 - (object[n10] + l4);
                        l4 = ThreefishEngine.xorRotr(l32, 44, l8);
                        l8 -= l4;
                        long l33 = l;
                        l = ThreefishEngine.xorRotr(l3, 9, l2);
                        l2 -= l;
                        l3 = ThreefishEngine.xorRotr(l33, 54, l5);
                        l5 -= l3;
                        long l34 = ThreefishEngine.xorRotr(l6, 56, l7);
                        l6 = l34;
                        l6 = l7 - l6;
                        l4 = ThreefishEngine.xorRotr(l4, 17, l6);
                        l6 -= l4;
                        l7 = ThreefishEngine.xorRotr(l34, 49, l8);
                        l8 -= l7;
                        long l35 = ThreefishEngine.xorRotr(l3, 36, l2);
                        l3 = l35;
                        long l36 = l;
                        l = l2 - l3;
                        long l37 = ThreefishEngine.xorRotr(l36, 39, l5);
                        l2 = l37;
                        long l38 = l5 - l2;
                        l2 = l38;
                        l2 = ThreefishEngine.xorRotr(l4, 33, l2);
                        l3 = l38 - l2;
                        l4 = ThreefishEngine.xorRotr(l37, 27, l6);
                        l5 = l6 - l4;
                        l6 = ThreefishEngine.xorRotr(l35, 14, l8);
                        long l39 = l8 - l6;
                        l8 = l39;
                        long l40 = l4;
                        l4 = ThreefishEngine.xorRotr(l7, 42, l);
                        l2 = ThreefishEngine.xorRotr(l2, 46, l -= l4);
                        l -= l2;
                        l4 = ThreefishEngine.xorRotr(l4, 36, l3);
                        l3 -= l4;
                        l6 = ThreefishEngine.xorRotr(l6, 19, l5);
                        l5 -= l6;
                        l8 = ThreefishEngine.xorRotr(l40, 37, l8);
                        l7 = l39 - l8;
                    }
                    long[] lArray4 = lArray2;
                    long[] lArray5 = lArray2;
                    long l41 = l - object[0];
                    long l42 = l2 - object[1];
                    l = l3 - object[2];
                    l2 = l4 - object[3];
                    l3 = l5 - object[4];
                    l4 = l6 - (object[5] + lArray3[0]);
                    l5 = l7 - (object[6] + lArray3[1]);
                    l6 = l8 - object[7];
                    lArray4[0] = l41;
                    lArray5[1] = l42;
                    lArray4[2] = l;
                    lArray5[3] = l2;
                    lArray4[4] = l3;
                    lArray5[5] = l4;
                    lArray4[6] = l5;
                    lArray5[7] = l6;
                    return;
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }
    }

    public static final class Threefish256Cipher
    extends ThreefishCipher {
        private static final int ROTATION_0_0 = 14;
        private static final int ROTATION_0_1 = 16;
        private static final int ROTATION_1_0 = 52;
        private static final int ROTATION_1_1 = 57;
        private static final int ROTATION_2_0 = 23;
        private static final int ROTATION_2_1 = 40;
        private static final int ROTATION_3_0 = 5;
        private static final int ROTATION_3_1 = 37;
        private static final int ROTATION_4_0 = 25;
        private static final int ROTATION_4_1 = 33;
        private static final int ROTATION_5_0 = 46;
        private static final int ROTATION_5_1 = 12;
        private static final int ROTATION_6_0 = 58;
        private static final int ROTATION_6_1 = 22;
        private static final int ROTATION_7_0 = 32;
        private static final int ROTATION_7_1 = 32;

        public Threefish256Cipher(long[] lArray, long[] lArray2) {
            super(lArray, lArray2);
        }

        @Override
        public void encryptBlock(long[] lArray, long[] lArray2) {
            Threefish256Cipher threefish256Cipher = object;
            Object object = threefish256Cipher.kw;
            long[] lArray3 = threefish256Cipher.t;
            int[] nArray = MOD5;
            int[] nArray2 = MOD3;
            if (((Object)object).length == 9) {
                if (lArray3.length == 5) {
                    long l = lArray[0];
                    Object object2 = lArray[1];
                    Object object3 = lArray[2];
                    Object object4 = object;
                    l += object[0];
                    object2 = object4[1] + lArray3[0] + object2;
                    object3 = object4[2] + lArray3[1] + object3;
                    Object object5 = lArray[3] + object4[3];
                    for (int k = 1; k < 18; k += 2) {
                        int n = nArray[k];
                        int n2 = n;
                        Object object6 = object;
                        int n3 = nArray2[k];
                        long l2 = l + object2;
                        long l3 = ThreefishEngine.rotlXor(object2, 14, l2);
                        Object object7 = object3 + object5;
                        Object object8 = ThreefishEngine.rotlXor(object5, 16, object7);
                        long l4 = l3;
                        long l5 = l3;
                        l3 = ThreefishEngine.rotlXor(object8, 52, l2 += object8);
                        object8 = ThreefishEngine.rotlXor(l4, 57, object7 += l5);
                        long l6 = l3;
                        long l7 = l3;
                        l3 = ThreefishEngine.rotlXor(object8, 23, l2 += object8);
                        object8 = ThreefishEngine.rotlXor(l6, 40, object7 += l7);
                        long l8 = l3;
                        long l9 = l3;
                        l3 = ThreefishEngine.rotlXor(object8, 5, l2 += object8);
                        object8 = ThreefishEngine.rotlXor(l8, 37, object7 += l9);
                        long l10 = l2 + object[n2];
                        Object object9 = object;
                        int n4 = n2 + 1;
                        object8 = object9[n4] + lArray3[n3] + object8;
                        int n5 = n2 + 2;
                        int n6 = n3 + 1;
                        object7 = object9[n5] + lArray3[n6] + object7;
                        long l11 = k;
                        l3 = (long)(object9[n2 += 3] + l11 + l3);
                        long l12 = l10 + object8;
                        Object object10 = l3;
                        Object object11 = l3;
                        l3 = ThreefishEngine.rotlXor(object8, 25, l12);
                        object8 = ThreefishEngine.rotlXor(object10, 33, object7 += object11);
                        long l13 = l3;
                        long l14 = l3;
                        l3 = ThreefishEngine.rotlXor(object8, 46, l12 += object8);
                        object8 = ThreefishEngine.rotlXor(l13, 12, object7 += l14);
                        long l15 = l3;
                        long l16 = l3;
                        l3 = ThreefishEngine.rotlXor(object8, 58, l12 += object8);
                        object8 = ThreefishEngine.rotlXor(l15, 22, object7 += l16);
                        long l17 = l3;
                        long l18 = l3;
                        l3 = ThreefishEngine.rotlXor(object8, 32, l12 += object8);
                        object8 = ThreefishEngine.rotlXor(l17, 32, object7 += l18);
                        l12 += object[n4];
                        object8 = object6[n5] + lArray3[n6] + object8;
                        object7 = object6[n2] + lArray3[n3 + 2] + object7;
                        l = (long)(object[n + 4] + l11 + 1L + l3);
                        object5 = l;
                        object3 = object7;
                        object2 = object8;
                        l = l12;
                    }
                    long[] lArray4 = lArray2;
                    long[] lArray5 = lArray2;
                    lArray4[0] = l;
                    lArray5[1] = object2;
                    lArray4[2] = object3;
                    lArray5[3] = object5;
                    return;
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void decryptBlock(long[] lArray, long[] lArray2) {
            Threefish256Cipher threefish256Cipher = object;
            Object object = threefish256Cipher.kw;
            long[] lArray3 = threefish256Cipher.t;
            int[] nArray = MOD5;
            int[] nArray2 = MOD3;
            if (((Object)object).length == 9) {
                if (lArray3.length == 5) {
                    long l = lArray[0];
                    long l2 = lArray[1];
                    long l3 = lArray[2];
                    long l4 = lArray[3];
                    for (int k = 17; k >= 1; k -= 2) {
                        int n = nArray[k];
                        int n2 = nArray2[k];
                        int n3 = n + 1;
                        long l5 = l - object[n3];
                        int n4 = n + 2;
                        int n5 = n2 + 1;
                        long l6 = l2 - (object[n4] + lArray3[n5]);
                        int n6 = n + 3;
                        long l7 = l3 - (object[n6] + lArray3[n2 + 2]);
                        long l8 = l7;
                        long l9 = l6;
                        long l10 = l5;
                        long l11 = l4;
                        l4 = k;
                        l5 = ThreefishEngine.xorRotr(l11 - (object[n + 4] + l4 + 1L), 32, l5);
                        l6 = l10 - l5;
                        l8 = ThreefishEngine.xorRotr(l9, 32, l8);
                        long l12 = l7 - l8;
                        long l13 = l5;
                        l5 = ThreefishEngine.xorRotr(l8, 58, l6);
                        l6 -= l5;
                        l8 = ThreefishEngine.xorRotr(l13, 22, l12);
                        l12 -= l8;
                        long l14 = l5;
                        l5 = ThreefishEngine.xorRotr(l8, 46, l6);
                        l6 -= l5;
                        l8 = ThreefishEngine.xorRotr(l14, 12, l12);
                        l12 -= l8;
                        long l15 = l5;
                        l5 = ThreefishEngine.xorRotr(l8, 25, l6);
                        l8 = ThreefishEngine.xorRotr(l15, 33, l12);
                        l2 = (l6 -= l5) - object[n];
                        l = l5 - (object[n3] + lArray3[n2]);
                        long l16 = l12 - l8 - (object[n4] + lArray3[n5]);
                        l3 = l16;
                        long l17 = l;
                        l = ThreefishEngine.xorRotr(l8 - (object[n6] + l4), 5, l2);
                        l2 -= l;
                        l3 = ThreefishEngine.xorRotr(l17, 37, l3);
                        l4 = l16 - l3;
                        long l18 = l;
                        l = ThreefishEngine.xorRotr(l3, 23, l2);
                        l2 -= l;
                        l3 = ThreefishEngine.xorRotr(l18, 40, l4);
                        l4 -= l3;
                        long l19 = l;
                        l = ThreefishEngine.xorRotr(l3, 52, l2);
                        l3 = ThreefishEngine.xorRotr(l19, 57, l4);
                        long l20 = l4 - l3;
                        l4 = l20;
                        long l21 = l;
                        long l22 = l2 -= l;
                        l2 = ThreefishEngine.xorRotr(l3, 14, l2);
                        l = l22 - l2;
                        l4 = ThreefishEngine.xorRotr(l21, 16, l4);
                        l3 = l20 - l4;
                    }
                    long[] lArray4 = lArray2;
                    long[] lArray5 = lArray2;
                    long l23 = l - object[0];
                    long l24 = l2 - (object[1] + lArray3[0]);
                    l = l3 - (object[2] + lArray3[1]);
                    l2 = l4 - object[3];
                    lArray4[0] = l23;
                    lArray5[1] = l24;
                    lArray4[2] = l;
                    lArray5[3] = l2;
                    return;
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }
    }

    public static abstract class ThreefishCipher {
        public final long[] t;
        public final long[] kw;

        public ThreefishCipher(long[] lArray, long[] lArray2) {
            this.kw = lArray;
            this.t = lArray2;
        }

        public abstract void encryptBlock(long[] var1, long[] var2);

        public abstract void decryptBlock(long[] var1, long[] var2);
    }
}

