/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.CramerShoupKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.CramerShoupParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.CramerShoupPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.CramerShoupPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class CramerShoupKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private CramerShoupKeyGenerationParameters param;

    private BigInteger generateRandomElement(BigInteger bigInteger, SecureRandom secureRandom) {
        BigInteger bigInteger2 = ONE;
        return BigIntegers.createRandomInRange(bigInteger2, bigInteger.subtract(bigInteger2), secureRandom);
    }

    private CramerShoupPrivateKeyParameters generatePrivateKey(SecureRandom serializable, CramerShoupParameters cramerShoupParameters) {
        BigInteger bigInteger = cramerShoupParameters.getP();
        CramerShoupKeyPairGenerator cramerShoupKeyPairGenerator = bigInteger2;
        BigInteger bigInteger2 = cramerShoupKeyPairGenerator.generateRandomElement(bigInteger, (SecureRandom)serializable);
        BigInteger bigInteger3 = cramerShoupKeyPairGenerator.generateRandomElement(bigInteger, (SecureRandom)serializable);
        BigInteger bigInteger4 = cramerShoupKeyPairGenerator.generateRandomElement(bigInteger, (SecureRandom)serializable);
        BigInteger bigInteger5 = cramerShoupKeyPairGenerator.generateRandomElement(bigInteger, (SecureRandom)serializable);
        serializable = cramerShoupKeyPairGenerator.generateRandomElement(bigInteger, (SecureRandom)serializable);
        return new CramerShoupPrivateKeyParameters(cramerShoupParameters, bigInteger2, bigInteger3, bigInteger4, bigInteger5, (BigInteger)serializable);
    }

    private CramerShoupPublicKeyParameters calculatePublicKey(CramerShoupParameters cramerShoupParameters, CramerShoupPrivateKeyParameters object) {
        BigInteger bigInteger = cramerShoupParameters.getG1();
        Object object2 = object4 = bigInteger;
        Object object3 = object4;
        CramerShoupParameters cramerShoupParameters2 = cramerShoupParameters;
        Object object4 = cramerShoupParameters2.getG2();
        BigInteger bigInteger2 = cramerShoupParameters2.getP();
        BigInteger bigInteger3 = ((BigInteger)object3).modPow(((CramerShoupPrivateKeyParameters)object).getX1(), bigInteger2).multiply(((BigInteger)object4).modPow(((CramerShoupPrivateKeyParameters)object).getX2(), bigInteger2));
        object4 = ((BigInteger)object2).modPow(((CramerShoupPrivateKeyParameters)object).getY1(), bigInteger2).multiply(((BigInteger)object4).modPow(((CramerShoupPrivateKeyParameters)object).getY2(), bigInteger2));
        object = bigInteger.modPow(((CramerShoupPrivateKeyParameters)object).getZ(), bigInteger2);
        return new CramerShoupPublicKeyParameters(cramerShoupParameters, bigInteger3, (BigInteger)object4, (BigInteger)object);
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (CramerShoupKeyGenerationParameters)keyGenerationParameters;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        CramerShoupKeyPairGenerator cramerShoupKeyPairGenerator = cramerShoupPublicKeyParameters;
        CramerShoupParameters cramerShoupParameters = cramerShoupKeyPairGenerator.param.getParameters();
        CramerShoupPrivateKeyParameters cramerShoupPrivateKeyParameters = cramerShoupKeyPairGenerator.generatePrivateKey(cramerShoupKeyPairGenerator.param.getRandom(), cramerShoupParameters);
        CramerShoupPublicKeyParameters cramerShoupPublicKeyParameters = ((CramerShoupKeyPairGenerator)((Object)cramerShoupPublicKeyParameters)).calculatePublicKey(cramerShoupParameters, cramerShoupPrivateKeyParameters);
        cramerShoupPrivateKeyParameters.setPk(cramerShoupPublicKeyParameters);
        return new AsymmetricCipherKeyPair(cramerShoupPublicKeyParameters, cramerShoupPrivateKeyParameters);
    }
}

