/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.WNafUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

class DHKeyGeneratorHelper {
    public static final DHKeyGeneratorHelper INSTANCE = new DHKeyGeneratorHelper();
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    private DHKeyGeneratorHelper() {
    }

    public BigInteger calculatePrivate(DHParameters object, SecureRandom secureRandom) {
        int n = ((DHParameters)object).getL();
        if (n != 0) {
            int n2 = n >>> 2;
            while (WNafUtil.getNafWeight((BigInteger)(object = BigIntegers.createRandomBigInteger(n, secureRandom).setBit(n - 1))) < n2) {
            }
            return object;
        }
        BigInteger bigInteger = TWO;
        int n3 = ((DHParameters)object).getM();
        BigInteger bigInteger2 = n3 != 0 ? ONE.shiftLeft(n3 - 1) : bigInteger;
        BigInteger bigInteger3 = ((DHParameters)object).getQ();
        if (bigInteger3 == null) {
            bigInteger3 = ((DHParameters)object).getP();
        }
        bigInteger = bigInteger3.subtract(bigInteger);
        int n4 = bigInteger.bitLength() >>> 2;
        while (WNafUtil.getNafWeight(bigInteger3 = BigIntegers.createRandomInRange(bigInteger2, bigInteger, secureRandom)) < n4) {
        }
        return bigInteger3;
    }

    public BigInteger calculatePublic(DHParameters dHParameters, BigInteger bigInteger) {
        return dHParameters.getG().modPow(bigInteger, dHParameters.getP());
    }
}

