/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSABlindingFactorGenerator {
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private static BigInteger ONE = BigInteger.valueOf(1L);
    private RSAKeyParameters key;
    private SecureRandom random;

    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            RSABlindingFactorGenerator rSABlindingFactorGenerator = this;
            cipherParameters = (ParametersWithRandom)cipherParameters;
            rSABlindingFactorGenerator.key = (RSAKeyParameters)((ParametersWithRandom)cipherParameters).getParameters();
            rSABlindingFactorGenerator.random = ((ParametersWithRandom)cipherParameters).getRandom();
        } else {
            RSABlindingFactorGenerator rSABlindingFactorGenerator = this;
            rSABlindingFactorGenerator.key = (RSAKeyParameters)cipherParameters;
            rSABlindingFactorGenerator.random = CryptoServicesRegistrar.getSecureRandom();
        }
        if (!(this.key instanceof RSAPrivateCrtKeyParameters)) {
            return;
        }
        throw new IllegalArgumentException("generator requires RSA public key");
    }

    public BigInteger generateBlindingFactor() {
        Object object = this.key;
        if (object != null) {
            BigInteger bigInteger;
            BigInteger bigInteger2;
            object = ((RSAKeyParameters)object).getModulus();
            int n = ((BigInteger)object).bitLength() - 1;
            do {
                bigInteger2 = BigIntegers.createRandomBigInteger(n, this.random);
                bigInteger = bigInteger2.gcd((BigInteger)object);
            } while (bigInteger2.equals(ZERO) || bigInteger2.equals(ONE) || !bigInteger.equals(ONE));
            return bigInteger2;
        }
        throw new IllegalStateException("generator not initialised");
    }
}

