/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.Zuc128CoreEngine;

public final class Zuc128Mac
implements Mac {
    private static final int TOPBIT = 128;
    private final InternalZuc128Engine theEngine = new InternalZuc128Engine(null);
    private int theMac;
    private final int[] theKeyStream = new int[2];
    private Zuc128CoreEngine theState;
    private int theWordIndex;
    private int theByteIndex;

    private void initKeyStream() {
        int[] nArray;
        this.theMac = 0;
        int n = 0;
        while (true) {
            nArray = this.theKeyStream;
            if (n >= this.theKeyStream.length - 1) break;
            nArray[n] = this.theEngine.createKeyStreamWord();
            ++n;
        }
        Zuc128Mac zuc128Mac = this;
        zuc128Mac.theWordIndex = nArray.length - 1;
        zuc128Mac.theByteIndex = 3;
    }

    private void shift4NextByte() {
        this.theByteIndex = (this.theByteIndex + 1) % 4;
        if (this.theByteIndex == 0) {
            Zuc128Mac zuc128Mac = this;
            zuc128Mac.theKeyStream[this.theWordIndex] = this.theEngine.createKeyStreamWord();
            zuc128Mac.theWordIndex = (zuc128Mac.theWordIndex + 1) % this.theKeyStream.length;
        }
    }

    private void updateMac(int n) {
        this.theMac ^= this.getKeyStreamWord(n);
    }

    private int getKeyStreamWord(int n) {
        int[] nArray = this.theKeyStream;
        int n2 = this.theWordIndex;
        int n3 = this.theKeyStream[n2];
        if (n == 0) {
            return n3;
        }
        n2 = nArray[(n2 + 1) % nArray.length];
        return n3 << n | n2 >>> 32 - n;
    }

    private int getFinalWord() {
        int n;
        if (this.theByteIndex != 0) {
            return this.theEngine.createKeyStreamWord();
        }
        Zuc128Mac zuc128Mac = this;
        int n2 = zuc128Mac.theWordIndex + 1;
        int[] nArray = zuc128Mac.theKeyStream;
        this.theWordIndex = n = n2 % nArray.length;
        return zuc128Mac.theKeyStream[n];
    }

    @Override
    public String getAlgorithmName() {
        return "Zuc128Mac";
    }

    @Override
    public int getMacSize() {
        return 4;
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        Zuc128Mac zuc128Mac = this;
        zuc128Mac.theEngine.init(true, cipherParameters);
        zuc128Mac.theState = (Zuc128CoreEngine)zuc128Mac.theEngine.copy();
        zuc128Mac.initKeyStream();
    }

    @Override
    public void update(byte by) {
        Zuc128Mac zuc128Mac = this;
        zuc128Mac.shift4NextByte();
        int n = zuc128Mac.theByteIndex * 8;
        int n2 = 128;
        int n3 = 0;
        while (n2 > 0) {
            if ((by & n2) != 0) {
                this.updateMac(n + n3);
            }
            n2 >>= 1;
            ++n3;
        }
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        for (int k = 0; k < n2; ++k) {
            this.update(byArray[n + k]);
        }
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        int n2;
        Zuc128Mac zuc128Mac = this;
        zuc128Mac.shift4NextByte();
        Zuc128Mac zuc128Mac2 = this;
        this.theMac = n2 = zuc128Mac.theMac ^ zuc128Mac2.getKeyStreamWord(zuc128Mac2.theByteIndex * 8);
        this.theMac = n2 ^= this.getFinalWord();
        Zuc128CoreEngine.encode32be(n2, byArray, n);
        zuc128Mac.reset();
        return zuc128Mac.getMacSize();
    }

    @Override
    public void reset() {
        Zuc128CoreEngine zuc128CoreEngine = this.theState;
        if (zuc128CoreEngine != null) {
            this.theEngine.reset(zuc128CoreEngine);
        }
        this.initKeyStream();
    }

    public static class InternalZuc128Engine
    extends Zuc128CoreEngine {
        private InternalZuc128Engine() {
        }

        public /* synthetic */ InternalZuc128Engine(1 var1_1) {
            this();
        }

        public int createKeyStreamWord() {
            return super.makeKeyStreamWord();
        }
    }
}

