/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class CBCBlockCipher
implements BlockCipher {
    private byte[] IV;
    private byte[] cbcV;
    private byte[] cbcNextV;
    private int blockSize;
    private BlockCipher cipher;
    private boolean encrypting;

    public CBCBlockCipher(BlockCipher blockCipher) {
        int n;
        CBCBlockCipher cBCBlockCipher = this;
        this.cipher = blockCipher;
        cBCBlockCipher.blockSize = n = blockCipher.getBlockSize();
        cBCBlockCipher.IV = new byte[n];
        cBCBlockCipher.cbcV = new byte[n];
        cBCBlockCipher.cbcNextV = new byte[n];
    }

    private int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (n + ((CBCBlockCipher)object).blockSize <= byArray.length) {
            for (int k = 0; k < ((CBCBlockCipher)object).blockSize; ++k) {
                ((CBCBlockCipher)object).cbcV[k] = (byte)(((CBCBlockCipher)object).cbcV[k] ^ byArray[n + k]);
            }
            int n3 = ((CBCBlockCipher)object).cipher.processBlock(((CBCBlockCipher)object).cbcV, 0, byArray2, n2);
            Object object = ((CBCBlockCipher)object).cbcV;
            int n4 = ((CBCBlockCipher)object).cbcV.length;
            System.arraycopy(byArray2, n2, object, 0, n4);
            return n3;
        }
        throw new DataLengthException("input buffer too short");
    }

    private int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = ((CBCBlockCipher)object).blockSize;
        if (n + n3 <= byArray.length) {
            System.arraycopy(byArray, n, ((CBCBlockCipher)object).cbcNextV, 0, n3);
            int n4 = ((CBCBlockCipher)object).cipher.processBlock(byArray, n, byArray2, n2);
            for (n = 0; n < ((CBCBlockCipher)object).blockSize; ++n) {
                n3 = n2 + n;
                byArray2[n3] = (byte)(byArray2[n3] ^ ((CBCBlockCipher)object).cbcV[n]);
            }
            CBCBlockCipher cBCBlockCipher = object;
            Object object = cBCBlockCipher.cbcV;
            cBCBlockCipher.cbcV = cBCBlockCipher.cbcNextV;
            cBCBlockCipher.cbcNextV = (byte[])object;
            return n4;
        }
        throw new DataLengthException("input buffer too short");
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        block11: {
            block9: {
                boolean bl2;
                block10: {
                    block7: {
                        block8: {
                            bl2 = this.encrypting;
                            this.encrypting = bl;
                            if (!(cipherParameters instanceof ParametersWithIV)) break block7;
                            byte[] byArray = ((ParametersWithIV)(cipherParameters = (ParametersWithIV)cipherParameters)).getIV();
                            if (byArray.length != this.blockSize) break block8;
                            byArray = this.IV;
                            int n = byArray.length;
                            System.arraycopy(byArray, 0, byArray, 0, n);
                            this.reset();
                            if (((ParametersWithIV)cipherParameters).getParameters() != null) {
                                this.cipher.init(bl, ((ParametersWithIV)cipherParameters).getParameters());
                            } else if (bl2 != bl) {
                                throw new IllegalArgumentException("cannot change encrypting state without providing key.");
                            }
                            break block9;
                        }
                        throw new IllegalArgumentException("initialisation vector must be the same length as block size");
                    }
                    this.reset();
                    if (cipherParameters == null) break block10;
                    this.cipher.init(bl, cipherParameters);
                    break block9;
                }
                if (bl2 != bl) break block11;
            }
            return;
        }
        throw new IllegalArgumentException("cannot change encrypting state without providing key.");
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/CBC";
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        return this.encrypting ? this.encryptBlock(byArray, n, byArray2, n2) : this.decryptBlock(byArray, n, byArray2, n2);
    }

    @Override
    public void reset() {
        CBCBlockCipher cBCBlockCipher = object;
        Object object = ((CBCBlockCipher)object).cbcV;
        int n = cBCBlockCipher.IV.length;
        System.arraycopy(cBCBlockCipher.IV, 0, object, 0, n);
        Arrays.fill(cBCBlockCipher.cbcNextV, (byte)0);
        cBCBlockCipher.cipher.reset();
    }
}

