/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.GOST3413CipherUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class G3413CBCBlockCipher
implements BlockCipher {
    private int m;
    private int blockSize;
    private byte[] R;
    private byte[] R_init;
    private BlockCipher cipher;
    private boolean initialized = false;
    private boolean forEncryption;

    public G3413CBCBlockCipher(BlockCipher blockCipher) {
        this.blockSize = blockCipher.getBlockSize();
        this.cipher = blockCipher;
    }

    private void initArrays() {
        int n = this.m;
        this.R = new byte[n];
        this.R_init = new byte[n];
    }

    private void setupDefaultParams() {
        this.m = this.blockSize;
    }

    private int encrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        byte[] byArray3 = byArray;
        G3413CBCBlockCipher g3413CBCBlockCipher = this;
        byArray = GOST3413CipherUtil.MSB(g3413CBCBlockCipher.R, this.blockSize);
        byArray = GOST3413CipherUtil.sum(GOST3413CipherUtil.copyFromInput(byArray3, g3413CBCBlockCipher.blockSize, n), byArray);
        n = byArray.length;
        byte[] byArray4 = new byte[n];
        this.cipher.processBlock(byArray, 0, byArray4, 0);
        System.arraycopy(byArray4, 0, byArray2, n2, n);
        if (byArray2.length > n2 + byArray.length) {
            this.generateR(byArray4);
        }
        return n;
    }

    private int decrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        byte[] byArray3 = byArray;
        G3413CBCBlockCipher g3413CBCBlockCipher = this;
        byArray = GOST3413CipherUtil.MSB(g3413CBCBlockCipher.R, this.blockSize);
        byte[] byArray4 = GOST3413CipherUtil.copyFromInput(byArray3, g3413CBCBlockCipher.blockSize, n);
        byte[] byArray5 = new byte[byArray4.length];
        this.cipher.processBlock(byArray4, 0, byArray5, 0);
        byArray = GOST3413CipherUtil.sum(byArray5, byArray);
        int n3 = byArray.length;
        System.arraycopy(byArray, 0, byArray2, n2, n3);
        if (byArray2.length > n2 + byArray.length) {
            this.generateR(byArray4);
        }
        return byArray.length;
    }

    private void generateR(byte[] byArray) {
        byte[] byArray2 = byArray;
        G3413CBCBlockCipher g3413CBCBlockCipher = object;
        byArray = GOST3413CipherUtil.LSB(g3413CBCBlockCipher.R, ((G3413CBCBlockCipher)object).m - ((G3413CBCBlockCipher)object).blockSize);
        G3413CBCBlockCipher g3413CBCBlockCipher2 = object;
        Object object = ((G3413CBCBlockCipher)object).R;
        int n = byArray.length;
        System.arraycopy(byArray, 0, object, 0, n);
        object = g3413CBCBlockCipher2.R;
        n = byArray.length;
        int n2 = g3413CBCBlockCipher.m - byArray.length;
        System.arraycopy(byArray2, 0, object, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forEncryption = bl;
        if (cipherParameters instanceof ParametersWithIV) {
            byte[] byArray = ((ParametersWithIV)(cipherParameters = (ParametersWithIV)cipherParameters)).getIV();
            if (byArray.length < this.blockSize) throw new IllegalArgumentException("Parameter m must blockSize <= m");
            this.m = byArray.length;
            this.initArrays();
            byte[] byArray2 = Arrays.clone(byArray);
            byArray = byArray2;
            this.R_init = byArray;
            byArray = this.R;
            int n = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, 0, n);
            if (((ParametersWithIV)cipherParameters).getParameters() != null) {
                this.cipher.init(bl, ((ParametersWithIV)cipherParameters).getParameters());
            }
        } else {
            G3413CBCBlockCipher g3413CBCBlockCipher = this;
            g3413CBCBlockCipher.setupDefaultParams();
            g3413CBCBlockCipher.initArrays();
            byte[] byArray = this.R;
            int n = g3413CBCBlockCipher.R_init.length;
            System.arraycopy(g3413CBCBlockCipher.R_init, 0, byArray, 0, n);
            if (cipherParameters != null) {
                this.cipher.init(bl, cipherParameters);
            }
        }
        this.initialized = true;
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/CBC";
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        return this.forEncryption ? this.encrypt(byArray, n, byArray2, n2) : this.decrypt(byArray, n, byArray2, n2);
    }

    @Override
    public void reset() {
        if (((G3413CBCBlockCipher)object).initialized) {
            G3413CBCBlockCipher g3413CBCBlockCipher = object;
            Object object = ((G3413CBCBlockCipher)object).R;
            int n = g3413CBCBlockCipher.R_init.length;
            System.arraycopy(g3413CBCBlockCipher.R_init, 0, object, 0, n);
            g3413CBCBlockCipher.cipher.reset();
        }
    }
}

