/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CBCBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CFBBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.OFBBlockCipher;

public class OldCTSBlockCipher
extends BufferedBlockCipher {
    private int blockSize;

    public OldCTSBlockCipher(BlockCipher blockCipher) {
        if (!(blockCipher instanceof OFBBlockCipher) && !(blockCipher instanceof CFBBlockCipher)) {
            OldCTSBlockCipher oldCTSBlockCipher = this;
            this.cipher = blockCipher;
            this.blockSize = blockCipher.getBlockSize();
            oldCTSBlockCipher.buf = new byte[this.blockSize * 2];
            oldCTSBlockCipher.bufOff = 0;
            return;
        }
        throw new IllegalArgumentException("CTSBlockCipher can only accept ECB, or CBC ciphers");
    }

    @Override
    public int getUpdateOutputSize(int n) {
        Object object = ((BufferedBlockCipher)object).buf;
        int n2 = (n += ((BufferedBlockCipher)object).bufOff) % ((BufferedBlockCipher)object).buf.length;
        if (n2 == 0) {
            return n - ((Object)object).length;
        }
        return n - n2;
    }

    @Override
    public int getOutputSize(int n) {
        return n + this.bufOff;
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n) {
        int n2 = 0;
        byte[] byArray2 = this.buf;
        if (this.bufOff == this.buf.length) {
            OldCTSBlockCipher oldCTSBlockCipher = this;
            n2 = oldCTSBlockCipher.cipher.processBlock(byArray2, 0, byArray, n);
            byArray = oldCTSBlockCipher.buf;
            n = this.blockSize;
            System.arraycopy(oldCTSBlockCipher.buf, n, byArray, 0, n);
            oldCTSBlockCipher.bufOff = oldCTSBlockCipher.blockSize;
        }
        int n3 = this.bufOff;
        this.bufOff = n3 + 1;
        this.buf[n3] = by;
        return n2;
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n2 >= 0) {
            OldCTSBlockCipher oldCTSBlockCipher = object;
            int n4 = oldCTSBlockCipher.getBlockSize();
            int n5 = oldCTSBlockCipher.getUpdateOutputSize(n2);
            if (n5 > 0 && n3 + n5 > byArray2.length) {
                throw new OutputLengthException("output buffer too short");
            }
            n5 = 0;
            byte[] byArray3 = ((BufferedBlockCipher)object).buf;
            int n6 = ((BufferedBlockCipher)object).bufOff;
            int n7 = ((BufferedBlockCipher)object).buf.length - n6;
            if (n2 > n7) {
                int n8 = n;
                OldCTSBlockCipher oldCTSBlockCipher2 = object;
                System.arraycopy(byArray, n, byArray3, n6, n7);
                n = oldCTSBlockCipher2.cipher.processBlock(((BufferedBlockCipher)object).buf, 0, byArray2, n3) + n5;
                System.arraycopy(oldCTSBlockCipher2.buf, n4, oldCTSBlockCipher2.buf, 0, n4);
                ((BufferedBlockCipher)object).bufOff = n4;
                n2 -= n7;
                int n9 = n5 = n8 + n7;
                n5 = n;
                n = n9;
                while (n2 > n4) {
                    int n10 = n;
                    int n11 = n2;
                    Object object = object;
                    Object object2 = object;
                    byte[] byArray4 = ((BufferedBlockCipher)object2).buf;
                    System.arraycopy(byArray, n, byArray4, ((BufferedBlockCipher)object2).bufOff, n4);
                    byArray4 = ((BufferedBlockCipher)object).buf;
                    n2 = n3 + n5;
                    n = ((BufferedBlockCipher)object).cipher.processBlock(byArray4, 0, byArray2, n2) + n5;
                    System.arraycopy(((BufferedBlockCipher)object).buf, n4, ((BufferedBlockCipher)object).buf, 0, n4);
                    n2 = n11 - n4;
                    int n12 = n5 = n10 + n4;
                    n5 = n;
                    n = n12;
                }
            }
            OldCTSBlockCipher oldCTSBlockCipher3 = object;
            OldCTSBlockCipher oldCTSBlockCipher4 = object;
            Object object = oldCTSBlockCipher4.buf;
            System.arraycopy(byArray, n, object, oldCTSBlockCipher4.bufOff, n2);
            oldCTSBlockCipher3.bufOff += n2;
            return n5;
        }
        throw new IllegalArgumentException("Can't have a negative input length!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int doFinal(byte[] byArray, int n) {
        if (this.bufOff + n > byArray.length) throw new OutputLengthException("output buffer to small in doFinal");
        OldCTSBlockCipher oldCTSBlockCipher = this;
        int n2 = oldCTSBlockCipher.cipher.getBlockSize();
        int n3 = this.bufOff - n2;
        byte[] byArray2 = new byte[n2];
        if (oldCTSBlockCipher.forEncryption) {
            OldCTSBlockCipher oldCTSBlockCipher2 = this;
            oldCTSBlockCipher2.cipher.processBlock(this.buf, 0, byArray2, 0);
            int n4 = oldCTSBlockCipher2.bufOff;
            if (n4 < n2) throw new DataLengthException("need at least one block of input for CTS");
            while (true) {
                byte[] byArray3 = this.buf;
                if (n4 == this.buf.length) break;
                byArray3[n4] = byArray2[n4 - n2];
                ++n4;
            }
            for (n4 = n2; n4 != this.bufOff; ++n4) {
                this.buf[n4] = (byte)(this.buf[n4] ^ byArray2[n4 - n2]);
            }
            BlockCipher blockCipher = this.cipher;
            if (blockCipher instanceof CBCBlockCipher) {
                ((CBCBlockCipher)blockCipher).getUnderlyingCipher().processBlock(this.buf, n2, byArray, n);
            } else {
                blockCipher.processBlock(this.buf, n2, byArray, n);
            }
            System.arraycopy(byArray2, 0, byArray, n += n2, n3);
        } else {
            byte[] byArray4 = new byte[n2];
            BlockCipher blockCipher = this.cipher;
            if (blockCipher instanceof CBCBlockCipher) {
                ((CBCBlockCipher)blockCipher).getUnderlyingCipher().processBlock(this.buf, 0, byArray2, 0);
            } else {
                blockCipher.processBlock(this.buf, 0, byArray2, 0);
            }
            for (int k = n2; k != this.bufOff; ++k) {
                int n5 = k - n2;
                byArray4[n5] = (byte)(byArray2[n5] ^ this.buf[k]);
            }
            OldCTSBlockCipher oldCTSBlockCipher3 = this;
            System.arraycopy(oldCTSBlockCipher3.buf, n2, byArray2, 0, n3);
            oldCTSBlockCipher3.cipher.processBlock(byArray2, 0, byArray, n);
            System.arraycopy(byArray4, 0, byArray, n += n2, n3);
        }
        this.reset();
        return this.bufOff;
    }
}

