/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;

public class OpenPGPCFBBlockCipher
implements BlockCipher {
    private byte[] IV;
    private byte[] FR;
    private byte[] FRE;
    private BlockCipher cipher;
    private int count;
    private int blockSize;
    private boolean forEncryption;

    public OpenPGPCFBBlockCipher(BlockCipher blockCipher) {
        int n;
        OpenPGPCFBBlockCipher openPGPCFBBlockCipher = this;
        this.cipher = blockCipher;
        openPGPCFBBlockCipher.blockSize = n = blockCipher.getBlockSize();
        openPGPCFBBlockCipher.IV = new byte[n];
        openPGPCFBBlockCipher.FR = new byte[n];
        openPGPCFBBlockCipher.FRE = new byte[n];
    }

    private byte encryptByte(byte by, int n) {
        return (byte)(this.FRE[n] ^ by);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3;
        int n4 = this.blockSize;
        if (n + n4 > byArray.length) throw new DataLengthException("input buffer too short");
        if (n2 + n4 > byArray2.length) throw new OutputLengthException("output buffer too short");
        int n5 = this.count;
        if (n5 > n4) {
            OpenPGPCFBBlockCipher openPGPCFBBlockCipher = this;
            int n6 = n4;
            n5 = byArray[n];
            byArray2[n2] = n5 = this.encryptByte((byte)n5, n6 - 2);
            openPGPCFBBlockCipher.FR[n4 -= 2] = n5;
            OpenPGPCFBBlockCipher openPGPCFBBlockCipher2 = this;
            int n7 = openPGPCFBBlockCipher2.blockSize;
            n4 = n7;
            n5 = n2 + 1;
            int n8 = byArray[n + 1];
            byArray2[n5] = n8 = openPGPCFBBlockCipher2.encryptByte((byte)n8, n7 - 1);
            openPGPCFBBlockCipher.FR[--n4] = n8;
            OpenPGPCFBBlockCipher openPGPCFBBlockCipher3 = this;
            byte[] byArray3 = openPGPCFBBlockCipher3.FR;
            byte[] byArray4 = openPGPCFBBlockCipher3.FRE;
            openPGPCFBBlockCipher.cipher.processBlock(byArray3, 0, byArray4, 0);
            int n9 = 2;
            while (n9 < this.blockSize) {
                byte by;
                int n10 = n9;
                int n11 = n10 - 2;
                n8 = n2 + n10;
                byArray2[n8] = by = this.encryptByte(byArray[n + n9], n11);
                this.FR[n11] = by;
                ++n9;
            }
            return this.blockSize;
        }
        if (n5 == 0) {
            OpenPGPCFBBlockCipher openPGPCFBBlockCipher = this;
            byte[] byArray5 = openPGPCFBBlockCipher.FR;
            byte[] byArray6 = openPGPCFBBlockCipher.FRE;
            this.cipher.processBlock(byArray5, 0, byArray6, 0);
            for (int k = 0; k < (n3 = this.blockSize); ++k) {
                byte by;
                n3 = n2 + k;
                byArray2[n3] = by = this.encryptByte(byArray[n + k], k);
                this.FR[k] = by;
            }
        } else {
            if (n5 != n4) return this.blockSize;
            OpenPGPCFBBlockCipher openPGPCFBBlockCipher = this;
            OpenPGPCFBBlockCipher openPGPCFBBlockCipher4 = this;
            byte[] byArray7 = openPGPCFBBlockCipher4.FR;
            byte[] byArray8 = openPGPCFBBlockCipher4.FRE;
            this.cipher.processBlock(byArray7, 0, byArray8, 0);
            byArray2[n2] = this.encryptByte(byArray[n], 0);
            int n12 = n2 + 1;
            byArray2[n12] = this.encryptByte(byArray[n + 1], 1);
            n12 = this.blockSize - 2;
            System.arraycopy(openPGPCFBBlockCipher.FR, 2, openPGPCFBBlockCipher.FR, 0, n12);
            byte[] byArray9 = openPGPCFBBlockCipher.FR;
            System.arraycopy(byArray2, n2, byArray9, openPGPCFBBlockCipher.blockSize - 2, 2);
            OpenPGPCFBBlockCipher openPGPCFBBlockCipher5 = this;
            byArray9 = openPGPCFBBlockCipher5.FR;
            byArray8 = openPGPCFBBlockCipher5.FRE;
            this.cipher.processBlock(byArray9, 0, byArray8, 0);
            for (int k = 2; k < (n3 = this.blockSize); ++k) {
                byte by;
                int n13 = k;
                n3 = n13 - 2;
                int n14 = n2 + n13;
                byArray2[n14] = by = this.encryptByte(byArray[n + k], n3);
                this.FR[n3] = by;
            }
        }
        this.count += n3;
        return this.blockSize;
    }

    private int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.blockSize;
        if (n + n3 <= byArray.length) {
            if (n2 + n3 <= byArray2.length) {
                int n4 = this.count;
                if (n4 > n3) {
                    OpenPGPCFBBlockCipher openPGPCFBBlockCipher = this;
                    this.FR[n3 - 2] = n4 = byArray[n];
                    byArray2[n2] = this.encryptByte((byte)n4, n3 - 2);
                    n3 = byArray[n + 1];
                    byte[] byArray3 = openPGPCFBBlockCipher.FR;
                    int n5 = openPGPCFBBlockCipher.blockSize;
                    int n6 = byArray3[n5 - 1] = n3;
                    n3 = n2 + 1;
                    byArray2[n3] = openPGPCFBBlockCipher.encryptByte((byte)n6, n5 - 1);
                    OpenPGPCFBBlockCipher openPGPCFBBlockCipher2 = this;
                    byte[] byArray4 = openPGPCFBBlockCipher2.FR;
                    byArray3 = openPGPCFBBlockCipher2.FRE;
                    this.cipher.processBlock(byArray4, 0, byArray3, 0);
                    for (int k = 2; k < this.blockSize; ++k) {
                        byte by = byArray[n + k];
                        n5 = k - 2;
                        this.FR[n5] = by;
                        int n7 = n2 + k;
                        byArray2[n7] = this.encryptByte(by, n5);
                    }
                } else if (n4 == 0) {
                    int n8;
                    OpenPGPCFBBlockCipher openPGPCFBBlockCipher = this;
                    byte[] byArray5 = openPGPCFBBlockCipher.FR;
                    byte[] byArray6 = openPGPCFBBlockCipher.FRE;
                    this.cipher.processBlock(byArray5, 0, byArray6, 0);
                    for (int k = 0; k < (n8 = this.blockSize); ++k) {
                        n8 = n + k;
                        this.FR[k] = byArray[n8];
                        byArray2[k] = this.encryptByte(byArray[n8], k);
                    }
                    this.count += n8;
                } else if (n4 == n3) {
                    OpenPGPCFBBlockCipher openPGPCFBBlockCipher = this;
                    OpenPGPCFBBlockCipher openPGPCFBBlockCipher3 = this;
                    byte[] byArray7 = openPGPCFBBlockCipher3.FR;
                    byte[] byArray8 = openPGPCFBBlockCipher3.FRE;
                    this.cipher.processBlock(byArray7, 0, byArray8, 0);
                    int n9 = byArray[n];
                    int n10 = byArray[n + 1];
                    byArray2[n2] = this.encryptByte((byte)n9, 0);
                    int n11 = n2 + 1;
                    byArray2[n11] = this.encryptByte((byte)n10, 1);
                    n11 = this.blockSize - 2;
                    System.arraycopy(openPGPCFBBlockCipher.FR, 2, openPGPCFBBlockCipher.FR, 0, n11);
                    byte[] byArray9 = openPGPCFBBlockCipher.FR;
                    int n12 = this.blockSize;
                    byArray9[n12 - 2] = n9;
                    openPGPCFBBlockCipher.FR[n12 - 1] = n10;
                    openPGPCFBBlockCipher.cipher.processBlock(byArray9, 0, this.FRE, 0);
                    for (n9 = 2; n9 < (n10 = this.blockSize); ++n9) {
                        n10 = byArray[n + n9];
                        int n13 = n9 - 2;
                        this.FR[n13] = n10;
                        int n14 = n2 + n9;
                        byArray2[n14] = this.encryptByte((byte)n10, n13);
                    }
                    this.count += n10;
                }
                return this.blockSize;
            }
            throw new OutputLengthException("output buffer too short");
        }
        throw new DataLengthException("input buffer too short");
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/OpenPGPCFB";
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        return this.forEncryption ? this.encryptBlock(byArray, n, byArray2, n2) : this.decryptBlock(byArray, n, byArray2, n2);
    }

    @Override
    public void reset() {
        OpenPGPCFBBlockCipher openPGPCFBBlockCipher = object;
        openPGPCFBBlockCipher.count = 0;
        Object object = ((OpenPGPCFBBlockCipher)object).FR;
        int n = ((OpenPGPCFBBlockCipher)object).FR.length;
        System.arraycopy(openPGPCFBBlockCipher.IV, 0, object, 0, n);
        openPGPCFBBlockCipher.cipher.reset();
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        OpenPGPCFBBlockCipher openPGPCFBBlockCipher = this;
        openPGPCFBBlockCipher.forEncryption = bl;
        openPGPCFBBlockCipher.reset();
        openPGPCFBBlockCipher.cipher.init(true, cipherParameters);
    }
}

