/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;

public class PaddedBlockCipher
extends BufferedBlockCipher {
    public PaddedBlockCipher(BlockCipher blockCipher) {
        PaddedBlockCipher paddedBlockCipher = this;
        this.cipher = blockCipher;
        paddedBlockCipher.buf = new byte[blockCipher.getBlockSize()];
        paddedBlockCipher.bufOff = 0;
    }

    @Override
    public int getOutputSize(int n) {
        byte[] byArray = this.buf;
        int n2 = (n += this.bufOff) % this.buf.length;
        if (n2 == 0) {
            if (this.forEncryption) {
                return n + byArray.length;
            }
            return n;
        }
        return n - n2 + byArray.length;
    }

    @Override
    public int getUpdateOutputSize(int n) {
        Object object = ((BufferedBlockCipher)object).buf;
        int n2 = (n += ((BufferedBlockCipher)object).bufOff) % ((BufferedBlockCipher)object).buf.length;
        if (n2 == 0) {
            return n - ((Object)object).length;
        }
        return n - n2;
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n) {
        int n2 = 0;
        byte[] byArray2 = this.buf;
        if (this.bufOff == this.buf.length) {
            n2 = this.cipher.processBlock(byArray2, 0, byArray, n);
            this.bufOff = 0;
        }
        int n3 = this.bufOff;
        this.bufOff = n3 + 1;
        this.buf[n3] = by;
        return n2;
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n2 >= 0) {
            PaddedBlockCipher paddedBlockCipher = object;
            int n4 = paddedBlockCipher.getBlockSize();
            int n5 = paddedBlockCipher.getUpdateOutputSize(n2);
            if (n5 > 0 && n3 + n5 > byArray2.length) {
                throw new OutputLengthException("output buffer too short");
            }
            n5 = 0;
            byte[] byArray3 = ((BufferedBlockCipher)object).buf;
            int n6 = ((BufferedBlockCipher)object).bufOff;
            int n7 = ((BufferedBlockCipher)object).buf.length - n6;
            if (n2 > n7) {
                int n8 = n;
                System.arraycopy(byArray, n, byArray3, n6, n7);
                n = ((BufferedBlockCipher)object).cipher.processBlock(((BufferedBlockCipher)object).buf, 0, byArray2, n3) + n5;
                ((BufferedBlockCipher)object).bufOff = 0;
                n2 -= n7;
                int n9 = n5 = n8 + n7;
                n5 = n;
                n = n9;
                while (n2 > ((BufferedBlockCipher)object).buf.length) {
                    int n10 = n;
                    int n11 = n2;
                    n2 = n3 + n5;
                    n = ((BufferedBlockCipher)object).cipher.processBlock(byArray, n, byArray2, n2) + n5;
                    n2 = n11 - n4;
                    int n12 = n5 = n10 + n4;
                    n5 = n;
                    n = n12;
                }
            }
            PaddedBlockCipher paddedBlockCipher2 = object;
            PaddedBlockCipher paddedBlockCipher3 = object;
            Object object = paddedBlockCipher3.buf;
            System.arraycopy(byArray, n, object, paddedBlockCipher3.bufOff, n2);
            paddedBlockCipher2.bufOff += n2;
            return n5;
        }
        throw new IllegalArgumentException("Can't have a negative input length!");
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        block9: {
            block10: {
                int n2;
                block8: {
                    int n3;
                    int n4;
                    block7: {
                        int n5;
                        PaddedBlockCipher paddedBlockCipher = this;
                        n4 = paddedBlockCipher.cipher.getBlockSize();
                        n3 = 0;
                        if (!paddedBlockCipher.forEncryption) break block7;
                        if (this.bufOff == n4) {
                            if (n4 * 2 + n <= byArray.length) {
                                n3 = this.cipher.processBlock(this.buf, 0, byArray, n);
                                this.bufOff = 0;
                            } else {
                                throw new OutputLengthException("output buffer too short");
                            }
                        }
                        byte by = (byte)(n4 - this.bufOff);
                        while ((n5 = this.bufOff) < n4) {
                            this.buf[n5] = by;
                            this.bufOff = n5 + 1;
                        }
                        byte[] byArray2 = this.buf;
                        n4 = n + n3;
                        n2 = this.cipher.processBlock(byArray2, 0, byArray, n4) + n3;
                        break block8;
                    }
                    if (this.bufOff != n4) break block9;
                    PaddedBlockCipher paddedBlockCipher = this;
                    n3 = paddedBlockCipher.cipher.processBlock(this.buf, 0, this.buf, 0);
                    paddedBlockCipher.bufOff = 0;
                    byte[] byArray3 = paddedBlockCipher.buf;
                    int n6 = paddedBlockCipher.buf[n4 - 1] & 0xFF;
                    if (n6 > n4) break block10;
                    n4 = n3 - n6;
                    System.arraycopy(byArray3, 0, byArray, n, n4);
                    n2 = n4;
                }
                this.reset();
                return n2;
            }
            throw new InvalidCipherTextException("pad block corrupted");
        }
        throw new DataLengthException("last block incomplete in decryption");
    }
}

