/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Interleave;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Longs;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public abstract class GCMUtil {
    private static final int E1 = -520093696;
    private static final long E1L = -2233785415175766016L;

    public static byte[] oneAsBytes() {
        byte[] byArray = new byte[16];
        byArray[0] = -128;
        return byArray;
    }

    public static int[] oneAsInts() {
        int[] nArray = new int[4];
        nArray[0] = Integer.MIN_VALUE;
        return nArray;
    }

    public static long[] oneAsLongs() {
        long[] lArray = new long[2];
        lArray[0] = Long.MIN_VALUE;
        return lArray;
    }

    public static byte[] asBytes(int[] nArray) {
        byte[] byArray = new byte[16];
        Pack.intToBigEndian(nArray, byArray, 0);
        return byArray;
    }

    public static void asBytes(int[] nArray, byte[] byArray) {
        Pack.intToBigEndian(nArray, byArray, 0);
    }

    public static byte[] asBytes(long[] lArray) {
        byte[] byArray = new byte[16];
        Pack.longToBigEndian(lArray, byArray, 0);
        return byArray;
    }

    public static void asBytes(long[] lArray, byte[] byArray) {
        Pack.longToBigEndian(lArray, byArray, 0);
    }

    public static int[] asInts(byte[] byArray) {
        int[] nArray = new int[4];
        Pack.bigEndianToInt(byArray, 0, nArray);
        return nArray;
    }

    public static void asInts(byte[] byArray, int[] nArray) {
        Pack.bigEndianToInt(byArray, 0, nArray);
    }

    public static long[] asLongs(byte[] byArray) {
        long[] lArray = new long[2];
        Pack.bigEndianToLong(byArray, 0, lArray);
        return lArray;
    }

    public static void asLongs(byte[] byArray, long[] lArray) {
        Pack.bigEndianToLong(byArray, 0, lArray);
    }

    public static void copy(int[] nArray, int[] nArray2) {
        nArray2[0] = nArray[0];
        nArray2[1] = nArray[1];
        nArray2[2] = nArray[2];
        nArray2[3] = nArray[3];
    }

    public static void copy(long[] lArray, long[] lArray2) {
        long l;
        lArray2[0] = l = lArray[0];
        lArray2[1] = l = lArray[1];
    }

    public static void divideP(long[] lArray, long[] lArray2) {
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = l;
        long l4 = l3 >> 63;
        lArray2[0] = l = (l3 ^ l4 & 0xE100000000000000L) << 1 | l2 >>> 63;
        lArray2[1] = l4 = l2 << 1 | -l4;
    }

    public static void multiply(byte[] byArray, byte[] byArray2) {
        long[] lArray = GCMUtil.asLongs(byArray);
        GCMUtil.multiply(lArray, GCMUtil.asLongs(byArray2));
        GCMUtil.asBytes(lArray, byArray);
    }

    public static void multiply(int[] nArray, int[] nArray2) {
        int n = nArray2[0];
        int n2 = nArray2[1];
        int n3 = nArray2[2];
        int n4 = nArray2[3];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (int k = 0; k < 4; ++k) {
            int n9 = nArray[k];
            for (int i2 = 0; i2 < 32; ++i2) {
                int n10 = n;
                int n11 = n2;
                int n12 = n3;
                int n13 = n4;
                int n14 = n4;
                int n15 = n9;
                n4 = n15 >> 31;
                n9 = n15 << 1;
                n5 ^= n & n4;
                n6 ^= n2 & n4;
                n7 ^= n3 & n4;
                n4 = n8 ^ n14 & n4;
                n8 = n13 << 31 >> 8;
                n3 = n13 >>> 1 | n3 << 31;
                n2 = n12 >>> 1 | n2 << 31;
                n = n11 >>> 1 | n << 31;
                n8 = n10 >>> 1 ^ n8 & 0xE1000000;
                int n16 = n4;
                n4 = n3;
                n3 = n2;
                n2 = n;
                n = n8;
                n8 = n16;
            }
        }
        int[] nArray3 = nArray;
        int[] nArray4 = nArray;
        nArray3[0] = n5;
        nArray4[1] = n6;
        nArray3[2] = n7;
        nArray4[3] = n8;
    }

    public static void multiply(long[] lArray, long[] lArray2) {
        long[] lArray3 = lArray;
        long l = lArray3[0];
        long l2 = lArray[1];
        long l3 = lArray2[0];
        long l4 = lArray2[1];
        long l5 = Longs.reverse(l);
        long l6 = Longs.reverse(l2);
        long l7 = Longs.reverse(l3);
        long l8 = Longs.reverse(l4);
        long l9 = Longs.reverse(GCMUtil.implMul64(l5, l7));
        long l10 = GCMUtil.implMul64(l, l3) << 1;
        long l11 = l;
        long l12 = l2;
        long l13 = l2;
        l2 = Longs.reverse(GCMUtil.implMul64(l6, l8));
        l = GCMUtil.implMul64(l13, l4) << 1;
        l5 = Longs.reverse(GCMUtil.implMul64(l5 ^ l6, l7 ^ l8));
        l3 = GCMUtil.implMul64(l11 ^ l12, l3 ^ l4) << 1;
        long l14 = l10 ^ l9 ^ l2 ^ l5;
        long l15 = l;
        l2 = l2 ^ l10 ^ l ^ l3;
        long l16 = l14 ^ (l15 ^ l15 >>> 1 ^ l >>> 2 ^ l >>> 7);
        long l17 = l2 ^= l << 62 ^ l << 57;
        l = l9 ^ (l17 ^ l17 >>> 1 ^ l2 >>> 2 ^ l2 >>> 7);
        l2 = l16 ^ (l2 << 63 ^ l2 << 62 ^ l2 << 57);
        lArray3[0] = l;
        lArray[1] = l2;
    }

    public static void multiplyP(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = n4 << 31 >> 31;
        nArray[0] = n >>> 1 ^ n5 & 0xE1000000;
        nArray[1] = n2 >>> 1 | n << 31;
        nArray[2] = n3 >>> 1 | n2 << 31;
        nArray[3] = n4 >>> 1 | n3 << 31;
    }

    public static void multiplyP(int[] nArray, int[] nArray2) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = n4 << 31 >> 31;
        nArray2[0] = n >>> 1 ^ n5 & 0xE1000000;
        nArray2[1] = n2 >>> 1 | n << 31;
        nArray2[2] = n3 >>> 1 | n2 << 31;
        nArray2[3] = n4 >>> 1 | n3 << 31;
    }

    public static void multiplyP(long[] lArray) {
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = l2;
        l3 = l3 << 63 >> 63;
        lArray[0] = l3 = l >>> 1 ^ l3 & 0xE100000000000000L;
        lArray[1] = l = l2 >>> 1 | l << 63;
    }

    public static void multiplyP(long[] lArray, long[] lArray2) {
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = l2 << 63 >> 63;
        lArray2[0] = l3 = l >>> 1 ^ l3 & 0xE100000000000000L;
        lArray2[1] = l3 = l2 >>> 1 | l << 63;
    }

    public static void multiplyP3(long[] lArray, long[] lArray2) {
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = l2 << 61;
        lArray2[0] = l3 = l >>> 3 ^ l3 ^ l3 >>> 1 ^ l3 >>> 2 ^ l3 >>> 7;
        lArray2[1] = l3 = l2 >>> 3 | l << 61;
    }

    public static void multiplyP4(long[] lArray, long[] lArray2) {
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = l2 << 60;
        lArray2[0] = l3 = l >>> 4 ^ l3 ^ l3 >>> 1 ^ l3 >>> 2 ^ l3 >>> 7;
        lArray2[1] = l3 = l2 >>> 4 | l << 60;
    }

    public static void multiplyP7(long[] lArray, long[] lArray2) {
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = l2 << 57;
        lArray2[0] = l3 = l >>> 7 ^ l3 ^ l3 >>> 1 ^ l3 >>> 2 ^ l3 >>> 7;
        lArray2[1] = l3 = l2 >>> 7 | l << 57;
    }

    public static void multiplyP8(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = n4 << 24;
        nArray[0] = n >>> 8 ^ n5 ^ n5 >>> 1 ^ n5 >>> 2 ^ n5 >>> 7;
        nArray[1] = n2 >>> 8 | n << 24;
        nArray[2] = n3 >>> 8 | n2 << 24;
        nArray[3] = n4 >>> 8 | n3 << 24;
    }

    public static void multiplyP8(int[] nArray, int[] nArray2) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = n4 << 24;
        nArray2[0] = n >>> 8 ^ n5 ^ n5 >>> 1 ^ n5 >>> 2 ^ n5 >>> 7;
        nArray2[1] = n2 >>> 8 | n << 24;
        nArray2[2] = n3 >>> 8 | n2 << 24;
        nArray2[3] = n4 >>> 8 | n3 << 24;
    }

    public static void multiplyP8(long[] lArray) {
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = l2;
        l3 <<= 56;
        lArray[0] = l3 = l >>> 8 ^ l3 ^ l3 >>> 1 ^ l3 >>> 2 ^ l3 >>> 7;
        lArray[1] = l = l2 >>> 8 | l << 56;
    }

    public static void multiplyP8(long[] lArray, long[] lArray2) {
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = l2 << 56;
        lArray2[0] = l3 = l >>> 8 ^ l3 ^ l3 >>> 1 ^ l3 >>> 2 ^ l3 >>> 7;
        lArray2[1] = l3 = l2 >>> 8 | l << 56;
    }

    public static long[] pAsLongs() {
        long[] lArray = new long[2];
        lArray[0] = 0x4000000000000000L;
        return lArray;
    }

    public static void square(long[] lArray, long[] lArray2) {
        lArray2 = new long[4];
        Interleave.expand64To128Rev(lArray[0], lArray2, 0);
        Interleave.expand64To128Rev(lArray[1], lArray2, 2);
        long l = lArray2[0];
        long l2 = lArray2[2];
        long l3 = lArray2[3];
        long l4 = l2 ^= l3 << 63 ^ l3 << 62 ^ l3 << 57;
        l ^= l4 ^ l4 >>> 1 ^ l2 >>> 2 ^ l2 >>> 7;
        l2 = lArray2[1] ^ (l3 ^ l3 >>> 1 ^ l3 >>> 2 ^ l3 >>> 7) ^ (l2 << 63 ^ l2 << 62 ^ l2 << 57);
        lArray2[0] = l;
        lArray2[1] = l2;
    }

    public static void xor(byte[] byArray, byte[] byArray2) {
        int n = 0;
        do {
            byte[] byArray3 = byArray;
            byArray3[n] = (byte)(byArray[n] ^ byArray2[n]);
            byArray3[++n] = (byte)(byArray3[n] ^ byArray2[n]);
            byArray3[++n] = (byte)(byArray3[n] ^ byArray2[n]);
            byArray[++n] = (byte)(byArray3[n] ^ byArray2[n]);
        } while (++n < 16);
    }

    public static void xor(byte[] byArray, byte[] byArray2, int n) {
        int n2 = 0;
        do {
            byte[] byArray3 = byArray;
            byArray3[n2] = (byte)(byArray[n2] ^ byArray2[n + n2]);
            byArray3[++n2] = (byte)(byArray3[n2] ^ byArray2[n + n2]);
            byArray3[++n2] = (byte)(byArray3[n2] ^ byArray2[n + n2]);
            byArray[++n2] = (byte)(byArray3[n2] ^ byArray2[n + n2]);
        } while (++n2 < 16);
    }

    public static void xor(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, int n3) {
        int n4 = 0;
        do {
            int n5 = n3 + n4;
            byArray3[n5] = (byte)(byArray[n + n4] ^ byArray2[n2 + n4]);
            n5 = n3 + ++n4;
            byArray3[n5] = (byte)(byArray[n + n4] ^ byArray2[n2 + n4]);
            n5 = n3 + ++n4;
            byArray3[n5] = (byte)(byArray[n + n4] ^ byArray2[n2 + n4]);
            n5 = n3 + ++n4;
            byArray3[n5] = (byte)(byArray[n + n4] ^ byArray2[n2 + n4]);
        } while (++n4 < 16);
    }

    public static void xor(byte[] byArray, byte[] byArray2, int n, int n2) {
        while ((n2 += -1) >= 0) {
            byArray[n2] = (byte)(byArray[n2] ^ byArray2[n + n2]);
        }
    }

    public static void xor(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        while ((n3 += -1) >= 0) {
            int n4 = n + n3;
            byArray[n4] = (byte)(byArray[n4] ^ byArray2[n2 + n3]);
        }
    }

    public static void xor(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = 0;
        do {
            byArray3[n] = (byte)(byArray[n] ^ byArray2[n]);
            byArray3[++n] = (byte)(byArray[n] ^ byArray2[n]);
            byArray3[++n] = (byte)(byArray[n] ^ byArray2[n]);
            byArray3[++n] = (byte)(byArray[n] ^ byArray2[n]);
        } while (++n < 16);
    }

    public static void xor(int[] nArray, int[] nArray2) {
        int[] nArray3 = nArray;
        nArray3[0] = nArray[0] ^ nArray2[0];
        nArray3[1] = nArray[1] ^ nArray2[1];
        nArray3[2] = nArray[2] ^ nArray2[2];
        nArray3[3] = nArray[3] ^ nArray2[3];
    }

    public static void xor(int[] nArray, int[] nArray2, int[] nArray3) {
        nArray3[0] = nArray[0] ^ nArray2[0];
        nArray3[1] = nArray[1] ^ nArray2[1];
        nArray3[2] = nArray[2] ^ nArray2[2];
        nArray3[3] = nArray[3] ^ nArray2[3];
    }

    public static void xor(long[] lArray, long[] lArray2) {
        long l;
        long l2;
        long[] lArray3 = lArray;
        lArray3[0] = l2 = lArray[0] ^ lArray2[0];
        lArray3[1] = l = lArray[1] ^ lArray2[1];
    }

    public static void xor(long[] lArray, long[] lArray2, long[] lArray3) {
        long l;
        long l2;
        lArray3[0] = l2 = lArray[0] ^ lArray2[0];
        lArray3[1] = l = lArray[1] ^ lArray2[1];
    }

    private static long implMul64(long l, long l2) {
        long l3 = l & 0x1111111111111111L;
        long l4 = l2;
        long l5 = l;
        l = l5 & 0x2222222222222222L;
        l2 = l5 & 0x4444444444444444L;
        long l6 = l5 & 0x8888888888888888L;
        long l7 = l4 & 0x1111111111111111L;
        long l8 = l4 & 0x2222222222222222L;
        long l9 = l4 & 0x4444444444444444L;
        long l10 = l4 & 0x8888888888888888L;
        long l11 = l3 * l7 ^ l * l10 ^ l2 * l9 ^ l6 * l8;
        long l12 = l3;
        long l13 = l10;
        long l14 = l3;
        l3 = l3 * l8 ^ l * l7 ^ l2 * l10 ^ l6 * l9;
        l10 = l14 * l9 ^ l * l8 ^ l2 * l7 ^ l6 * l10;
        long l15 = l = l12 * l13 ^ l * l9 ^ l2 * l8 ^ l6 * l7;
        l = l3 & 0x2222222222222222L;
        l2 = l10 & 0x4444444444444444L;
        l3 = l15 & 0x8888888888888888L;
        return l11 & 0x1111111111111111L | l | l2 | l3;
    }
}

