/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm.GCMUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class Tables64kGCMMultiplier
implements GCMMultiplier {
    private byte[] H;
    private long[][][] T;

    @Override
    public void init(byte[] byArray) {
        if (this.T == null) {
            this.T = new long[16][256][2];
        } else if (Arrays.areEqual(this.H, byArray)) {
            return;
        }
        this.H = Arrays.clone(byArray);
        for (int k = 0; k < 16; ++k) {
            long[][][] lArray = this.T;
            long[][] lArray2 = this.T[k];
            if (k == 0) {
                GCMUtil.asLongs(this.H, lArray2[1]);
                long[] lArray3 = lArray2[1];
                GCMUtil.multiplyP7(lArray3, lArray3);
            } else {
                GCMUtil.multiplyP8(lArray[k - 1][1], lArray2[1]);
            }
            for (int i2 = 2; i2 < 256; i2 += 2) {
                GCMUtil.divideP(lArray2[i2 >> 1], lArray2[i2]);
                long[] lArray4 = lArray2[1];
                GCMUtil.xor(lArray2[i2], lArray4, lArray2[i2 + 1]);
            }
        }
    }

    @Override
    public void multiplyH(byte[] byArray) {
        long[] lArray = this.T[15][byArray[15] & 0xFF];
        long l = lArray[0];
        long l2 = lArray[1];
        for (int k = 14; k >= 0; --k) {
            long[] lArray2 = this.T[k][byArray[k] & 0xFF];
            l ^= lArray2[0];
            l2 ^= lArray2[1];
        }
        Pack.longToBigEndian(l, byArray, 0);
        Pack.longToBigEndian(l2, byArray, 8);
    }
}

