/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSAKeyGenerationParameters
extends KeyGenerationParameters {
    private BigInteger publicExponent;
    private int certainty;

    public RSAKeyGenerationParameters(BigInteger bigInteger, SecureRandom secureRandom, int n, int n2) {
        super(secureRandom, n);
        if (n >= 12) {
            if (bigInteger.testBit(0)) {
                RSAKeyGenerationParameters rSAKeyGenerationParameters = this;
                rSAKeyGenerationParameters.publicExponent = bigInteger;
                rSAKeyGenerationParameters.certainty = n2;
                return;
            }
            throw new IllegalArgumentException("public exponent cannot be even");
        }
        throw new IllegalArgumentException("key strength too small");
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public int getCertainty() {
        return this.certainty;
    }
}

