/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.DESedeEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs.HMac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.BasicEntropySourceProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.DRBGProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.EntropySource;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.EntropySourceProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.SP800SecureRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg.CTRSP800DRBG;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg.HMacSP800DRBG;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg.HashSP800DRBG;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg.SP80090DRBG;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class SP800SecureRandomBuilder {
    private final SecureRandom random;
    private final EntropySourceProvider entropySourceProvider;
    private byte[] personalizationString;
    private int securityStrength;
    private int entropyBitsRequired;

    public SP800SecureRandomBuilder() {
        this(CryptoServicesRegistrar.getSecureRandom(), false);
    }

    public SP800SecureRandomBuilder(SecureRandom secureRandom, boolean bl) {
        BasicEntropySourceProvider basicEntropySourceProvider;
        ((SP800SecureRandomBuilder)((Object)basicEntropySourceProvider2)).securityStrength = 256;
        ((SP800SecureRandomBuilder)((Object)basicEntropySourceProvider2)).entropyBitsRequired = 256;
        ((SP800SecureRandomBuilder)((Object)basicEntropySourceProvider2)).random = secureRandom;
        BasicEntropySourceProvider basicEntropySourceProvider2 = basicEntropySourceProvider;
        basicEntropySourceProvider = new BasicEntropySourceProvider(secureRandom, bl);
        v1.entropySourceProvider = basicEntropySourceProvider2;
    }

    public SP800SecureRandomBuilder(EntropySourceProvider entropySourceProvider) {
        this.securityStrength = 256;
        this.entropyBitsRequired = 256;
        this.random = null;
        this.entropySourceProvider = entropySourceProvider;
    }

    private static String getSimplifiedName(Digest object) {
        int n = ((String)(object = object.getAlgorithmName())).indexOf(45);
        if (n > 0 && !((String)object).startsWith("SHA3")) {
            return ((String)object).substring(0, n) + ((String)object).substring(n + 1);
        }
        return object;
    }

    public SP800SecureRandomBuilder setPersonalizationString(byte[] byArray) {
        this.personalizationString = Arrays.clone(byArray);
        return this;
    }

    public SP800SecureRandomBuilder setSecurityStrength(int n) {
        this.securityStrength = n;
        return this;
    }

    public SP800SecureRandomBuilder setEntropyBitsRequired(int n) {
        this.entropyBitsRequired = n;
        return this;
    }

    public SP800SecureRandom buildHash(Digest digest, byte[] byArray, boolean bl) {
        SP800SecureRandomBuilder sP800SecureRandomBuilder = object;
        Object object = sP800SecureRandomBuilder.personalizationString;
        return new SP800SecureRandom(((SP800SecureRandomBuilder)object).random, ((SP800SecureRandomBuilder)object).entropySourceProvider.get(((SP800SecureRandomBuilder)object).entropyBitsRequired), new HashDRBGProvider(digest, byArray, (byte[])object, sP800SecureRandomBuilder.securityStrength), bl);
    }

    public SP800SecureRandom buildCTR(BlockCipher blockCipher, int n, byte[] byArray, boolean bl) {
        SP800SecureRandomBuilder sP800SecureRandomBuilder = object;
        Object object = sP800SecureRandomBuilder.personalizationString;
        return new SP800SecureRandom(((SP800SecureRandomBuilder)object).random, ((SP800SecureRandomBuilder)object).entropySourceProvider.get(((SP800SecureRandomBuilder)object).entropyBitsRequired), new CTRDRBGProvider(blockCipher, n, byArray, (byte[])object, sP800SecureRandomBuilder.securityStrength), bl);
    }

    public SP800SecureRandom buildHMAC(Mac mac, byte[] byArray, boolean bl) {
        SP800SecureRandomBuilder sP800SecureRandomBuilder = object;
        Object object = sP800SecureRandomBuilder.personalizationString;
        return new SP800SecureRandom(((SP800SecureRandomBuilder)object).random, ((SP800SecureRandomBuilder)object).entropySourceProvider.get(((SP800SecureRandomBuilder)object).entropyBitsRequired), new HMacDRBGProvider(mac, byArray, (byte[])object, sP800SecureRandomBuilder.securityStrength), bl);
    }

    public static class CTRDRBGProvider
    implements DRBGProvider {
        private final BlockCipher blockCipher;
        private final int keySizeInBits;
        private final byte[] nonce;
        private final byte[] personalizationString;
        private final int securityStrength;

        public CTRDRBGProvider(BlockCipher blockCipher, int n, byte[] byArray, byte[] byArray2, int n2) {
            this.blockCipher = blockCipher;
            this.keySizeInBits = n;
            this.nonce = byArray;
            this.personalizationString = byArray2;
            this.securityStrength = n2;
        }

        @Override
        public String getAlgorithm() {
            if (this.blockCipher instanceof DESedeEngine) {
                return "CTR-DRBG-3KEY-TDES";
            }
            return b.a("CTR-DRBG-").append(this.blockCipher.getAlgorithmName()).append(this.keySizeInBits).toString();
        }

        @Override
        public SP80090DRBG get(EntropySource entropySource) {
            CTRDRBGProvider cTRDRBGProvider = blockCipher;
            BlockCipher blockCipher = cTRDRBGProvider.blockCipher;
            int n = cTRDRBGProvider.keySizeInBits;
            int n2 = cTRDRBGProvider.securityStrength;
            byte[] byArray = cTRDRBGProvider.personalizationString;
            byte[] byArray2 = cTRDRBGProvider.nonce;
            return new CTRSP800DRBG(blockCipher, n, n2, entropySource, byArray, byArray2);
        }
    }

    public static class HMacDRBGProvider
    implements DRBGProvider {
        private final Mac hMac;
        private final byte[] nonce;
        private final byte[] personalizationString;
        private final int securityStrength;

        public HMacDRBGProvider(Mac mac, byte[] byArray, byte[] byArray2, int n) {
            this.hMac = mac;
            this.nonce = byArray;
            this.personalizationString = byArray2;
            this.securityStrength = n;
        }

        @Override
        public String getAlgorithm() {
            if (this.hMac instanceof HMac) {
                return b.a("HMAC-DRBG-").append(SP800SecureRandomBuilder.getSimplifiedName(((HMac)this.hMac).getUnderlyingDigest())).toString();
            }
            return b.a("HMAC-DRBG-").append(this.hMac.getAlgorithmName()).toString();
        }

        @Override
        public SP80090DRBG get(EntropySource entropySource) {
            HMacDRBGProvider hMacDRBGProvider = mac;
            Mac mac = hMacDRBGProvider.hMac;
            int n = hMacDRBGProvider.securityStrength;
            byte[] byArray = hMacDRBGProvider.personalizationString;
            byte[] byArray2 = hMacDRBGProvider.nonce;
            return new HMacSP800DRBG(mac, n, entropySource, byArray, byArray2);
        }
    }

    public static class HashDRBGProvider
    implements DRBGProvider {
        private final Digest digest;
        private final byte[] nonce;
        private final byte[] personalizationString;
        private final int securityStrength;

        public HashDRBGProvider(Digest digest, byte[] byArray, byte[] byArray2, int n) {
            this.digest = digest;
            this.nonce = byArray;
            this.personalizationString = byArray2;
            this.securityStrength = n;
        }

        @Override
        public String getAlgorithm() {
            return b.a("HASH-DRBG-").append(SP800SecureRandomBuilder.getSimplifiedName(this.digest)).toString();
        }

        @Override
        public SP80090DRBG get(EntropySource entropySource) {
            HashDRBGProvider hashDRBGProvider = digest;
            Digest digest = hashDRBGProvider.digest;
            int n = hashDRBGProvider.securityStrength;
            byte[] byArray = hashDRBGProvider.personalizationString;
            byte[] byArray2 = hashDRBGProvider.nonce;
            return new HashSP800DRBG(digest, n, entropySource, byArray, byArray2);
        }
    }
}

