/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTNamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.EntropySource;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg.DualECPoints;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg.SP80090DRBG;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class DualECSP800DRBG
implements SP80090DRBG {
    private static final BigInteger p256_Px;
    private static final BigInteger p256_Py;
    private static final BigInteger p256_Qx;
    private static final BigInteger p256_Qy;
    private static final BigInteger p384_Px;
    private static final BigInteger p384_Py;
    private static final BigInteger p384_Qx;
    private static final BigInteger p384_Qy;
    private static final BigInteger p521_Px;
    private static final BigInteger p521_Py;
    private static final BigInteger p521_Qx;
    private static final BigInteger p521_Qy;
    private static final DualECPoints[] nistPoints;
    private static final long RESEED_MAX = 0x80000000L;
    private static final int MAX_ADDITIONAL_INPUT = 4096;
    private static final int MAX_ENTROPY_LENGTH = 4096;
    private static final int MAX_PERSONALIZATION_STRING = 4096;
    private Digest _digest;
    private long _reseedCounter;
    private EntropySource _entropySource;
    private int _securityStrength;
    private int _seedlen;
    private int _outlen;
    private ECCurve.Fp _curve;
    private ECPoint _P;
    private ECPoint _Q;
    private byte[] _s;
    private int _sLength;
    private ECMultiplier _fixedPointMultiplier = new FixedPointCombMultiplier();

    public DualECSP800DRBG(Digest digest, int n, EntropySource entropySource, byte[] byArray, byte[] byArray2) {
        this(nistPoints, digest, n, entropySource, byArray, byArray2);
    }

    public DualECSP800DRBG(DualECPoints[] dualECPointsArray, Digest digest, int n, EntropySource object, byte[] byArray, byte[] byArray2) {
        ((DualECSP800DRBG)object2)._digest = digest;
        ((DualECSP800DRBG)object2)._entropySource = object;
        ((DualECSP800DRBG)object2)._securityStrength = n;
        if (!Utils.isTooLarge(byArray, 512)) {
            if (object.entropySize() >= n && object.entropySize() <= 4096) {
                object = Arrays.concatenate(((DualECSP800DRBG)object2).getEntropy(), byArray2, byArray);
                for (int k = 0; k != dualECPointsArray.length; ++k) {
                    if (n > dualECPointsArray[k].getSecurityStrength()) continue;
                    if (Utils.getMaxSecurityStrength(digest) >= dualECPointsArray[k].getSecurityStrength()) {
                        ((DualECSP800DRBG)object2)._seedlen = dualECPointsArray[k].getSeedLen();
                        ((DualECSP800DRBG)object2)._outlen = dualECPointsArray[k].getMaxOutlen() / 8;
                        ((DualECSP800DRBG)object2)._P = dualECPointsArray[k].getP();
                        ((DualECSP800DRBG)object2)._Q = dualECPointsArray[k].getQ();
                        break;
                    }
                    throw new IllegalArgumentException("Requested security strength is not supported by digest");
                }
                if (((DualECSP800DRBG)object2)._P != null) {
                    byte[] byArray3 = Utils.hash_df(((DualECSP800DRBG)object2)._digest, (byte[])object, ((DualECSP800DRBG)object2)._seedlen);
                    Object object2 = byArray3;
                    v1._s = byArray3;
                    v1._sLength = ((Object)object2).length;
                    v1._reseedCounter = 0L;
                    return;
                }
                throw new IllegalArgumentException("security strength cannot be greater than 256 bits");
            }
            throw new IllegalArgumentException("EntropySource must provide between " + n + " and " + 4096 + " bits");
        }
        throw new IllegalArgumentException("Personalization string too large");
    }

    private byte[] getEntropy() {
        byte[] byArray = this._entropySource.getEntropy();
        if (byArray.length >= (this._securityStrength + 7) / 8) {
            return byArray;
        }
        throw new IllegalStateException("Insufficient entropy provided by entropy source");
    }

    private byte[] xor(byte[] byArray, byte[] byArray2) {
        if (byArray2 == null) {
            return byArray;
        }
        int n = byArray.length;
        byte[] byArray3 = new byte[n];
        for (int k = 0; k != n; ++k) {
            byArray3[k] = (byte)(byArray[k] ^ byArray2[k]);
        }
        return byArray3;
    }

    private byte[] pad8(byte[] byArray, int n) {
        int n2 = n % 8;
        if (n2 == 0) {
            return byArray;
        }
        n2 = 8 - n2;
        n = 0;
        for (int k = byArray.length - 1; k >= 0; --k) {
            int n3 = byArray[k] & 0xFF;
            byArray[k] = (byte)(n3 << n2 | n >> 8 - n2);
            n = n3;
        }
        return byArray;
    }

    private BigInteger getScalarMultipleXCoord(ECPoint eCPoint, BigInteger bigInteger) {
        return this._fixedPointMultiplier.multiply(eCPoint, bigInteger).normalize().getAffineXCoord().toBigInteger();
    }

    static {
        DualECPoints dualECPoints;
        DualECPoints dualECPoints2;
        DualECPoints dualECPoints3;
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5;
        BigInteger bigInteger6;
        BigInteger bigInteger7;
        BigInteger bigInteger8;
        BigInteger bigInteger9;
        BigInteger bigInteger10;
        BigInteger bigInteger11;
        BigInteger bigInteger12;
        Object object = bigInteger12;
        p256_Px = new BigInteger("6b17d1f2e12c4247f8bce6e563a440f277037d812deb33a0f4a13945d898c296", 16);
        Object object2 = bigInteger11;
        p256_Py = new BigInteger("4fe342e2fe1a7f9b8ee7eb4a7c0f9e162bce33576b315ececbb6406837bf51f5", 16);
        Object object3 = bigInteger10;
        p256_Qx = new BigInteger("c97445f45cdef9f0d3e05e1e585fc297235b82b5be8ff3efca67c59852018192", 16);
        BigInteger bigInteger13 = bigInteger9;
        p256_Qy = new BigInteger("b28ef557ba31dfcbdd21ac46e2a91e3c304f44cb87058ada2cb815151e610046", 16);
        BigInteger bigInteger14 = bigInteger8;
        p384_Px = new BigInteger("aa87ca22be8b05378eb1c71ef320ad746e1d3b628ba79b9859f741e082542a385502f25dbf55296c3a545e3872760ab7", 16);
        BigInteger bigInteger15 = bigInteger7;
        p384_Py = new BigInteger("3617de4a96262c6f5d9e98bf9292dc29f8f41dbd289a147ce9da3113b5f0b8c00a60b1ce1d7e819d7a431d7c90ea0e5f", 16);
        BigInteger bigInteger16 = bigInteger6;
        p384_Qx = new BigInteger("8e722de3125bddb05580164bfe20b8b432216a62926c57502ceede31c47816edd1e89769124179d0b695106428815065", 16);
        BigInteger bigInteger17 = bigInteger5;
        p384_Qy = new BigInteger("023b1660dd701d0839fd45eec36f9ee7b32e13b315dc02610aa1b636e346df671f790f84c5e09b05674dbb7e45c803dd", 16);
        BigInteger bigInteger18 = bigInteger4;
        p521_Px = new BigInteger("c6858e06b70404e9cd9e3ecb662395b4429c648139053fb521f828af606b4d3dbaa14b5e77efe75928fe1dc127a2ffa8de3348b3c1856a429bf97e7e31c2e5bd66", 16);
        BigInteger bigInteger19 = bigInteger3;
        p521_Py = new BigInteger("11839296a789a3bc0045c8a5fb42c7d1bd998f54449579b446817afbd17273e662c97ee72995ef42640c550b9013fad0761353c7086a272c24088be94769fd16650", 16);
        BigInteger bigInteger20 = bigInteger2;
        p521_Qx = new BigInteger("1b9fa3e518d683c6b65763694ac8efbaec6fab44f2276171a42726507dd08add4c3b3f4c1ebc5b1222ddba077f722943b24c3edfa0f85fe24d0c8c01591f0be6f63", 16);
        BigInteger bigInteger21 = bigInteger;
        p521_Qy = new BigInteger("1f3bdba585295d9a1110d1df1f9430ef8442c5018976ff3437ef91b81dc0b8132c8d5c39c32d0e004a3092b7d327c0e7a4d26d2c7b69b58f9066652911e457779de", 16);
        DualECPoints[] dualECPointsArray = new DualECPoints[3];
        nistPoints = dualECPointsArray;
        ECCurve.Fp fp = (ECCurve.Fp)NISTNamedCurves.getByName("P-256").getCurve();
        DualECPoints dualECPoints4 = dualECPoints3;
        object = fp.createPoint((BigInteger)object, (BigInteger)object2);
        object2 = fp.createPoint((BigInteger)object3, bigInteger13);
        dualECPoints3 = new DualECPoints(128, (ECPoint)object, (ECPoint)object2, 1);
        dualECPointsArray[0] = dualECPoints4;
        object = (ECCurve.Fp)NISTNamedCurves.getByName("P-384").getCurve();
        object2 = dualECPoints2;
        Object object4 = object;
        object = ((ECCurve)object).createPoint(bigInteger14, bigInteger15);
        object3 = ((ECCurve)object4).createPoint(bigInteger16, bigInteger17);
        dualECPoints2 = new DualECPoints(192, (ECPoint)object, (ECPoint)object3, 1);
        dualECPointsArray[1] = object2;
        object = (ECCurve.Fp)NISTNamedCurves.getByName("P-521").getCurve();
        object2 = dualECPoints;
        Object object5 = object;
        object = ((ECCurve)object).createPoint(bigInteger18, bigInteger19);
        object3 = ((ECCurve)object5).createPoint(bigInteger20, bigInteger21);
        dualECPoints = new DualECPoints(256, (ECPoint)object, (ECPoint)object3, 1);
        dualECPointsArray[2] = object2;
    }

    @Override
    public int getBlockSize() {
        return this._outlen * 8;
    }

    @Override
    public int generate(byte[] byArray, byte[] byArray2, boolean bl) {
        int n = byArray.length * 8;
        int n2 = byArray.length / this._outlen;
        if (!Utils.isTooLarge(byArray2, 512)) {
            int n3;
            BigInteger bigInteger;
            if (this._reseedCounter + (long)n2 > 0x80000000L) {
                return -1;
            }
            if (bl) {
                this.reseed(byArray2);
                byArray2 = null;
            }
            if (byArray2 != null) {
                BigInteger bigInteger2;
                byArray2 = Utils.hash_df(this._digest, byArray2, this._seedlen);
                bigInteger = bigInteger2;
                DualECSP800DRBG dualECSP800DRBG = this;
                bigInteger2 = new BigInteger(1, dualECSP800DRBG.xor(dualECSP800DRBG._s, byArray2));
            } else {
                BigInteger bigInteger3;
                bigInteger = bigInteger3;
                bigInteger3 = new BigInteger(1, this._s);
            }
            Arrays.fill(byArray, (byte)0);
            int n4 = 0;
            for (n3 = 0; n3 < n2; ++n3) {
                int n5;
                DualECSP800DRBG dualECSP800DRBG = this;
                byte[] byArray3 = dualECSP800DRBG.getScalarMultipleXCoord(dualECSP800DRBG._Q, bigInteger = dualECSP800DRBG.getScalarMultipleXCoord(dualECSP800DRBG._P, bigInteger)).toByteArray();
                if (byArray3.length > (n5 = this._outlen)) {
                    System.arraycopy(byArray3, byArray3.length - n5, byArray, n4, n5);
                } else {
                    int n6 = n5 - byArray3.length + n4;
                    n5 = byArray3.length;
                    System.arraycopy(byArray3, 0, byArray, n6, n5);
                }
                n4 += this._outlen;
                ++this._reseedCounter;
            }
            if (n4 < byArray.length) {
                DualECSP800DRBG dualECSP800DRBG = this;
                bigInteger = dualECSP800DRBG.getScalarMultipleXCoord(dualECSP800DRBG._P, bigInteger);
                byte[] byArray4 = dualECSP800DRBG.getScalarMultipleXCoord(dualECSP800DRBG._Q, bigInteger).toByteArray();
                n3 = byArray.length - n4;
                int n7 = this._outlen;
                if (byArray4.length > n7) {
                    System.arraycopy(byArray4, byArray4.length - n7, byArray, n4, n3);
                } else {
                    n4 = n7 - byArray4.length + n4;
                    System.arraycopy(byArray4, 0, byArray, n4, n3);
                }
                ++this._reseedCounter;
            }
            DualECSP800DRBG dualECSP800DRBG = this;
            this._s = BigIntegers.asUnsignedByteArray(this._sLength, dualECSP800DRBG.getScalarMultipleXCoord(dualECSP800DRBG._P, bigInteger));
            return n;
        }
        throw new IllegalArgumentException("Additional input too large");
    }

    @Override
    public void reseed(byte[] byArray) {
        if (!Utils.isTooLarge(byArray, 512)) {
            DualECSP800DRBG dualECSP800DRBG = this;
            byte[] byArray2 = dualECSP800DRBG.getEntropy();
            byte[] byArray3 = dualECSP800DRBG._s;
            byArray = Arrays.concatenate(dualECSP800DRBG.pad8(byArray3, dualECSP800DRBG._seedlen), byArray2, byArray);
            dualECSP800DRBG._s = Utils.hash_df(dualECSP800DRBG._digest, byArray, this._seedlen);
            dualECSP800DRBG._reseedCounter = 0L;
            return;
        }
        throw new IllegalArgumentException("Additional input string too large");
    }
}

