/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.EntropySource;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg.SP80090DRBG;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.util.Hashtable;

public class HashSP800DRBG
implements SP80090DRBG {
    private static final byte[] ONE = new byte[]{1};
    private static final long RESEED_MAX = 0x800000000000L;
    private static final int MAX_BITS_REQUEST = 262144;
    private static final Hashtable seedlens = new Hashtable<String, Integer>();
    private Digest _digest;
    private byte[] _V;
    private byte[] _C;
    private long _reseedCounter;
    private EntropySource _entropySource;
    private int _securityStrength;
    private int _seedLength;

    public HashSP800DRBG(Digest object, int n, EntropySource entropySource, byte[] byArray, byte[] byArray2) {
        if (n <= Utils.getMaxSecurityStrength((Digest)object)) {
            if (entropySource.entropySize() >= n) {
                HashSP800DRBG hashSP800DRBG = this;
                this._digest = object;
                this._entropySource = entropySource;
                hashSP800DRBG._securityStrength = n;
                hashSP800DRBG._seedLength = (Integer)seedlens.get(object.getAlgorithmName());
                object = Arrays.concatenate(hashSP800DRBG.getEntropy(), byArray2, byArray);
                this._V = Utils.hash_df(hashSP800DRBG._digest, (byte[])object, this._seedLength);
                object = new byte[this._V.length + 1];
                n = this._V.length;
                System.arraycopy(this._V, 0, object, 1, n);
                hashSP800DRBG._C = Utils.hash_df(hashSP800DRBG._digest, (byte[])object, this._seedLength);
                hashSP800DRBG._reseedCounter = 1L;
                return;
            }
            throw new IllegalArgumentException("Not enough entropy for security strength required");
        }
        throw new IllegalArgumentException("Requested security strength is not supported by the derivation function");
    }

    private byte[] getEntropy() {
        byte[] byArray = this._entropySource.getEntropy();
        if (byArray.length >= (this._securityStrength + 7) / 8) {
            return byArray;
        }
        throw new IllegalStateException("Insufficient entropy provided by entropy source");
    }

    private void addTo(byte[] byArray, byte[] byArray2) {
        int n;
        int n2 = 0;
        for (n = 1; n <= byArray2.length; ++n) {
            int n3 = (n2 = (byArray[byArray.length - n] & 0xFF) + (byArray2[byArray2.length - n] & 0xFF) + n2) > 255 ? 1 : 0;
            int n4 = n2;
            n2 = byArray.length - n;
            byArray[n2] = (byte)n4;
            n2 = n3;
        }
        for (int k = byArray2.length + 1; k <= byArray.length; ++k) {
            n = (n2 = (byArray[byArray.length - k] & 0xFF) + n2) > 255 ? 1 : 0;
            int n5 = n2;
            n2 = byArray.length - k;
            byArray[n2] = (byte)n5;
            n2 = n;
        }
    }

    private byte[] hash(byte[] byArray) {
        byte[] byArray2 = new byte[this._digest.getDigestSize()];
        this.doHash(byArray, byArray2);
        return byArray2;
    }

    private void doHash(byte[] byArray, byte[] byArray2) {
        HashSP800DRBG hashSP800DRBG = this;
        hashSP800DRBG._digest.update(byArray, 0, byArray.length);
        hashSP800DRBG._digest.doFinal(byArray2, 0);
    }

    private byte[] hashgen(byte[] byArray, int n) {
        int n2 = n;
        n = this._digest.getDigestSize();
        int n3 = n2 / 8;
        int n4 = n3 / n;
        byte[] byArray2 = new byte[byArray.length];
        int n5 = byArray.length;
        System.arraycopy(byArray, 0, byArray2, 0, n5);
        byte[] byArray3 = new byte[n3];
        int n6 = this._digest.getDigestSize();
        byte[] byArray4 = new byte[n6];
        for (int k = 0; k <= n4; ++k) {
            this.doHash(byArray2, byArray4);
            int n7 = k * n6;
            int n8 = n3 - n7;
            if (n8 > n6) {
                n8 = n6;
            }
            System.arraycopy(byArray4, 0, byArray3, n7, n8);
            this.addTo(byArray2, ONE);
        }
        return byArray3;
    }

    static {
        seedlens.put("SHA-1", Integers.valueOf(440));
        seedlens.put("SHA-224", Integers.valueOf(440));
        seedlens.put("SHA-256", Integers.valueOf(440));
        seedlens.put("SHA-512/256", Integers.valueOf(440));
        seedlens.put("SHA-512/224", Integers.valueOf(440));
        seedlens.put("SHA-384", Integers.valueOf(888));
        seedlens.put("SHA-512", Integers.valueOf(888));
    }

    @Override
    public int getBlockSize() {
        return this._digest.getDigestSize() * 8;
    }

    @Override
    public int generate(byte[] byArray, byte[] byArray2, boolean bl) {
        int n = byArray.length * 8;
        if (n <= 262144) {
            if (this._reseedCounter > 0x800000000000L) {
                return -1;
            }
            if (bl) {
                this.reseed(byArray2);
                byArray2 = null;
            }
            if (byArray2 != null) {
                HashSP800DRBG hashSP800DRBG = this;
                HashSP800DRBG hashSP800DRBG2 = this;
                byte[] byArray3 = new byte[hashSP800DRBG2._V.length + 1 + byArray2.length];
                byArray2 = byArray3;
                byArray3[0] = 2;
                int byArray6 = hashSP800DRBG2._V.length;
                System.arraycopy(hashSP800DRBG2._V, 0, byArray2, 1, byArray6);
                int n2 = hashSP800DRBG2._V.length + 1;
                int n3 = byArray2.length;
                System.arraycopy(byArray2, 0, byArray2, n2, n3);
                byArray2 = hashSP800DRBG.hash(byArray2);
                hashSP800DRBG.addTo(hashSP800DRBG._V, byArray2);
            }
            HashSP800DRBG hashSP800DRBG = this;
            byte[] byArray4 = hashSP800DRBG.hashgen(hashSP800DRBG._V, n);
            HashSP800DRBG hashSP800DRBG3 = this;
            byArray2 = hashSP800DRBG3._V;
            byte[] byArray5 = new byte[hashSP800DRBG3._V.length + 1];
            byte[] byArray6 = byArray5;
            int n3 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray6, 1, n3);
            byArray5[0] = 3;
            byte[] byArray7 = hashSP800DRBG3.hash(byArray5);
            hashSP800DRBG3.addTo(hashSP800DRBG3._V, byArray7);
            byArray7 = hashSP800DRBG3._V;
            hashSP800DRBG3.addTo(byArray7, hashSP800DRBG3._C);
            byte[] byArray8 = new byte[4];
            byArray7 = byArray8;
            long l = this._reseedCounter;
            byArray7[0] = (byte)(l >> 24);
            byArray7[1] = (byte)(l >> 16);
            byArray8[2] = (byte)(l >> 8);
            byArray8[3] = (byte)l;
            hashSP800DRBG3.addTo(hashSP800DRBG3._V, byArray7);
            ++hashSP800DRBG3._reseedCounter;
            int n4 = byArray.length;
            System.arraycopy(byArray4, 0, byArray, 0, n4);
            return n;
        }
        throw new IllegalArgumentException("Number of bits per request limited to 262144");
    }

    @Override
    public void reseed(byte[] byArray) {
        HashSP800DRBG hashSP800DRBG = this;
        byte[] byArray2 = hashSP800DRBG.getEntropy();
        byArray = Arrays.concatenate(ONE, this._V, byArray2, byArray);
        this._V = Utils.hash_df(hashSP800DRBG._digest, byArray, this._seedLength);
        byte[] byArray3 = new byte[this._V.length + 1];
        byArray = byArray3;
        byArray3[0] = 0;
        int n = this._V.length;
        System.arraycopy(this._V, 0, byArray, 1, n);
        hashSP800DRBG._C = Utils.hash_df(hashSP800DRBG._digest, byArray, this._seedLength);
        hashSP800DRBG._reseedCounter = 1L;
    }
}

