/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DSA;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DSAExt;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSAEncoding;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.StandardDSAEncoding;
import java.math.BigInteger;

public class DSADigestSigner
implements Signer {
    private final DSA dsa;
    private final Digest digest;
    private final DSAEncoding encoding;
    private boolean forSigning;

    public DSADigestSigner(DSA dSA, Digest digest) {
        DSADigestSigner dSADigestSigner = this;
        this.dsa = dSA;
        dSADigestSigner.digest = digest;
        dSADigestSigner.encoding = StandardDSAEncoding.INSTANCE;
    }

    public DSADigestSigner(DSAExt dSAExt, Digest digest, DSAEncoding dSAEncoding) {
        this.dsa = dSAExt;
        this.digest = digest;
        this.encoding = dSAEncoding;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forSigning = bl;
        AsymmetricKeyParameter asymmetricKeyParameter = cipherParameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)cipherParameters).getParameters() : (AsymmetricKeyParameter)cipherParameters;
        if (bl && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Signing Requires Private Key.");
        }
        if (!bl && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Verification Requires Public Key.");
        }
        DSADigestSigner dSADigestSigner = this;
        dSADigestSigner.reset();
        dSADigestSigner.dsa.init(bl, cipherParameters);
    }

    @Override
    public void update(byte by) {
        this.digest.update(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    @Override
    public byte[] generateSignature() {
        if (((DSADigestSigner)((Object)bigInteger)).forSigning) {
            Object[] objectArray;
            Object[] objectArray2;
            DSAEncoding dSAEncoding;
            DSADigestSigner dSADigestSigner = bigInteger;
            Object object = new byte[dSADigestSigner.digest.getDigestSize()];
            dSADigestSigner.digest.doFinal((byte[])object, 0);
            object = dSADigestSigner.dsa.generateSignature((byte[])object);
            try {
                dSAEncoding = dSADigestSigner.encoding;
                objectArray2 = object;
                objectArray = object;
                BigInteger bigInteger = ((DSADigestSigner)((Object)bigInteger)).getOrder();
            }
            catch (Exception exception) {
                throw new IllegalStateException("unable to encode signature");
            }
            object = objectArray2[0];
            byte by = objectArray[1];
            return dSAEncoding.encode(bigInteger, (BigInteger)object, (BigInteger)by);
        }
        throw new IllegalStateException("DSADigestSigner not initialised for signature generation.");
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        if (!object.forSigning) {
            Object object;
            BigInteger[] bigIntegerArray = object;
            byte[] byArray2 = new byte[object.digest.getDigestSize()];
            bigIntegerArray.digest.doFinal(byArray2, 0);
            try {
                object = object.encoding.decode(object.getOrder(), byArray);
            }
            catch (Exception exception) {
                return false;
            }
            DSA dSA = bigIntegerArray.dsa;
            byte[] byArray3 = byArray2;
            BigInteger[] bigIntegerArray2 = object;
            object = object[0];
            return dSA.verifySignature(byArray3, (BigInteger)object, bigIntegerArray2[1]);
        }
        throw new IllegalStateException("DSADigestSigner not initialised for verification");
    }

    @Override
    public void reset() {
        this.digest.reset();
    }

    public BigInteger getOrder() {
        DSA dSA = ((DSADigestSigner)((Object)dSA)).dsa;
        return dSA instanceof DSAExt ? ((DSAExt)dSA).getOrder() : null;
    }
}

