/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DSAExt;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECNRSigner
implements DSAExt {
    private boolean forSigning;
    private ECKeyParameters key;
    private SecureRandom random;

    private BigInteger extractT(ECPublicKeyParameters object, BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = ((ECKeyParameters)object).getParameters().getN();
        if (bigInteger.compareTo(ECConstants.ONE) >= 0 && bigInteger.compareTo(bigInteger3) < 0) {
            if (bigInteger2.compareTo(ECConstants.ZERO) >= 0 && bigInteger2.compareTo(bigInteger3) < 0) {
                if (((ECPoint)(object = ECAlgorithms.sumOfTwoMultiplies(((ECKeyParameters)object).getParameters().getG(), bigInteger2, ((ECPublicKeyParameters)object).getQ(), bigInteger).normalize())).isInfinity()) {
                    return null;
                }
                return bigInteger.subtract(((ECPoint)object).getAffineXCoord().toBigInteger()).mod(bigInteger3);
            }
            return null;
        }
        return null;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        ((ECNRSigner)((Object)parametersWithRandom)).forSigning = bl;
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ECNRSigner eCNRSigner = parametersWithRandom;
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                eCNRSigner.random = parametersWithRandom.getRandom();
                eCNRSigner.key = (ECPrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                ((ECNRSigner)((Object)parametersWithRandom)).random = CryptoServicesRegistrar.getSecureRandom();
                ((ECNRSigner)((Object)parametersWithRandom)).key = (ECPrivateKeyParameters)cipherParameters;
            }
        } else {
            ((ECNRSigner)((Object)parametersWithRandom)).key = (ECPublicKeyParameters)cipherParameters;
        }
    }

    @Override
    public BigInteger getOrder() {
        return this.key.getParameters().getN();
    }

    @Override
    public BigInteger[] generateSignature(byte[] object) {
        if (((ECNRSigner)object3).forSigning) {
            BigInteger bigInteger;
            BigInteger bigInteger2 = ((ECNRSigner)object3).getOrder();
            BigInteger bigInteger3 = bigInteger;
            bigInteger3(1, (byte[])object);
            object = (ECPrivateKeyParameters)((ECNRSigner)object3).key;
            if (bigInteger.compareTo(bigInteger2) < 0) {
                ECKeyPairGenerator eCKeyPairGenerator;
                Object object2;
                BigInteger bigInteger4;
                do {
                    eCKeyPairGenerator = new ECKeyPairGenerator();
                    object2 = ((ECKeyParameters)object).getParameters();
                    eCKeyPairGenerator.init(new ECKeyGenerationParameters((ECDomainParameters)object2, ((ECNRSigner)object3).random));
                } while ((bigInteger4 = ((ECPublicKeyParameters)((AsymmetricCipherKeyPair)(object2 = eCKeyPairGenerator.generateKeyPair())).getPublic()).getQ().getAffineXCoord().toBigInteger().add(bigInteger3).mod(bigInteger2)).equals(ECConstants.ZERO));
                Object object3 = ((ECPrivateKeyParameters)object).getD();
                object3 = ((ECPrivateKeyParameters)((AsymmetricCipherKeyPair)object2).getPrivate()).getD().subtract(bigInteger4.multiply((BigInteger)object3)).mod(bigInteger2);
                return new BigInteger[]{bigInteger4, object3};
            }
            throw new DataLengthException("input too large for ECNR key");
        }
        throw new IllegalStateException("not initialised for signing");
    }

    @Override
    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        if (!((ECNRSigner)this).forSigning) {
            BigInteger bigInteger3;
            ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)((ECNRSigner)this).key;
            BigInteger bigInteger4 = eCPublicKeyParameters.getParameters().getN();
            BigInteger bigInteger5 = bigInteger3;
            if (new BigInteger(1, byArray).bitLength() <= bigInteger4.bitLength()) {
                return (this = ((ECNRSigner)this).extractT(eCPublicKeyParameters, bigInteger, bigInteger2)) != null && ((BigInteger)this).equals(bigInteger5.mod(bigInteger4));
            }
            throw new DataLengthException("input too large for ECNR key.");
        }
        throw new IllegalStateException("not initialised for verifying");
    }

    public byte[] getRecoveredMessage(BigInteger bigInteger, BigInteger bigInteger2) {
        if (!((ECNRSigner)((Object)bigInteger3)).forSigning) {
            ECNRSigner eCNRSigner = bigInteger3;
            BigInteger bigInteger3 = eCNRSigner.extractT((ECPublicKeyParameters)eCNRSigner.key, bigInteger, bigInteger2);
            if (bigInteger3 != null) {
                return BigIntegers.asUnsignedByteArray(bigInteger3);
            }
            return null;
        }
        throw new IllegalStateException("not initialised for verifying/recovery");
    }
}

