/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSABlindingParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class PSSSigner
implements Signer {
    public static final byte TRAILER_IMPLICIT = -68;
    private Digest contentDigest;
    private Digest mgfDigest;
    private AsymmetricBlockCipher cipher;
    private SecureRandom random;
    private int hLen;
    private int mgfhLen;
    private boolean sSet;
    private int sLen;
    private int emBits;
    private byte[] salt;
    private byte[] mDash;
    private byte[] block;
    private byte trailer;

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, int n) {
        this(asymmetricBlockCipher, digest, n, -68);
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, int n) {
        this(asymmetricBlockCipher, digest, digest2, n, -68);
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, int n, byte by) {
        Digest digest2 = digest;
        this(asymmetricBlockCipher, digest2, digest2, n, by);
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, int n, byte by) {
        PSSSigner pSSSigner = this;
        this.cipher = asymmetricBlockCipher;
        this.contentDigest = digest;
        this.mgfDigest = digest2;
        this.hLen = digest.getDigestSize();
        pSSSigner.mgfhLen = digest2.getDigestSize();
        pSSSigner.sSet = false;
        this.sLen = n;
        this.salt = new byte[n];
        this.mDash = new byte[n + 8 + this.hLen];
        this.trailer = by;
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, byte[] byArray) {
        Digest digest2 = digest;
        this(asymmetricBlockCipher, digest2, digest2, byArray, -68);
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, byte[] byArray) {
        this(asymmetricBlockCipher, digest, digest2, byArray, -68);
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, byte[] byArray, byte by) {
        int n;
        PSSSigner pSSSigner = this;
        this.cipher = asymmetricBlockCipher;
        this.contentDigest = digest;
        this.mgfDigest = digest2;
        this.hLen = digest.getDigestSize();
        pSSSigner.mgfhLen = digest2.getDigestSize();
        pSSSigner.sSet = true;
        this.sLen = n = byArray.length;
        this.salt = byArray;
        this.mDash = new byte[n + 8 + this.hLen];
        this.trailer = by;
    }

    private void clearBlock(byte[] byArray) {
        for (int k = 0; k != byArray.length; ++k) {
            byArray[k] = 0;
        }
    }

    private void ItoOSP(int n, byte[] byArray) {
        byArray[0] = (byte)(n >>> 24);
        byArray[1] = (byte)(n >>> 16);
        byArray[2] = (byte)(n >>> 8);
        byArray[3] = (byte)(n >>> 0);
    }

    private byte[] maskGeneratorFunction1(byte[] byArray, int n, int n2, int n3) {
        int n4;
        int n5;
        PSSSigner pSSSigner = this;
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[pSSSigner.mgfhLen];
        int n6 = 4;
        byte[] byArray4 = new byte[4];
        pSSSigner.mgfDigest.reset();
        for (n5 = 0; n5 < n3 / (n4 = this.mgfhLen); ++n5) {
            PSSSigner pSSSigner2 = this;
            pSSSigner2.ItoOSP(n5, byArray4);
            pSSSigner2.mgfDigest.update(byArray, n, n2);
            pSSSigner2.mgfDigest.update(byArray4, 0, n6);
            pSSSigner2.mgfDigest.doFinal(byArray3, 0);
            n4 = pSSSigner2.mgfhLen;
            int n7 = n5 * n4;
            System.arraycopy(byArray3, 0, byArray2, n7, n4);
        }
        if (n5 * n4 < n3) {
            int n8 = n5;
            PSSSigner pSSSigner3 = this;
            pSSSigner3.ItoOSP(n5, byArray4);
            pSSSigner3.mgfDigest.update(byArray, n, n2);
            pSSSigner3.mgfDigest.update(byArray4, 0, n6);
            pSSSigner3.mgfDigest.doFinal(byArray3, 0);
            int n9 = pSSSigner3.mgfhLen;
            int n10 = n8 * n9;
            n9 = n3 - n8 * n9;
            System.arraycopy(byArray3, 0, byArray2, n10, n9);
        }
        return byArray2;
    }

    @Override
    public void init(boolean n, CipherParameters cipherParameters) {
        CipherParameters cipherParameters2;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            cipherParameters2 = parametersWithRandom.getParameters();
            this.random = parametersWithRandom.getRandom();
        } else {
            if (n) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
            cipherParameters2 = cipherParameters;
        }
        if (cipherParameters2 instanceof RSABlindingParameters) {
            cipherParameters2 = ((RSABlindingParameters)cipherParameters2).getPublicKey();
            this.cipher.init(n != 0, cipherParameters);
        } else {
            cipherParameters = (RSAKeyParameters)cipherParameters2;
            this.cipher.init(n != 0, cipherParameters2);
            cipherParameters2 = cipherParameters;
        }
        n = ((RSAKeyParameters)cipherParameters2).getModulus().bitLength() - 1;
        PSSSigner pSSSigner = this;
        pSSSigner.emBits = n;
        int n2 = pSSSigner.hLen * 8;
        if (n >= pSSSigner.sLen * 8 + n2 + 9) {
            this.block = new byte[(n + 7) / 8];
            this.reset();
            return;
        }
        throw new IllegalArgumentException("key too small for specified hash and salt lengths");
    }

    @Override
    public void update(byte by) {
        this.contentDigest.update(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.contentDigest.update(byArray, n, n2);
    }

    @Override
    public void reset() {
        this.contentDigest.reset();
    }

    @Override
    public byte[] generateSignature() {
        PSSSigner pSSSigner = this;
        pSSSigner.contentDigest.doFinal(this.mDash, this.mDash.length - this.hLen - this.sLen);
        if (pSSSigner.sLen != 0) {
            if (!this.sSet) {
                this.random.nextBytes(this.salt);
            }
            byte[] byArray = this.mDash;
            int n = this.sLen;
            int n2 = this.mDash.length - n;
            System.arraycopy(this.salt, 0, byArray, n2, n);
        }
        PSSSigner pSSSigner2 = this;
        int n = pSSSigner2.hLen;
        byte[] byArray = new byte[n];
        pSSSigner2.contentDigest.update(this.mDash, 0, this.mDash.length);
        pSSSigner2.contentDigest.doFinal(byArray, 0);
        byte[] byArray2 = pSSSigner2.block;
        PSSSigner pSSSigner3 = this;
        int n3 = this.sLen;
        int n4 = this.hLen;
        byArray2[byArray2.length - n3 - 1 - n4 - 1] = 1;
        n4 = byArray2.length - n3 - n4 - 1;
        System.arraycopy(pSSSigner3.salt, 0, byArray2, n4, n3);
        int n5 = pSSSigner3.block.length - this.hLen - 1;
        byte[] byArray3 = pSSSigner2.maskGeneratorFunction1(byArray, 0, n, n5);
        for (n5 = 0; n5 != byArray3.length; ++n5) {
            this.block[n5] = (byte)(this.block[n5] ^ byArray3[n5]);
        }
        PSSSigner pSSSigner4 = this;
        byArray3 = this.block;
        int n6 = this.hLen;
        n5 = this.block.length - n6 - 1;
        System.arraycopy(byArray, 0, byArray3, n5, n6);
        byte[] byArray4 = byArray3 = pSSSigner4.block;
        n6 = 255 >>> byArray4.length * 8 - this.emBits;
        byArray4[0] = (byte)(byArray3[0] & n6);
        n6 = byArray3.length - 1;
        pSSSigner4.block[n6] = this.trailer;
        byte[] byArray5 = pSSSigner4.cipher.processBlock(byArray3, 0, byArray3.length);
        PSSSigner pSSSigner5 = this;
        pSSSigner5.clearBlock(pSSSigner5.block);
        return byArray5;
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        byte[] byArray2;
        PSSSigner pSSSigner = this;
        pSSSigner.contentDigest.doFinal(this.mDash, this.mDash.length - this.hLen - this.sLen);
        AsymmetricBlockCipher asymmetricBlockCipher = pSSSigner.cipher;
        int n = 0;
        byte[] byArray3 = asymmetricBlockCipher.processBlock(byArray, n, byArray.length);
        PSSSigner pSSSigner2 = this;
        PSSSigner pSSSigner3 = pSSSigner2;
        byte[] byArray4 = pSSSigner2.block;
        int n2 = 0;
        int n3 = byArray4.length - byArray3.length;
        Arrays.fill(pSSSigner2.block, n2, n3, (byte)0);
        int n4 = 0;
        byte[] byArray5 = pSSSigner3.block;
        int n5 = pSSSigner3.block.length - byArray3.length;
        int n6 = byArray3.length;
        try {
            System.arraycopy(byArray3, n4, byArray5, n5, n6);
            byArray2 = pSSSigner.block;
        }
        catch (Exception exception) {
            return false;
        }
        n4 = 255 >>> byArray2.length * 8 - this.emBits;
        int n7 = pSSSigner.block[0];
        if ((n7 & 0xFF) == (n7 & n4) && byArray2[byArray2.length - 1] == this.trailer) {
            byte[] byArray6;
            byte[] byArray7;
            int n8 = this.hLen;
            n7 = byArray2.length - n8 - 1;
            n6 = byArray2.length - n8 - 1;
            byte[] byArray8 = this.maskGeneratorFunction1(byArray2, n7, n8, n6);
            for (n7 = 0; n7 != byArray8.length; ++n7) {
                this.block[n7] = (byte)(this.block[n7] ^ byArray8[n7]);
            }
            this.block[0] = (byte)(this.block[0] & n4);
            int n9 = 0;
            while (true) {
                byArray7 = this.block;
                n7 = this.hLen;
                n6 = this.sLen;
                if (n9 == this.block.length - n7 - n6 - 2) break;
                if (byArray7[n9] != 0) {
                    this.clearBlock(byArray7);
                    return false;
                }
                ++n9;
            }
            if (byArray7[byArray7.length - n7 - n6 - 2] != 1) {
                this.clearBlock(byArray7);
                return false;
            }
            if (this.sSet) {
                byte[] byArray9 = this.mDash;
                int n10 = this.mDash.length - n6;
                System.arraycopy(this.salt, 0, byArray9, n10, n6);
            } else {
                byte[] byArray10 = byArray7;
                n9 = byArray7.length - n6 - n7 - 1;
                byArray7 = this.mDash;
                System.arraycopy(byArray10, n9, byArray7, byArray7.length - n6, n6);
            }
            PSSSigner pSSSigner4 = this;
            pSSSigner4.contentDigest.update(this.mDash, 0, this.mDash.length);
            pSSSigner4.contentDigest.doFinal(this.mDash, this.mDash.length - this.hLen);
            int n11 = this.hLen;
            int n12 = pSSSigner4.block.length - n11 - 1;
            n11 = pSSSigner4.mDash.length - n11;
            while (true) {
                byArray6 = this.mDash;
                if (n11 == this.mDash.length) break;
                if ((this.block[n12] ^ byArray6[n11]) != 0) {
                    PSSSigner pSSSigner5 = this;
                    pSSSigner5.clearBlock(byArray6);
                    pSSSigner5.clearBlock(pSSSigner5.block);
                    return false;
                }
                ++n12;
                ++n11;
            }
            PSSSigner pSSSigner6 = this;
            pSSSigner6.clearBlock(byArray6);
            pSSSigner6.clearBlock(pSSSigner6.block);
            return true;
        }
        this.clearBlock(byArray2);
        return false;
    }
}

