/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Null;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.GCMParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.misc.CAST5CBCParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RC2CBCParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.AESEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.CAST5Engine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.DESEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.DESedeEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.RC2Engine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.RC4Engine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.io.CipherOutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.AEADBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CBCBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.GCMBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.BlockCipherPadding;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.PKCS7Padding;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AEADParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RC2Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.AlgorithmIdentifierFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.a;
import java.io.OutputStream;

public class CipherFactory {
    private static final short[] rc2Ekb = new short[]{93, 190, 155, 139, 17, 153, 110, 77, 89, 243, 133, 166, 63, 183, 131, 197, 228, 115, 107, 58, 104, 90, 192, 71, 160, 100, 52, 12, 241, 208, 82, 165, 185, 30, 150, 67, 65, 216, 212, 44, 219, 248, 7, 119, 42, 202, 235, 239, 16, 28, 22, 13, 56, 114, 47, 137, 193, 249, 128, 196, 109, 174, 48, 61, 206, 32, 99, 254, 230, 26, 199, 184, 80, 232, 36, 23, 252, 37, 111, 187, 106, 163, 68, 83, 217, 162, 1, 171, 188, 182, 31, 152, 238, 154, 167, 45, 79, 158, 142, 172, 224, 198, 73, 70, 41, 244, 148, 138, 175, 225, 91, 195, 179, 123, 87, 209, 124, 156, 237, 135, 64, 140, 226, 203, 147, 20, 201, 97, 46, 229, 204, 246, 94, 168, 92, 214, 117, 141, 98, 149, 88, 105, 118, 161, 74, 181, 85, 9, 120, 51, 130, 215, 221, 121, 245, 27, 11, 222, 38, 33, 40, 116, 4, 151, 86, 223, 60, 240, 55, 57, 220, 255, 6, 164, 234, 66, 8, 218, 180, 113, 176, 207, 18, 122, 78, 250, 108, 29, 132, 0, 200, 127, 145, 69, 170, 43, 194, 177, 143, 213, 186, 242, 173, 25, 178, 103, 54, 247, 15, 10, 146, 125, 227, 157, 233, 144, 62, 35, 39, 102, 19, 236, 129, 21, 189, 34, 191, 159, 126, 169, 81, 75, 76, 251, 2, 211, 112, 134, 49, 231, 59, 5, 3, 84, 96, 72, 101, 24, 210, 205, 95, 50, 136, 14, 53, 253};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object createContentCipher(boolean bl, CipherParameters cipherParameters, AlgorithmIdentifier object) {
        AEADParameters aEADParameters;
        Object object2 = ((AlgorithmIdentifier)object).getAlgorithm();
        if (((ASN1Primitive)object2).equals(PKCSObjectIdentifiers.rc4)) {
            RC4Engine rC4Engine = new RC4Engine();
            rC4Engine.init(bl, cipherParameters);
            return rC4Engine;
        }
        if (!(((ASN1Primitive)object2).equals(NISTObjectIdentifiers.id_aes128_GCM) || ((ASN1Primitive)object2).equals(NISTObjectIdentifiers.id_aes192_GCM) || ((ASN1Primitive)object2).equals(NISTObjectIdentifiers.id_aes256_GCM))) {
            Object object3 = object;
            object = CipherFactory.createCipher(((AlgorithmIdentifier)object3).getAlgorithm());
            Object object4 = ((AlgorithmIdentifier)object3).getParameters().toASN1Primitive();
            if (object4 != null && !(object4 instanceof ASN1Null)) {
                if (!(((ASN1Primitive)object2).equals(PKCSObjectIdentifiers.des_EDE3_CBC) || ((ASN1Primitive)object2).equals(AlgorithmIdentifierFactory.IDEA_CBC) || ((ASN1Primitive)object2).equals(NISTObjectIdentifiers.id_aes128_CBC) || ((ASN1Primitive)object2).equals(NISTObjectIdentifiers.id_aes192_CBC) || ((ASN1Primitive)object2).equals(NISTObjectIdentifiers.id_aes256_CBC) || ((ASN1Primitive)object2).equals(NTTObjectIdentifiers.id_camellia128_cbc) || ((ASN1Primitive)object2).equals(NTTObjectIdentifiers.id_camellia192_cbc) || ((ASN1Primitive)object2).equals(NTTObjectIdentifiers.id_camellia256_cbc) || ((ASN1Primitive)object2).equals(KISAObjectIdentifiers.id_seedCBC) || ((ASN1Primitive)object2).equals(OIWObjectIdentifiers.desCBC))) {
                    if (((ASN1Primitive)object2).equals(AlgorithmIdentifierFactory.CAST5_CBC)) {
                        ParametersWithIV parametersWithIV;
                        object2 = CAST5CBCParameters.getInstance(object4);
                        object4 = parametersWithIV;
                        parametersWithIV = new ParametersWithIV(cipherParameters, ((CAST5CBCParameters)object2).getIV());
                        ((BufferedBlockCipher)object).init(bl, (CipherParameters)object4);
                        return object;
                    } else {
                        RC2Parameters rC2Parameters;
                        if (!((ASN1Primitive)object2).equals(PKCSObjectIdentifiers.RC2_CBC)) throw new IllegalArgumentException("cannot match parameters");
                        RC2CBCParameter rC2CBCParameter = RC2CBCParameter.getInstance(object4);
                        object2 = rC2Parameters;
                        rC2Parameters = new RC2Parameters(((KeyParameter)cipherParameters).getKey(), rc2Ekb[rC2CBCParameter.getRC2ParameterVersion().intValue()]);
                        ((BufferedBlockCipher)object).init(bl, new ParametersWithIV((CipherParameters)object2, rC2CBCParameter.getIV()));
                    }
                    return object;
                } else {
                    ((BufferedBlockCipher)object).init(bl, new ParametersWithIV(cipherParameters, ASN1OctetString.getInstance(object4).getOctets()));
                }
                return object;
            } else if (!(((ASN1Primitive)object2).equals(PKCSObjectIdentifiers.des_EDE3_CBC) || ((ASN1Primitive)object2).equals(AlgorithmIdentifierFactory.IDEA_CBC) || ((ASN1Primitive)object2).equals(AlgorithmIdentifierFactory.CAST5_CBC))) {
                ((BufferedBlockCipher)object).init(bl, cipherParameters);
                return object;
            } else {
                ParametersWithIV parametersWithIV;
                object2 = parametersWithIV;
                parametersWithIV = new ParametersWithIV(cipherParameters, new byte[8]);
                ((BufferedBlockCipher)object).init(bl, (CipherParameters)object2);
            }
            return object;
        }
        Object object5 = object;
        object = CipherFactory.createAEADCipher(((AlgorithmIdentifier)object5).getAlgorithm());
        object2 = GCMParameters.getInstance(((AlgorithmIdentifier)object5).getParameters());
        if (!(cipherParameters instanceof KeyParameter)) throw new IllegalArgumentException("key data must be accessible for GCM operation");
        Object object6 = object;
        AEADParameters aEADParameters2 = aEADParameters;
        ASN1Object aSN1Object = object2;
        cipherParameters = (KeyParameter)cipherParameters;
        int n = ((GCMParameters)aSN1Object).getIcvLen() * 8;
        object2 = ((GCMParameters)aSN1Object).getNonce();
        aEADParameters = new AEADParameters((KeyParameter)cipherParameters, n, (byte[])object2);
        object6.init(bl, aEADParameters2);
        return object6;
    }

    private static AEADBlockCipher createAEADCipher(ASN1ObjectIdentifier object) {
        AESEngine aESEngine;
        if (!(NISTObjectIdentifiers.id_aes128_GCM.equals((ASN1Primitive)object) || NISTObjectIdentifiers.id_aes192_GCM.equals((ASN1Primitive)object) || NISTObjectIdentifiers.id_aes256_GCM.equals((ASN1Primitive)object))) {
            throw new IllegalArgumentException(a.a("cannot recognise cipher: ", (ASN1ObjectIdentifier)object));
        }
        object = aESEngine;
        aESEngine = new AESEngine();
        return new GCMBlockCipher((BlockCipher)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static BufferedBlockCipher createCipher(ASN1ObjectIdentifier object) {
        PKCS7Padding pKCS7Padding;
        Object object2;
        if (!(NISTObjectIdentifiers.id_aes128_CBC.equals((ASN1Primitive)object) || NISTObjectIdentifiers.id_aes192_CBC.equals((ASN1Primitive)object) || NISTObjectIdentifiers.id_aes256_CBC.equals((ASN1Primitive)object))) {
            if (PKCSObjectIdentifiers.des_EDE3_CBC.equals((ASN1Primitive)object)) {
                DESedeEngine dESedeEngine;
                CBCBlockCipher cBCBlockCipher;
                object = cBCBlockCipher;
                object2 = dESedeEngine;
                dESedeEngine = new DESedeEngine();
                cBCBlockCipher = new CBCBlockCipher((BlockCipher)object2);
            } else if (OIWObjectIdentifiers.desCBC.equals((ASN1Primitive)object)) {
                DESEngine dESEngine;
                CBCBlockCipher cBCBlockCipher;
                object = cBCBlockCipher;
                object2 = dESEngine;
                dESEngine = new DESEngine();
                cBCBlockCipher = new CBCBlockCipher((BlockCipher)object2);
            } else if (PKCSObjectIdentifiers.RC2_CBC.equals((ASN1Primitive)object)) {
                RC2Engine rC2Engine;
                CBCBlockCipher cBCBlockCipher;
                object = cBCBlockCipher;
                object2 = rC2Engine;
                rC2Engine = new RC2Engine();
                cBCBlockCipher = new CBCBlockCipher((BlockCipher)object2);
            } else {
                CAST5Engine cAST5Engine;
                CBCBlockCipher cBCBlockCipher;
                if (!MiscObjectIdentifiers.cast5CBC.equals((ASN1Primitive)object)) throw new IllegalArgumentException(a.a("cannot recognise cipher: ", (ASN1ObjectIdentifier)object));
                object = cBCBlockCipher;
                object2 = cAST5Engine;
                cAST5Engine = new CAST5Engine();
                cBCBlockCipher = new CBCBlockCipher((BlockCipher)object2);
            }
        } else {
            AESEngine aESEngine;
            CBCBlockCipher cBCBlockCipher;
            object = cBCBlockCipher;
            object2 = aESEngine;
            aESEngine = new AESEngine();
            cBCBlockCipher = new CBCBlockCipher((BlockCipher)object2);
        }
        object2 = pKCS7Padding;
        pKCS7Padding = new PKCS7Padding();
        return new PaddedBufferedBlockCipher((BlockCipher)object, (BlockCipherPadding)object2);
    }

    public static CipherOutputStream createOutputStream(OutputStream outputStream, Object object) {
        if (object instanceof BufferedBlockCipher) {
            return new CipherOutputStream(outputStream, (BufferedBlockCipher)object);
        }
        if (object instanceof StreamCipher) {
            return new CipherOutputStream(outputStream, (StreamCipher)object);
        }
        if (object instanceof AEADBlockCipher) {
            return new CipherOutputStream(outputStream, (AEADBlockCipher)object);
        }
        throw new IllegalArgumentException("unknown cipher object: " + object);
    }
}

