/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.internal.asn1.cms;

import c.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class CCMParameters
extends ASN1Object {
    private byte[] nonce;
    private int icvLen;

    public static CCMParameters getInstance(Object object) {
        if (object instanceof CCMParameters) {
            return (CCMParameters)object;
        }
        if (object != null) {
            return new CCMParameters(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private CCMParameters(ASN1Sequence aSN1Sequence) {
        this.nonce = a.a(aSN1Sequence, 0);
        this.icvLen = aSN1Sequence.size() == 2 ? ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1)).intValueExact() : 12;
    }

    public CCMParameters(byte[] byArray, int n) {
        this.nonce = Arrays.clone(byArray);
        this.icvLen = n;
    }

    public byte[] getNonce() {
        return Arrays.clone(this.nonce);
    }

    public int getIcvLen() {
        return this.icvLen;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        new ASN1EncodableVector(2).add(new DEROctetString(this.nonce));
        int n = this.icvLen;
        if (n != 12) {
            aSN1EncodableVector2.add(new ASN1Integer(n));
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

