/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.PBKDF2Config;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.PBKDFConfig;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.BCLoadStoreParameter;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

public class BCFKSLoadStoreParameter
extends BCLoadStoreParameter {
    private final PBKDFConfig storeConfig;
    private final EncryptionAlgorithm encAlg;
    private final MacAlgorithm macAlg;
    private final SignatureAlgorithm sigAlg;
    private final Key sigKey;
    private final X509Certificate[] certificates;
    private final CertChainValidator validator;

    private BCFKSLoadStoreParameter(Builder object) {
        BCFKSLoadStoreParameter bCFKSLoadStoreParameter = inputStream;
        Builder builder = object;
        BCFKSLoadStoreParameter bCFKSLoadStoreParameter2 = inputStream;
        Builder builder2 = object;
        BCFKSLoadStoreParameter bCFKSLoadStoreParameter3 = inputStream;
        Builder builder3 = object;
        BCFKSLoadStoreParameter bCFKSLoadStoreParameter4 = inputStream;
        Builder builder4 = object;
        BCFKSLoadStoreParameter bCFKSLoadStoreParameter5 = inputStream;
        Builder builder5 = object;
        BCFKSLoadStoreParameter bCFKSLoadStoreParameter6 = inputStream;
        Builder builder6 = object;
        BCFKSLoadStoreParameter bCFKSLoadStoreParameter7 = inputStream;
        Builder builder7 = object;
        BCFKSLoadStoreParameter bCFKSLoadStoreParameter8 = inputStream;
        Builder builder8 = object;
        InputStream inputStream = builder8.in;
        object = builder8.out;
        KeyStore.ProtectionParameter protectionParameter = builder8.protectionParameter;
        super(inputStream, (OutputStream)object, protectionParameter);
        bCFKSLoadStoreParameter7.storeConfig = builder7.storeConfig;
        bCFKSLoadStoreParameter6.encAlg = builder6.encAlg;
        bCFKSLoadStoreParameter5.macAlg = builder5.macAlg;
        bCFKSLoadStoreParameter4.sigAlg = builder4.sigAlg;
        bCFKSLoadStoreParameter3.sigKey = builder3.sigKey;
        bCFKSLoadStoreParameter2.certificates = builder2.certs;
        bCFKSLoadStoreParameter.validator = builder.validator;
    }

    public /* synthetic */ BCFKSLoadStoreParameter(Builder builder, 1 var2_2) {
        this(builder);
    }

    public PBKDFConfig getStorePBKDFConfig() {
        return this.storeConfig;
    }

    public EncryptionAlgorithm getStoreEncryptionAlgorithm() {
        return this.encAlg;
    }

    public MacAlgorithm getStoreMacAlgorithm() {
        return this.macAlg;
    }

    public SignatureAlgorithm getStoreSignatureAlgorithm() {
        return this.sigAlg;
    }

    public Key getStoreSignatureKey() {
        return this.sigKey;
    }

    public X509Certificate[] getStoreCertificates() {
        return this.certificates;
    }

    public CertChainValidator getCertChainValidator() {
        return this.validator;
    }

    public static class Builder {
        private final OutputStream out;
        private final InputStream in;
        private final KeyStore.ProtectionParameter protectionParameter;
        private final Key sigKey;
        private PBKDFConfig storeConfig;
        private EncryptionAlgorithm encAlg;
        private MacAlgorithm macAlg;
        private SignatureAlgorithm sigAlg;
        private X509Certificate[] certs;
        private CertChainValidator validator;

        public Builder() {
            this((OutputStream)null, (KeyStore.ProtectionParameter)null);
        }

        public Builder(OutputStream outputStream, char[] cArray) {
            KeyStore.PasswordProtection passwordProtection;
            Builder builder = passwordProtection2;
            KeyStore.PasswordProtection passwordProtection2 = passwordProtection;
            passwordProtection = new KeyStore.PasswordProtection(cArray);
            builder(outputStream, (KeyStore.ProtectionParameter)passwordProtection2);
        }

        public Builder(OutputStream outputStream, KeyStore.ProtectionParameter protectionParameter) {
            Builder builder = this;
            this.storeConfig = new PBKDF2Config.Builder().withIterationCount(16384).withSaltLength(64).withPRF(PBKDF2Config.PRF_SHA512).build();
            this.encAlg = EncryptionAlgorithm.AES256_CCM;
            this.macAlg = MacAlgorithm.HmacSHA512;
            this.sigAlg = SignatureAlgorithm.SHA512withECDSA;
            this.certs = null;
            this.in = null;
            this.out = outputStream;
            builder.protectionParameter = protectionParameter;
            builder.sigKey = null;
        }

        public Builder(OutputStream outputStream, PrivateKey privateKey) {
            Builder builder = this;
            this.storeConfig = new PBKDF2Config.Builder().withIterationCount(16384).withSaltLength(64).withPRF(PBKDF2Config.PRF_SHA512).build();
            this.encAlg = EncryptionAlgorithm.AES256_CCM;
            this.macAlg = MacAlgorithm.HmacSHA512;
            this.sigAlg = SignatureAlgorithm.SHA512withECDSA;
            this.certs = null;
            this.in = null;
            builder.out = outputStream;
            builder.protectionParameter = null;
            this.sigKey = privateKey;
        }

        public Builder(InputStream inputStream, PublicKey publicKey) {
            Builder builder = this;
            this.storeConfig = new PBKDF2Config.Builder().withIterationCount(16384).withSaltLength(64).withPRF(PBKDF2Config.PRF_SHA512).build();
            this.encAlg = EncryptionAlgorithm.AES256_CCM;
            this.macAlg = MacAlgorithm.HmacSHA512;
            this.sigAlg = SignatureAlgorithm.SHA512withECDSA;
            this.certs = null;
            builder.in = inputStream;
            builder.out = null;
            builder.protectionParameter = null;
            this.sigKey = publicKey;
        }

        public Builder(InputStream inputStream, CertChainValidator certChainValidator) {
            Builder builder = this;
            Builder builder2 = this;
            this.storeConfig = new PBKDF2Config.Builder().withIterationCount(16384).withSaltLength(64).withPRF(PBKDF2Config.PRF_SHA512).build();
            this.encAlg = EncryptionAlgorithm.AES256_CCM;
            this.macAlg = MacAlgorithm.HmacSHA512;
            this.sigAlg = SignatureAlgorithm.SHA512withECDSA;
            this.certs = null;
            builder2.in = inputStream;
            builder2.out = null;
            builder2.protectionParameter = null;
            builder.validator = certChainValidator;
            builder.sigKey = null;
        }

        public Builder(InputStream inputStream, char[] cArray) {
            KeyStore.PasswordProtection passwordProtection;
            Builder builder = passwordProtection2;
            KeyStore.PasswordProtection passwordProtection2 = passwordProtection;
            passwordProtection = new KeyStore.PasswordProtection(cArray);
            builder(inputStream, (KeyStore.ProtectionParameter)passwordProtection2);
        }

        public Builder(InputStream inputStream, KeyStore.ProtectionParameter protectionParameter) {
            Builder builder = this;
            Builder builder2 = this;
            this.storeConfig = new PBKDF2Config.Builder().withIterationCount(16384).withSaltLength(64).withPRF(PBKDF2Config.PRF_SHA512).build();
            this.encAlg = EncryptionAlgorithm.AES256_CCM;
            this.macAlg = MacAlgorithm.HmacSHA512;
            this.sigAlg = SignatureAlgorithm.SHA512withECDSA;
            this.certs = null;
            builder2.in = inputStream;
            builder2.out = null;
            builder.protectionParameter = protectionParameter;
            builder.sigKey = null;
        }

        public Builder withStorePBKDFConfig(PBKDFConfig pBKDFConfig) {
            this.storeConfig = pBKDFConfig;
            return this;
        }

        public Builder withStoreEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
            this.encAlg = encryptionAlgorithm;
            return this;
        }

        public Builder withStoreMacAlgorithm(MacAlgorithm macAlgorithm) {
            this.macAlg = macAlgorithm;
            return this;
        }

        public Builder withCertificates(X509Certificate[] x509CertificateArray) {
            int n = x509CertificateArray.length;
            x509CertificateArray = new X509Certificate[n];
            System.arraycopy(x509CertificateArray, 0, x509CertificateArray, 0, n);
            this.certs = x509CertificateArray;
            return this;
        }

        public Builder withStoreSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
            this.sigAlg = signatureAlgorithm;
            return this;
        }

        public BCFKSLoadStoreParameter build() {
            return new BCFKSLoadStoreParameter(this, null);
        }
    }

    public static interface CertChainValidator {
        public boolean isValid(X509Certificate[] var1);
    }

    public static final class SignatureAlgorithm
    extends Enum<SignatureAlgorithm> {
        public static final /* enum */ SignatureAlgorithm SHA512withDSA;
        public static final /* enum */ SignatureAlgorithm SHA3_512withDSA;
        public static final /* enum */ SignatureAlgorithm SHA512withECDSA;
        public static final /* enum */ SignatureAlgorithm SHA3_512withECDSA;
        public static final /* enum */ SignatureAlgorithm SHA512withRSA;
        public static final /* enum */ SignatureAlgorithm SHA3_512withRSA;
        private static final /* synthetic */ SignatureAlgorithm[] $VALUES;

        public static SignatureAlgorithm[] values() {
            return (SignatureAlgorithm[])$VALUES.clone();
        }

        public static SignatureAlgorithm valueOf(String string) {
            return Enum.valueOf(SignatureAlgorithm.class, string);
        }

        static {
            SignatureAlgorithm signatureAlgorithm;
            SignatureAlgorithm signatureAlgorithm2;
            SignatureAlgorithm signatureAlgorithm3;
            SignatureAlgorithm signatureAlgorithm4;
            SignatureAlgorithm signatureAlgorithm5;
            SignatureAlgorithm signatureAlgorithm6;
            SignatureAlgorithm signatureAlgorithm7 = signatureAlgorithm6;
            SHA512withDSA = new SignatureAlgorithm();
            SignatureAlgorithm signatureAlgorithm8 = signatureAlgorithm5;
            SHA3_512withDSA = new SignatureAlgorithm();
            SignatureAlgorithm signatureAlgorithm9 = signatureAlgorithm4;
            SHA512withECDSA = new SignatureAlgorithm();
            SignatureAlgorithm signatureAlgorithm10 = signatureAlgorithm3;
            SHA3_512withECDSA = new SignatureAlgorithm();
            SignatureAlgorithm signatureAlgorithm11 = signatureAlgorithm2;
            SHA512withRSA = new SignatureAlgorithm();
            SignatureAlgorithm signatureAlgorithm12 = signatureAlgorithm;
            SHA3_512withRSA = new SignatureAlgorithm();
            $VALUES = new SignatureAlgorithm[]{signatureAlgorithm7, signatureAlgorithm8, signatureAlgorithm9, signatureAlgorithm10, signatureAlgorithm11, signatureAlgorithm12};
        }
    }

    public static final class MacAlgorithm
    extends Enum<MacAlgorithm> {
        public static final /* enum */ MacAlgorithm HmacSHA512;
        public static final /* enum */ MacAlgorithm HmacSHA3_512;
        private static final /* synthetic */ MacAlgorithm[] $VALUES;

        public static MacAlgorithm[] values() {
            return (MacAlgorithm[])$VALUES.clone();
        }

        public static MacAlgorithm valueOf(String string) {
            return Enum.valueOf(MacAlgorithm.class, string);
        }

        static {
            MacAlgorithm macAlgorithm;
            MacAlgorithm macAlgorithm2;
            MacAlgorithm macAlgorithm3 = macAlgorithm2;
            HmacSHA512 = new MacAlgorithm();
            MacAlgorithm macAlgorithm4 = macAlgorithm;
            HmacSHA3_512 = new MacAlgorithm();
            $VALUES = new MacAlgorithm[]{macAlgorithm3, macAlgorithm4};
        }
    }

    public static final class EncryptionAlgorithm
    extends Enum<EncryptionAlgorithm> {
        public static final /* enum */ EncryptionAlgorithm AES256_CCM;
        public static final /* enum */ EncryptionAlgorithm AES256_KWP;
        private static final /* synthetic */ EncryptionAlgorithm[] $VALUES;

        public static EncryptionAlgorithm[] values() {
            return (EncryptionAlgorithm[])$VALUES.clone();
        }

        public static EncryptionAlgorithm valueOf(String string) {
            return Enum.valueOf(EncryptionAlgorithm.class, string);
        }

        static {
            EncryptionAlgorithm encryptionAlgorithm;
            EncryptionAlgorithm encryptionAlgorithm2;
            EncryptionAlgorithm encryptionAlgorithm3 = encryptionAlgorithm2;
            AES256_CCM = new EncryptionAlgorithm();
            EncryptionAlgorithm encryptionAlgorithm4 = encryptionAlgorithm;
            AES256_KWP = new EncryptionAlgorithm();
            $VALUES = new EncryptionAlgorithm[]{encryptionAlgorithm3, encryptionAlgorithm4};
        }
    }
}

