/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompositePublicKey
implements PublicKey {
    private final List<PublicKey> keys;

    public CompositePublicKey(PublicKey ... publicKeyArray) {
        if (publicKeyArray != null && publicKeyArray.length != 0) {
            ArrayList<PublicKey> arrayList;
            ArrayList<PublicKey> arrayList2 = arrayList;
            arrayList = new ArrayList<PublicKey>(publicKeyArray.length);
            for (int k = 0; k != publicKeyArray.length; ++k) {
                arrayList2.add(publicKeyArray[k]);
            }
            this.keys = Collections.unmodifiableList(arrayList2);
            return;
        }
        throw new IllegalArgumentException("at least one public key must be provided");
    }

    public List<PublicKey> getPublicKeys() {
        return this.keys;
    }

    @Override
    public String getAlgorithm() {
        return "Composite";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        DERSequence dERSequence;
        AlgorithmIdentifier algorithmIdentifier;
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        SubjectPublicKeyInfo subjectPublicKeyInfo2;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector();
        for (int k = 0; k != ((CompositePublicKey)((Object)dERSequence2)).keys.size(); ++k) {
            aSN1EncodableVector2.add(SubjectPublicKeyInfo.getInstance(((CompositePublicKey)((Object)dERSequence2)).keys.get(k).getEncoded()));
        }
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo3;
            subjectPublicKeyInfo2 = subjectPublicKeyInfo3;
            subjectPublicKeyInfo = subjectPublicKeyInfo3;
            algorithmIdentifier = new AlgorithmIdentifier(MiscObjectIdentifiers.id_alg_composite);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(b.a(iOException, b.b.a("unable to encode composite key: ")));
        }
        DERSequence dERSequence2 = dERSequence;
        dERSequence = new DERSequence(aSN1EncodableVector2);
        subjectPublicKeyInfo2(algorithmIdentifier, dERSequence2);
        return subjectPublicKeyInfo.getEncoded("DER");
    }

    public int hashCode() {
        return this.keys.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CompositePublicKey) {
            return this.keys.equals(((CompositePublicKey)object).keys);
        }
        return false;
    }
}

