/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.io;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.io.InvalidCipherTextIOException;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;

public class CipherInputStream
extends FilterInputStream {
    private final Cipher cipher;
    private final byte[] inputBuffer = new byte[512];
    private boolean finalized = false;
    private byte[] buf;
    private int maxBuf;
    private int bufOff;

    public CipherInputStream(InputStream inputStream, Cipher cipher) {
        super(inputStream);
        this.cipher = cipher;
    }

    private int nextChunk() {
        int n;
        if (this.finalized) {
            return -1;
        }
        CipherInputStream cipherInputStream = this;
        cipherInputStream.bufOff = 0;
        cipherInputStream.maxBuf = 0;
        while ((n = this.maxBuf) == 0) {
            n = this.in.read(this.inputBuffer);
            if (n == -1) {
                byte[] byArray = this.finaliseCipher();
                this.buf = byArray;
                if (byArray != null && byArray.length != 0) {
                    this.maxBuf = byArray.length;
                    return this.maxBuf;
                }
                return -1;
            }
            byte[] byArray = this.cipher.update(this.inputBuffer, 0, n);
            this.buf = byArray;
            if (byArray == null) continue;
            this.maxBuf = byArray.length;
        }
        return n;
    }

    private byte[] finaliseCipher() {
        block3: {
            try {
                if (this.finalized) break block3;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new InvalidCipherTextIOException("Error finalising cipher", generalSecurityException);
            }
            this.finalized = true;
            return this.cipher.doFinal();
        }
        return null;
    }

    @Override
    public int read() {
        if (this.bufOff >= this.maxBuf && this.nextChunk() < 0) {
            return -1;
        }
        int n = this.bufOff;
        this.bufOff = n + 1;
        return this.buf[n] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        if (this.bufOff >= this.maxBuf && this.nextChunk() < 0) {
            return -1;
        }
        n2 = Math.min(n2, this.available());
        CipherInputStream cipherInputStream = this;
        System.arraycopy(cipherInputStream.buf, this.bufOff, byArray, n, n2);
        cipherInputStream.bufOff += n2;
        return n2;
    }

    @Override
    public long skip(long l) {
        if (l <= 0L) {
            return 0L;
        }
        int n = (int)Math.min(l, (long)this.available());
        this.bufOff += n;
        return n;
    }

    @Override
    public int available() {
        return this.maxBuf - this.bufOff;
    }

    @Override
    public void close() {
        block3: {
            try {
                CipherInputStream cipherInputStream = this;
                cipherInputStream.in.close();
                if (cipherInputStream.finalized) break block3;
                this.finaliseCipher();
            }
            catch (Throwable throwable) {
                if (!this.finalized) {
                    this.finaliseCipher();
                }
                throw throwable;
            }
        }
        CipherInputStream cipherInputStream = this;
        cipherInputStream.bufOff = 0;
        cipherInputStream.maxBuf = 0;
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

