/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dh;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyEncoder;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.DHBasicAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.AESEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.DESedeEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.IESEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.DHKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.EphemeralKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.KDF2BytesGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs.HMac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CBCBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.IESWithCipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.parsers.DHIESPublicKeyParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.DHUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.IESUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util.BadBlockException;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.JcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.IESKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.IESParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.CipherSpi;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.interfaces.DHKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;

public class IESCipher
extends CipherSpi {
    private final JcaJceHelper helper;
    private final int ivLength;
    private IESEngine engine;
    private int state;
    private ByteArrayOutputStream buffer;
    private AlgorithmParameters engineParam;
    private IESParameterSpec engineSpec;
    private AsymmetricKeyParameter key;
    private SecureRandom random;
    private boolean dhaesMode;
    private AsymmetricKeyParameter otherKeyParameter;

    public IESCipher(IESEngine iESEngine) {
        ByteArrayOutputStream byteArrayOutputStream;
        BCJcaJceHelper bCJcaJceHelper;
        Object object = bCJcaJceHelper;
        bCJcaJceHelper = new BCJcaJceHelper();
        v1.helper = object;
        v1.state = -1;
        object = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        v1.buffer = object;
        v1.engineParam = null;
        v1.engineSpec = null;
        v1.dhaesMode = false;
        v1.otherKeyParameter = null;
        v1.engine = iESEngine;
        v1.ivLength = 0;
    }

    public IESCipher(IESEngine iESEngine, int n) {
        ByteArrayOutputStream byteArrayOutputStream;
        BCJcaJceHelper bCJcaJceHelper;
        Object object = bCJcaJceHelper;
        bCJcaJceHelper = new BCJcaJceHelper();
        v1.helper = object;
        v1.state = -1;
        object = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        v1.buffer = object;
        v1.engineParam = null;
        v1.engineSpec = null;
        v1.dhaesMode = false;
        v1.otherKeyParameter = null;
        v1.engine = iESEngine;
        v1.ivLength = n;
    }

    @Override
    public int engineGetBlockSize() {
        if (this.engine.getCipher() != null) {
            return this.engine.getCipher().getBlockSize();
        }
        return 0;
    }

    @Override
    public int engineGetKeySize(Key key) {
        if (key instanceof DHKey) {
            return ((DHKey)((Object)key)).getParams().getP().bitLength();
        }
        throw new IllegalArgumentException("not a DH key");
    }

    @Override
    public byte[] engineGetIV() {
        IESParameterSpec iESParameterSpec = ((IESCipher)((Object)iESParameterSpec)).engineSpec;
        if (iESParameterSpec != null) {
            return iESParameterSpec.getNonce();
        }
        return null;
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        if (this.engineParam == null && this.engineSpec != null) {
            AlgorithmParameters algorithmParameters;
            try {
                algorithmParameters = this.helper.createAlgorithmParameters("IES");
            }
            catch (Exception exception) {
                throw new RuntimeException(((Object)exception).toString());
            }
            this.engineParam = algorithmParameters;
            algorithmParameters.init(this.engineSpec);
        }
        return this.engineParam;
    }

    @Override
    public void engineSetMode(String string) {
        block4: {
            block3: {
                String string2;
                block2: {
                    string2 = Strings.toUpperCase(string);
                    if (!string2.equals("NONE")) break block2;
                    this.dhaesMode = false;
                    break block3;
                }
                if (!string2.equals("DHAES")) break block4;
                this.dhaesMode = true;
            }
            return;
        }
        throw new IllegalArgumentException(i.a("can't support mode ", string));
    }

    @Override
    public int engineGetOutputSize(int n) {
        if (this.key != null) {
            int n2;
            IESCipher iESCipher = this;
            int n3 = iESCipher.engine.getMac().getMacSize();
            int n4 = iESCipher.otherKeyParameter == null ? (((DHKeyParameters)this.key).getParameters().getP().bitLength() + 7) * 2 / 8 + 1 : 0;
            if (this.engine.getCipher() != null) {
                n2 = this.state;
                if (n2 != 1 && n2 != 3) {
                    if (n2 != 2 && n2 != 4) {
                        throw new IllegalStateException("cipher not initialised");
                    }
                    n = this.engine.getCipher().getOutputSize(n - n3 - n4);
                } else {
                    n = this.engine.getCipher().getOutputSize(n);
                }
            }
            if ((n2 = this.state) != 1 && n2 != 3) {
                if (n2 != 2 && n2 != 4) {
                    throw new IllegalStateException("IESCipher not initialised");
                }
                return this.buffer.size() - n3 - n4 + n;
            }
            return this.buffer.size() + n3 + n4 + n;
        }
        throw new IllegalStateException("cipher not initialised");
    }

    @Override
    public void engineSetPadding(String string) {
        String string2 = Strings.toUpperCase(string);
        if (!(string2.equals("NOPADDING") || string2.equals("PKCS5PADDING") || string2.equals("PKCS7PADDING"))) {
            throw new NoSuchPaddingException("padding not available with IESCipher");
        }
    }

    @Override
    public void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) {
        IESParameterSpec iESParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                iESParameterSpec = algorithmParameters.getParameterSpec(IESParameterSpec.class);
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException(d.a(exception, b.b.a("cannot recognise parameters: ")));
            }
        }
        this.engineParam = algorithmParameters;
        this.engineInit(n, key, iESParameterSpec, secureRandom);
    }

    @Override
    public void engineInit(int n, Key key, AlgorithmParameterSpec object, SecureRandom secureRandom) {
        block8: {
            block14: {
                block11: {
                    block13: {
                        block9: {
                            block12: {
                                block10: {
                                    int n2;
                                    block7: {
                                        block6: {
                                            if (object != null) break block6;
                                            object = null;
                                            n2 = this.ivLength;
                                            if (n2 != 0 && n == 1) {
                                                byte[] byArray = new byte[n2];
                                                object = byArray;
                                                secureRandom.nextBytes(byArray);
                                            }
                                            this.engineSpec = IESUtil.guessParameterSpec(this.engine.getCipher(), (byte[])object);
                                            break block7;
                                        }
                                        if (!(object instanceof IESParameterSpec)) break block8;
                                        this.engineSpec = (IESParameterSpec)object;
                                    }
                                    IESCipher iESCipher = this;
                                    object = iESCipher.engineSpec.getNonce();
                                    n2 = iESCipher.ivLength;
                                    if (n2 != 0 && (object == null || ((Object)object).length != n2)) {
                                        throw new InvalidAlgorithmParameterException(b.a(b.b.a("NONCE in IES Parameters needs to be "), this.ivLength, " bytes long"));
                                    }
                                    if (n == 1 || n == 3) break block9;
                                    if (n != 2 && n != 4) {
                                        throw new InvalidKeyException("must be passed EC key");
                                    }
                                    if (!(key instanceof DHPrivateKey)) break block10;
                                    this.key = DHUtil.generatePrivateKeyParameter((PrivateKey)key);
                                    break block11;
                                }
                                if (!(key instanceof IESKey)) break block12;
                                IESCipher iESCipher = this;
                                key = (IESKey)key;
                                iESCipher.otherKeyParameter = DHUtil.generatePublicKeyParameter(key.getPublic());
                                iESCipher.key = DHUtil.generatePrivateKeyParameter(key.getPrivate());
                                break block11;
                            }
                            throw new InvalidKeyException("must be passed recipient's private DH key for decryption");
                        }
                        if (!(key instanceof DHPublicKey)) break block13;
                        this.key = DHUtil.generatePublicKeyParameter((PublicKey)key);
                        break block11;
                    }
                    if (!(key instanceof IESKey)) break block14;
                    IESCipher iESCipher = this;
                    key = (IESKey)key;
                    iESCipher.key = DHUtil.generatePublicKeyParameter(key.getPublic());
                    iESCipher.otherKeyParameter = DHUtil.generatePrivateKeyParameter(key.getPrivate());
                }
                this.random = secureRandom;
                this.state = n;
                this.buffer.reset();
                return;
            }
            throw new InvalidKeyException("must be passed recipient's public DH key for encryption");
        }
        throw new InvalidAlgorithmParameterException("must be passed IES parameters");
    }

    @Override
    public void engineInit(int n, Key key, SecureRandom secureRandom) {
        IESCipher iESCipher = iESCipher2;
        IESCipher iESCipher2 = null;
        try {
            iESCipher.engineInit(n, key, (AlgorithmParameterSpec)((Object)iESCipher2), secureRandom);
            return;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException(b.b.a("cannot handle supplied parameter spec: ").append(invalidAlgorithmParameterException.getMessage()).toString());
        }
    }

    @Override
    public byte[] engineUpdate(byte[] byArray, int n, int n2) {
        this.buffer.write(byArray, n, n2);
        return null;
    }

    @Override
    public int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.buffer.write(byArray, n, n2);
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] engineDoFinal(byte[] byArray, int n, int n2) {
        KeyEncoder keyEncoder;
        EphemeralKeyPairGenerator ephemeralKeyPairGenerator;
        DHKeyPairGenerator dHKeyPairGenerator;
        IESWithCipherParameters iESWithCipherParameters;
        if (n2 != 0) {
            ((IESCipher)((Object)asymmetricKeyParameter3)).buffer.write(byArray, n, n2);
        }
        IESCipher iESCipher = asymmetricKeyParameter3;
        byArray = iESCipher.buffer.toByteArray();
        iESCipher.buffer.reset();
        CipherParameters cipherParameters = iESWithCipherParameters;
        IESCipher iESCipher2 = asymmetricKeyParameter3;
        byte[] byArray2 = iESCipher2.engineSpec.getEncodingV();
        int n3 = iESCipher2.engineSpec.getMacKeySize();
        int n4 = iESCipher2.engineSpec.getCipherKeySize();
        iESWithCipherParameters = new IESWithCipherParameters(((IESCipher)((Object)asymmetricKeyParameter3)).engineSpec.getDerivationV(), byArray2, n3, n4);
        if (iESCipher.engineSpec.getNonce() != null) {
            ParametersWithIV parametersWithIV;
            ParametersWithIV parametersWithIV2 = parametersWithIV;
            parametersWithIV = new ParametersWithIV(cipherParameters, ((IESCipher)((Object)asymmetricKeyParameter3)).engineSpec.getNonce());
            cipherParameters = parametersWithIV2;
        }
        IESCipher iESCipher3 = asymmetricKeyParameter3;
        DHParameters dHParameters = ((DHKeyParameters)iESCipher3.key).getParameters();
        AsymmetricKeyParameter asymmetricKeyParameter = iESCipher3.otherKeyParameter;
        if (asymmetricKeyParameter != null) {
            try {
                int n5 = ((IESCipher)((Object)asymmetricKeyParameter3)).state;
                if (n5 != 1 && n5 != 3) {
                    boolean bl = false;
                    ((IESCipher)((Object)asymmetricKeyParameter3)).engine.init(bl, ((IESCipher)((Object)asymmetricKeyParameter3)).key, asymmetricKeyParameter, cipherParameters);
                } else {
                    boolean bl = true;
                    AsymmetricKeyParameter asymmetricKeyParameter2 = ((IESCipher)((Object)asymmetricKeyParameter3)).key;
                    ((IESCipher)((Object)asymmetricKeyParameter3)).engine.init(bl, asymmetricKeyParameter, asymmetricKeyParameter2, cipherParameters);
                }
                int n6 = 0;
                return ((IESCipher)((Object)asymmetricKeyParameter3)).engine.processBlock(byArray, n6, byArray.length);
            }
            catch (Exception exception) {
                throw new BadBlockException("unable to process block", exception);
            }
        }
        int n7 = ((IESCipher)((Object)asymmetricKeyParameter3)).state;
        if (n7 != 1 && n7 != 3) {
            DHIESPublicKeyParser dHIESPublicKeyParser;
            IESEngine iESEngine;
            IESCipher iESCipher4;
            if (n7 != 2 && n7 != 4) {
                throw new IllegalStateException("IESCipher not initialised");
            }
            try {
                IESCipher iESCipher5 = asymmetricKeyParameter3;
                iESCipher4 = iESCipher5;
                iESEngine = iESCipher5.engine;
                AsymmetricKeyParameter asymmetricKeyParameter3 = ((IESCipher)((Object)asymmetricKeyParameter3)).key;
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new BadBlockException("unable to process block", invalidCipherTextException);
            }
            DHIESPublicKeyParser dHIESPublicKeyParser2 = dHIESPublicKeyParser;
            dHIESPublicKeyParser = new DHIESPublicKeyParser(((DHKeyParameters)asymmetricKeyParameter3).getParameters());
            iESEngine.init(asymmetricKeyParameter3, cipherParameters, dHIESPublicKeyParser2);
            IESEngine iESEngine2 = iESCipher4.engine;
            int n8 = 0;
            return iESEngine2.processBlock(byArray, n8, byArray.length);
        }
        IESCipher iESCipher6 = asymmetricKeyParameter3;
        Object object = dHKeyPairGenerator;
        new DHKeyPairGenerator().init(new DHKeyGenerationParameters(((IESCipher)((Object)asymmetricKeyParameter3)).random, dHParameters));
        EphemeralKeyPairGenerator ephemeralKeyPairGenerator2 = ephemeralKeyPairGenerator;
        DHKeyPairGenerator dHKeyPairGenerator2 = object;
        object = keyEncoder;
        keyEncoder = new KeyEncoder(){

            @Override
            public byte[] getEncoded(AsymmetricKeyParameter object) {
                AsymmetricKeyParameter asymmetricKeyParameter = object;
                int n = (((DHKeyParameters)asymmetricKeyParameter).getParameters().getP().bitLength() + 7) / 8;
                object = new byte[n];
                byte[] byArray = BigIntegers.asUnsignedByteArray(((DHPublicKeyParameters)asymmetricKeyParameter).getY());
                if (byArray.length <= n) {
                    int n2 = byArray.length;
                    System.arraycopy(byArray, 0, object, n -= byArray.length, n2);
                    return object;
                }
                throw new IllegalArgumentException("Senders's public key longer than expected.");
            }
        };
        ephemeralKeyPairGenerator = new EphemeralKeyPairGenerator(dHKeyPairGenerator2, (KeyEncoder)object);
        try {
            iESCipher6.engine.init(((IESCipher)((Object)asymmetricKeyParameter3)).key, cipherParameters, ephemeralKeyPairGenerator2);
            int n9 = 0;
            return iESCipher6.engine.processBlock(byArray, n9, byArray.length);
        }
        catch (Exception exception) {
            throw new BadBlockException("unable to process block", exception);
        }
    }

    @Override
    public int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        byte[] byArray3 = this.engineDoFinal(byArray, n, n2);
        int n4 = byArray3.length;
        System.arraycopy(byArray3, 0, byArray2, n3, n4);
        return byArray3.length;
    }

    public static class IESwithAESCBC
    extends IESCipher {
        public IESwithAESCBC() {
            PaddedBufferedBlockCipher paddedBufferedBlockCipher;
            HMac hMac;
            KDF2BytesGenerator kDF2BytesGenerator;
            IESwithAESCBC iESwithAESCBC = kDF2BytesGenerator2;
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA1());
            HMac hMac2 = hMac;
            hMac = new HMac(DigestFactory.createSHA1());
            PaddedBufferedBlockCipher paddedBufferedBlockCipher2 = paddedBufferedBlockCipher;
            paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new AESEngine()));
            super(new IESEngine(new DHBasicAgreement(), kDF2BytesGenerator2, hMac2, paddedBufferedBlockCipher2), 16);
        }
    }

    public static class IESwithDESedeCBC
    extends IESCipher {
        public IESwithDESedeCBC() {
            PaddedBufferedBlockCipher paddedBufferedBlockCipher;
            HMac hMac;
            KDF2BytesGenerator kDF2BytesGenerator;
            IESwithDESedeCBC iESwithDESedeCBC = kDF2BytesGenerator2;
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA1());
            HMac hMac2 = hMac;
            hMac = new HMac(DigestFactory.createSHA1());
            PaddedBufferedBlockCipher paddedBufferedBlockCipher2 = paddedBufferedBlockCipher;
            paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new DESedeEngine()));
            super(new IESEngine(new DHBasicAgreement(), kDF2BytesGenerator2, hMac2, paddedBufferedBlockCipher2), 8);
        }
    }

    public static class IES
    extends IESCipher {
        public IES() {
            HMac hMac;
            KDF2BytesGenerator kDF2BytesGenerator;
            IES iES = kDF2BytesGenerator2;
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA1());
            HMac hMac2 = hMac;
            hMac = new HMac(DigestFactory.createSHA1());
            super(new IESEngine(new DHBasicAgreement(), kDF2BytesGenerator2, hMac2));
        }
    }
}

