/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dh;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.DHParametersGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dh.BCDHPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dh.BCDHPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.PrimeCertaintyCalculator;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.DHDomainParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BouncyCastleProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import javax.crypto.spec.DHParameterSpec;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Hashtable params = new Hashtable();
    private static Object lock = new Object();
    public DHKeyGenerationParameters param;
    public DHBasicKeyPairGenerator engine = new DHBasicKeyPairGenerator();
    public int strength = 2048;
    public SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    public boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("DH");
    }

    private DHKeyGenerationParameters convertParams(SecureRandom secureRandom, DHParameterSpec object) {
        DHParameters dHParameters;
        if (object instanceof DHDomainParameterSpec) {
            return new DHKeyGenerationParameters(secureRandom, ((DHDomainParameterSpec)object).getDomainParameters());
        }
        DHParameters dHParameters2 = dHParameters;
        DHParameterSpec dHParameterSpec = object;
        object = dHParameterSpec.getP();
        BigInteger bigInteger = dHParameterSpec.getG();
        int n = dHParameterSpec.getL();
        dHParameters = new DHParameters((BigInteger)object, bigInteger, null, n);
        return new DHKeyGenerationParameters(secureRandom, dHParameters2);
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        KeyPairGeneratorSpi keyPairGeneratorSpi = this;
        keyPairGeneratorSpi.strength = n;
        keyPairGeneratorSpi.random = secureRandom;
        keyPairGeneratorSpi.initialised = false;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        if (algorithmParameterSpec instanceof DHParameterSpec) {
            KeyPairGeneratorSpi keyPairGeneratorSpi = dHKeyGenerationParameters;
            try {
                DHKeyGenerationParameters dHKeyGenerationParameters = keyPairGeneratorSpi.convertParams(secureRandom, (DHParameterSpec)algorithmParameterSpec);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidAlgorithmParameterException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
            keyPairGeneratorSpi.param = dHKeyGenerationParameters;
            keyPairGeneratorSpi.engine.init(dHKeyGenerationParameters);
            keyPairGeneratorSpi.initialised = true;
            return;
        }
        throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KeyPair generateKeyPair() {
        BCDHPrivateKey bCDHPrivateKey;
        Object object;
        block7: {
            block9: {
                Object object2;
                block10: {
                    block8: {
                        if (((KeyPairGeneratorSpi)object8).initialised) break block7;
                        object = Integers.valueOf(((KeyPairGeneratorSpi)object8).strength);
                        if (!params.containsKey(object)) break block8;
                        ((KeyPairGeneratorSpi)object8).param = (DHKeyGenerationParameters)params.get(object);
                        break block9;
                    }
                    object2 = BouncyCastleProvider.CONFIGURATION.getDHDefaultParameters(((KeyPairGeneratorSpi)object8).strength);
                    if (object2 == null) break block10;
                    Object object3 = object8;
                    ((KeyPairGeneratorSpi)object3).param = super.convertParams(((KeyPairGeneratorSpi)object3).random, (DHParameterSpec)object2);
                    break block9;
                }
                object2 = lock;
                synchronized (object2) {
                    DHKeyGenerationParameters dHKeyGenerationParameters;
                    int n;
                    Object object4;
                    DHParametersGenerator dHParametersGenerator;
                    block11: {
                        if (!params.containsKey(object)) break block11;
                        ((KeyPairGeneratorSpi)object8).param = (DHKeyGenerationParameters)params.get(object);
                        break block9;
                    }
                    Object object5 = object8;
                    Object object6 = dHParametersGenerator;
                    {
                        Object object7 = object8;
                        object4 = object7;
                        ((DHParametersGenerator)object6)();
                        n = ((KeyPairGeneratorSpi)object7).strength;
                    }
                    {
                        int n2 = PrimeCertaintyCalculator.getDefaultCertainty(n);
                        SecureRandom secureRandom = ((KeyPairGeneratorSpi)object4).random;
                        dHParametersGenerator.init(n, n2, secureRandom);
                    }
                    DHKeyGenerationParameters dHKeyGenerationParameters2 = dHKeyGenerationParameters;
                    {
                        DHParametersGenerator dHParametersGenerator2 = object6;
                        object6 = ((KeyPairGeneratorSpi)object8).random;
                        ((KeyPairGeneratorSpi)object5).param = new DHKeyGenerationParameters((SecureRandom)object6, dHParametersGenerator2.generateParameters());
                        params.put(object, dHKeyGenerationParameters2);
                    }
                }
            }
            ((KeyPairGeneratorSpi)object8).engine.init(((KeyPairGeneratorSpi)object8).param);
            ((KeyPairGeneratorSpi)object8).initialised = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = ((KeyPairGeneratorSpi)object8).engine.generateKeyPair();
        Object object8 = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        object = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        BCDHPublicKey bCDHPublicKey = new BCDHPublicKey((DHPublicKeyParameters)object8);
        object8 = bCDHPrivateKey;
        bCDHPrivateKey = new BCDHPrivateKey((DHPrivateKeyParameters)object);
        return new KeyPair(bCDHPublicKey, (PrivateKey)object8);
    }
}

