/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X962Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec.ECUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPointEncoder;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BouncyCastleProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPrivateKeySpec;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Enumeration;

public class BCECPrivateKey
implements java.security.interfaces.ECPrivateKey,
ECPrivateKey,
PKCS12BagAttributeCarrier,
ECPointEncoder {
    public static final long serialVersionUID = 994553197664784084L;
    private String algorithm;
    private boolean withCompression;
    private transient BigInteger d;
    private transient ECParameterSpec ecSpec;
    private transient ProviderConfiguration configuration;
    private transient DERBitString publicKey;
    private transient PKCS12BagAttributeCarrierImpl attrCarrier;

    public BCECPrivateKey() {
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrier.algorithm = "EC";
        PKCS12BagAttributeCarrier pKCS12BagAttributeCarrier = pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrierImpl = new PKCS12BagAttributeCarrierImpl();
        v1.attrCarrier = pKCS12BagAttributeCarrier;
    }

    public BCECPrivateKey(java.security.interfaces.ECPrivateKey eCPrivateKey, ProviderConfiguration providerConfiguration) {
        this.algorithm = "EC";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.d = eCPrivateKey.getS();
        this.algorithm = eCPrivateKey.getAlgorithm();
        this.ecSpec = eCPrivateKey.getParams();
        this.configuration = providerConfiguration;
    }

    public BCECPrivateKey(String string, ECPrivateKeySpec eCPrivateKeySpec, ProviderConfiguration providerConfiguration) {
        this.algorithm = "EC";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.algorithm = string;
        this.d = eCPrivateKeySpec.getD();
        this.ecSpec = eCPrivateKeySpec.getParams() != null ? EC5Util.convertSpec(EC5Util.convertCurve(eCPrivateKeySpec.getParams().getCurve(), eCPrivateKeySpec.getParams().getSeed()), eCPrivateKeySpec.getParams()) : null;
        this.configuration = providerConfiguration;
    }

    public BCECPrivateKey(String string, java.security.spec.ECPrivateKeySpec eCPrivateKeySpec, ProviderConfiguration providerConfiguration) {
        this.algorithm = "EC";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.algorithm = string;
        this.d = eCPrivateKeySpec.getS();
        this.ecSpec = eCPrivateKeySpec.getParams();
        this.configuration = providerConfiguration;
    }

    public BCECPrivateKey(String string, BCECPrivateKey bCECPrivateKey) {
        this.algorithm = "EC";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.algorithm = string;
        this.d = bCECPrivateKey.d;
        this.ecSpec = bCECPrivateKey.ecSpec;
        this.withCompression = bCECPrivateKey.withCompression;
        this.attrCarrier = bCECPrivateKey.attrCarrier;
        this.publicKey = bCECPrivateKey.publicKey;
        this.configuration = bCECPrivateKey.configuration;
    }

    public BCECPrivateKey(String object, ECPrivateKeyParameters object2, BCECPublicKey bCECPublicKey, ECParameterSpec eCParameterSpec, ProviderConfiguration providerConfiguration) {
        this.algorithm = "EC";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.algorithm = object;
        this.d = ((ECPrivateKeyParameters)object2).getD();
        this.configuration = providerConfiguration;
        if (eCParameterSpec == null) {
            object = ((ECKeyParameters)object2).getParameters();
            Object object3 = object2 = EC5Util.convertCurve(((ECDomainParameters)object).getCurve(), ((ECDomainParameters)object).getSeed());
            Object object4 = object;
            object = EC5Util.convertPoint(((ECDomainParameters)object4).getG());
            object2 = ((ECDomainParameters)object4).getN();
            int n = ((ECDomainParameters)object4).getH().intValue();
            this.ecSpec = new ECParameterSpec((EllipticCurve)object3, (ECPoint)object, (BigInteger)object2, n);
        } else {
            this.ecSpec = eCParameterSpec;
        }
        this.publicKey = this.getPublicKeyDetails(bCECPublicKey);
    }

    public BCECPrivateKey(String object, ECPrivateKeyParameters object2, BCECPublicKey bCECPublicKey, com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec, ProviderConfiguration providerConfiguration) {
        this.algorithm = "EC";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.algorithm = object;
        this.d = ((ECPrivateKeyParameters)object2).getD();
        this.configuration = providerConfiguration;
        if (eCParameterSpec == null) {
            object = ((ECKeyParameters)object2).getParameters();
            Object object3 = object2 = EC5Util.convertCurve(((ECDomainParameters)object).getCurve(), ((ECDomainParameters)object).getSeed());
            Object object4 = object;
            object = EC5Util.convertPoint(((ECDomainParameters)object4).getG());
            object2 = ((ECDomainParameters)object4).getN();
            int n = ((ECDomainParameters)object4).getH().intValue();
            this.ecSpec = new ECParameterSpec((EllipticCurve)object3, (ECPoint)object, (BigInteger)object2, n);
        } else {
            this.ecSpec = EC5Util.convertSpec(EC5Util.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getSeed()), eCParameterSpec);
        }
        try {
            this.publicKey = this.getPublicKeyDetails(bCECPublicKey);
        }
        catch (Exception exception) {
            this.publicKey = null;
        }
    }

    public BCECPrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters, ProviderConfiguration providerConfiguration) {
        BCECPrivateKey bCECPrivateKey = this;
        this.algorithm = "EC";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.algorithm = string;
        bCECPrivateKey.d = eCPrivateKeyParameters.getD();
        bCECPrivateKey.ecSpec = null;
        this.configuration = providerConfiguration;
    }

    public BCECPrivateKey(String string, PrivateKeyInfo privateKeyInfo, ProviderConfiguration providerConfiguration) {
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl;
        BCECPrivateKey bCECPrivateKey = pKCS12BagAttributeCarrier;
        bCECPrivateKey.algorithm = "EC";
        PKCS12BagAttributeCarrier pKCS12BagAttributeCarrier = pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrierImpl = new PKCS12BagAttributeCarrierImpl();
        bCECPrivateKey.attrCarrier = pKCS12BagAttributeCarrier;
        bCECPrivateKey.algorithm = string;
        bCECPrivateKey.configuration = providerConfiguration;
        bCECPrivateKey.populateFromPrivKeyInfo(privateKeyInfo);
    }

    private void populateFromPrivKeyInfo(PrivateKeyInfo aSN1Encodable) {
        X962Parameters x962Parameters = X962Parameters.getInstance(aSN1Encodable.getPrivateKeyAlgorithm().getParameters());
        ((BCECPrivateKey)((Object)eCPrivateKey)).ecSpec = EC5Util.convertToSpec(x962Parameters, EC5Util.getCurve(((BCECPrivateKey)((Object)eCPrivateKey)).configuration, x962Parameters));
        if ((aSN1Encodable = aSN1Encodable.parsePrivateKey()) instanceof ASN1Integer) {
            ((BCECPrivateKey)((Object)eCPrivateKey)).d = ASN1Integer.getInstance(aSN1Encodable).getValue();
        } else {
            BCECPrivateKey bCECPrivateKey = eCPrivateKey;
            com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey eCPrivateKey = com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey.getInstance(aSN1Encodable);
            bCECPrivateKey.d = eCPrivateKey.getKey();
            bCECPrivateKey.publicKey = eCPrivateKey.getPublicKey();
        }
    }

    private DERBitString getPublicKeyDetails(BCECPublicKey bCECPublicKey) {
        try {
            return SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(bCECPublicKey.getEncoded())).getPublicKeyData();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        BCECPrivateKey bCECPrivateKey = object;
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        Object object = (byte[])objectInputStream2.readObject();
        bCECPrivateKey.configuration = BouncyCastleProvider.CONFIGURATION;
        bCECPrivateKey.populateFromPrivKeyInfo(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray((byte[])object)));
        bCECPrivateKey.attrCarrier = new PKCS12BagAttributeCarrierImpl();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey eCPrivateKey;
        int n;
        BCECPrivateKey bCECPrivateKey = serializable;
        X962Parameters x962Parameters = ECUtils.getDomainParametersFromName(bCECPrivateKey.ecSpec, serializable.withCompression);
        Object object = bCECPrivateKey.ecSpec;
        if (object == null) {
            n = ECUtil.getOrderBitLength(serializable.configuration, null, serializable.getS());
        } else {
            object = ((ECParameterSpec)object).getOrder();
            n = ECUtil.getOrderBitLength(serializable.configuration, (BigInteger)object, serializable.getS());
        }
        if (serializable.publicKey != null) {
            com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey eCPrivateKey2;
            eCPrivateKey = eCPrivateKey2;
            BCECPrivateKey bCECPrivateKey2 = serializable;
            Serializable serializable = bCECPrivateKey2.getS();
            DERBitString dERBitString = bCECPrivateKey2.publicKey;
            eCPrivateKey2 = new com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey(n, (BigInteger)serializable, dERBitString, x962Parameters);
        } else {
            com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey eCPrivateKey3;
            eCPrivateKey = eCPrivateKey3;
            eCPrivateKey3 = new com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey(n, serializable.getS(), (ASN1Encodable)x962Parameters);
        }
        try {
            return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), eCPrivateKey).getEncoded("DER");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    @Override
    public com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec getParameters() {
        ECParameterSpec eCParameterSpec = ((BCECPrivateKey)((Object)eCParameterSpec)).ecSpec;
        if (eCParameterSpec == null) {
            return null;
        }
        return EC5Util.convertSpec(eCParameterSpec);
    }

    public com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec engineGetSpec() {
        ECParameterSpec eCParameterSpec = this.ecSpec;
        if (eCParameterSpec != null) {
            return EC5Util.convertSpec(eCParameterSpec);
        }
        return this.configuration.getEcImplicitlyCa();
    }

    @Override
    public BigInteger getS() {
        return this.d;
    }

    @Override
    public BigInteger getD() {
        return this.d;
    }

    @Override
    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.attrCarrier.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    @Override
    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.attrCarrier.getBagAttribute(aSN1ObjectIdentifier);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }

    @Override
    public void setPointFormat(String string) {
        this.withCompression = "UNCOMPRESSED".equalsIgnoreCase(string) ^ true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCECPrivateKey)) {
            return false;
        }
        object = (BCECPrivateKey)object;
        return this.getD().equals(((BCECPrivateKey)object).getD()) && this.engineGetSpec().equals(((BCECPrivateKey)object).engineGetSpec());
    }

    public int hashCode() {
        return this.getD().hashCode() ^ this.engineGetSpec().hashCode();
    }

    public String toString() {
        BCECPrivateKey bCECPrivateKey = serializable;
        Serializable serializable = bCECPrivateKey.d;
        com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = bCECPrivateKey.engineGetSpec();
        return ECUtil.privateKeyToString("EC", (BigInteger)serializable, eCParameterSpec);
    }
}

