/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ecgost12;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DSAExt;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.GOST3411_2012_256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.ECGOST3410_2012Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ecgost12.BCECGOST3410_2012PublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BouncyCastleProvider;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public class ECGOST2012SignatureSpi256
extends SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private Digest digest;
    private DSAExt signer;
    private int size = 64;
    private int halfSize = 64 / 2;

    public ECGOST2012SignatureSpi256() {
        this.digest = new GOST3411_2012_256Digest();
        this.signer = new ECGOST3410_2012Signer();
    }

    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey publicKey) {
        return publicKey instanceof BCECGOST3410_2012PublicKey ? ((BCECGOST3410_2012PublicKey)publicKey).engineGetKeyParameters() : ECUtil.generatePublicKeyParameter(publicKey);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void engineInitVerify(PublicKey object) {
        if (object instanceof ECPublicKey) {
            object = (ECKeyParameters)ECGOST2012SignatureSpi256.generatePublicKeyParameter((PublicKey)object);
        } else {
            try {
                object = (ECKeyParameters)ECUtil.generatePublicKeyParameter(BouncyCastleProvider.getPublicKey(SubjectPublicKeyInfo.getInstance(object.getEncoded())));
            }
            catch (Exception exception) {
                throw new InvalidKeyException("cannot recognise key type in ECGOST-2012-256 signer");
            }
        }
        if (((ECKeyParameters)object).getParameters().getN().bitLength() <= 256) {
            ECGOST2012SignatureSpi256 eCGOST2012SignatureSpi256 = this;
            eCGOST2012SignatureSpi256.digest.reset();
            eCGOST2012SignatureSpi256.signer.init(false, (CipherParameters)object);
            return;
        }
        throw new InvalidKeyException("key out of range for ECGOST-2012-256");
    }

    @Override
    public void engineInitSign(PrivateKey object) {
        if (object instanceof ECKey) {
            if (((ECKeyParameters)(object = (ECKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)object))).getParameters().getN().bitLength() <= 256) {
                ECGOST2012SignatureSpi256 eCGOST2012SignatureSpi256 = parametersWithRandom2;
                eCGOST2012SignatureSpi256.digest.reset();
                SecureRandom secureRandom = eCGOST2012SignatureSpi256.appRandom;
                if (secureRandom != null) {
                    ParametersWithRandom parametersWithRandom;
                    ParametersWithRandom parametersWithRandom2 = parametersWithRandom;
                    parametersWithRandom = new ParametersWithRandom((CipherParameters)object, secureRandom);
                    ((ECGOST2012SignatureSpi256)((Object)parametersWithRandom2)).signer.init(true, parametersWithRandom2);
                } else {
                    ((ECGOST2012SignatureSpi256)((Object)parametersWithRandom2)).signer.init(true, (CipherParameters)object);
                }
                return;
            }
            throw new InvalidKeyException("key out of range for ECGOST-2012-256");
        }
        throw new InvalidKeyException("cannot recognise key type in ECGOST-2012-256 signer");
    }

    @Override
    public void engineUpdate(byte by) {
        this.digest.update(by);
    }

    @Override
    public void engineUpdate(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public byte[] engineSign() {
        block19: {
            block18: {
                block17: {
                    v0 = this;
                    var1_4 = new byte[v0.digest.getDigestSize()];
                    v0.digest.doFinal(var1_4, 0);
                    try {
                        var2_6 = new byte[v0.size];
                    }
                    catch (Exception var0_3) {
                        throw new SignatureException(var0_3.toString());
                    }
                    v1 = v0.signer.generateSignature(var1_4);
                    v2 = v1;
                    var1_4 = v1[0].toByteArray();
                    var3_7 = v2[1].toByteArray();
                    if (var3_7[0] == 0) break block17;
                    var4_9 = 0;
                    var3_8 = this.halfSize - var3_7.length;
                    var5_10 = var3_7.length;
                    System.arraycopy(var3_7, var4_9, var2_6, var3_8, var5_10);
                    ** GOTO lbl34
                }
                v3 = var2_6;
                v4 = var3_7;
                var3_8 = this.halfSize - (var3_7.length - 1);
                v5 = v4.length;
                System.arraycopy(var3_7, 1, v3, var3_8, v5 - 1);
lbl34:
                // 2 sources

                if (var1_4[0] == 0) break block18;
                var0_1 = 0;
                var1_5 = this.size - var1_4.length;
                var3_8 = var1_4.length;
                System.arraycopy(var1_4, var0_1, var2_6, var1_5, var3_8);
                break block19;
            }
            v6 = var2_6;
            v7 = var1_4;
            var0_2 = this.size - (var1_4.length - 1);
            v8 = v7.length;
            System.arraycopy(var1_4, 1, v6, var0_2, v8 - 1);
        }
        return var2_6;
    }

    @Override
    public boolean engineVerify(byte[] byArray) {
        BigInteger bigInteger;
        int n;
        ECGOST2012SignatureSpi256 eCGOST2012SignatureSpi256 = object;
        ECGOST2012SignatureSpi256 eCGOST2012SignatureSpi2562 = object;
        ECGOST2012SignatureSpi256 eCGOST2012SignatureSpi2563 = object;
        Object object = new byte[eCGOST2012SignatureSpi2563.digest.getDigestSize()];
        eCGOST2012SignatureSpi2563.digest.doFinal((byte[])object, 0);
        try {
            n = eCGOST2012SignatureSpi2563.halfSize;
        }
        catch (Exception exception) {
            throw new SignatureException("error decoding signature bytes.");
        }
        Object object2 = new byte[n];
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        n = eCGOST2012SignatureSpi2562.halfSize;
        System.arraycopy(byArray, n, object2, 0, n);
        BigInteger[] bigIntegerArray = new BigInteger[2];
        BigInteger[] bigIntegerArray2 = bigIntegerArray;
        bigIntegerArray[0] = new BigInteger(1, (byte[])object2);
        object2 = bigInteger;
        bigInteger = new BigInteger(1, byArray2);
        bigIntegerArray[1] = bigInteger;
        return eCGOST2012SignatureSpi256.signer.verifySignature((byte[])object, bigIntegerArray2[0], (BigInteger)object2);
    }

    @Override
    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    public void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }
}

