/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.elgamal;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.ElGamalParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ElGamalPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ElGamalParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ElGamalPrivateKeySpec;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Enumeration;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;

public class BCElGamalPrivateKey
implements ElGamalPrivateKey,
DHPrivateKey,
PKCS12BagAttributeCarrier {
    public static final long serialVersionUID = 4819350091141529678L;
    private BigInteger x;
    private transient ElGamalParameterSpec elSpec;
    private transient PKCS12BagAttributeCarrierImpl attrCarrier;

    public BCElGamalPrivateKey() {
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl;
        PKCS12BagAttributeCarrier pKCS12BagAttributeCarrier = pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrierImpl = new PKCS12BagAttributeCarrierImpl();
        v1.attrCarrier = pKCS12BagAttributeCarrier;
    }

    public BCElGamalPrivateKey(ElGamalPrivateKey elGamalPrivateKey) {
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.x = elGamalPrivateKey.getX();
        this.elSpec = elGamalPrivateKey.getParameters();
    }

    public BCElGamalPrivateKey(DHPrivateKey dHPrivateKey) {
        BCElGamalPrivateKey bCElGamalPrivateKey = this;
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        bCElGamalPrivateKey.x = dHPrivateKey.getX();
        bCElGamalPrivateKey.elSpec = new ElGamalParameterSpec(dHPrivateKey.getParams().getP(), dHPrivateKey.getParams().getG());
    }

    public BCElGamalPrivateKey(ElGamalPrivateKeySpec elGamalPrivateKeySpec) {
        BCElGamalPrivateKey bCElGamalPrivateKey = this;
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        bCElGamalPrivateKey.x = elGamalPrivateKeySpec.getX();
        bCElGamalPrivateKey.elSpec = new ElGamalParameterSpec(elGamalPrivateKeySpec.getParams().getP(), elGamalPrivateKeySpec.getParams().getG());
    }

    public BCElGamalPrivateKey(DHPrivateKeySpec dHPrivateKeySpec) {
        BCElGamalPrivateKey bCElGamalPrivateKey = serializable;
        serializable.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        bCElGamalPrivateKey.x = dHPrivateKeySpec.getX();
        DHPrivateKeySpec dHPrivateKeySpec2 = dHPrivateKeySpec;
        Serializable serializable = dHPrivateKeySpec2.getP();
        bCElGamalPrivateKey.elSpec = new ElGamalParameterSpec((BigInteger)serializable, dHPrivateKeySpec2.getG());
    }

    public BCElGamalPrivateKey(PrivateKeyInfo privateKeyInfo) {
        BCElGamalPrivateKey bCElGamalPrivateKey = object;
        PrivateKeyInfo privateKeyInfo2 = privateKeyInfo;
        ((BCElGamalPrivateKey)object).attrCarrier = new PKCS12BagAttributeCarrierImpl();
        Object object = ElGamalParameter.getInstance(privateKeyInfo2.getPrivateKeyAlgorithm().getParameters());
        bCElGamalPrivateKey.x = ASN1Integer.getInstance(privateKeyInfo2.parsePrivateKey()).getValue();
        Object object2 = object;
        object = ((ElGamalParameter)object2).getP();
        bCElGamalPrivateKey.elSpec = new ElGamalParameterSpec((BigInteger)object, ((ElGamalParameter)object2).getG());
    }

    public BCElGamalPrivateKey(ElGamalPrivateKeyParameters elGamalPrivateKeyParameters) {
        BCElGamalPrivateKey bCElGamalPrivateKey = this;
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        bCElGamalPrivateKey.x = elGamalPrivateKeyParameters.getX();
        bCElGamalPrivateKey.elSpec = new ElGamalParameterSpec(elGamalPrivateKeyParameters.getParameters().getP(), elGamalPrivateKeyParameters.getParameters().getG());
    }

    private void readObject(ObjectInputStream objectInputStream) {
        BCElGamalPrivateKey bCElGamalPrivateKey = this;
        objectInputStream.defaultReadObject();
        bCElGamalPrivateKey.elSpec = new ElGamalParameterSpec((BigInteger)objectInputStream.readObject(), (BigInteger)objectInputStream.readObject());
        bCElGamalPrivateKey.attrCarrier = new PKCS12BagAttributeCarrierImpl();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.elSpec.getP());
        objectOutputStream.writeObject(this.elSpec.getG());
    }

    @Override
    public String getAlgorithm() {
        return "ElGamal";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        try {
            return new PrivateKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(this.elSpec.getP(), this.elSpec.getG())), new ASN1Integer(this.getX())).getEncoded("DER");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public ElGamalParameterSpec getParameters() {
        return this.elSpec;
    }

    @Override
    public DHParameterSpec getParams() {
        return new DHParameterSpec(this.elSpec.getP(), this.elSpec.getG());
    }

    @Override
    public BigInteger getX() {
        return this.x;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DHPrivateKey)) {
            return false;
        }
        object = (DHPrivateKey)object;
        return this.getX().equals(object.getX()) && this.getParams().getG().equals(object.getParams().getG()) && this.getParams().getP().equals(object.getParams().getP()) && this.getParams().getL() == object.getParams().getL();
    }

    public int hashCode() {
        return this.getX().hashCode() ^ this.getParams().getG().hashCode() ^ this.getParams().getP().hashCode() ^ this.getParams().getL();
    }

    @Override
    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.attrCarrier.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    @Override
    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.attrCarrier.getBagAttribute(aSN1ObjectIdentifier);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }
}

