/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.gost;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.gost.BCGOST3410PrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.gost.BCGOST3410PublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.GOST3410PrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.GOST3410PublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.GOST3410PrivateKeySpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.GOST3410PublicKeyParameterSetSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.GOST3410PublicKeySpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.KeySpec;

public class KeyFactorySpi
extends BaseKeyFactorySpi {
    @Override
    public KeySpec engineGetKeySpec(Key object, Class serializable) {
        Object object2;
        if (serializable.isAssignableFrom(GOST3410PublicKeySpec.class) && object instanceof GOST3410PublicKey) {
            object2 = (GOST3410PublicKey)object;
            Object object3 = object = object2.getParameters().getPublicKeyParameters();
            object2 = object2.getY();
            object = ((GOST3410PublicKeyParameterSetSpec)object3).getP();
            serializable = ((GOST3410PublicKeyParameterSetSpec)object3).getQ();
            BigInteger bigInteger = ((GOST3410PublicKeyParameterSetSpec)object3).getA();
            return new GOST3410PublicKeySpec((BigInteger)object2, (BigInteger)object, (BigInteger)serializable, bigInteger);
        }
        if (serializable.isAssignableFrom(GOST3410PrivateKeySpec.class) && object instanceof GOST3410PrivateKey) {
            object2 = (GOST3410PrivateKey)object;
            Object object4 = object = object2.getParameters().getPublicKeyParameters();
            object2 = object2.getX();
            object = ((GOST3410PublicKeyParameterSetSpec)object4).getP();
            serializable = ((GOST3410PublicKeyParameterSetSpec)object4).getQ();
            BigInteger bigInteger = ((GOST3410PublicKeyParameterSetSpec)object4).getA();
            return new GOST3410PrivateKeySpec((BigInteger)object2, (BigInteger)object, (BigInteger)serializable, bigInteger);
        }
        return super.engineGetKeySpec((Key)object, (Class)serializable);
    }

    @Override
    public Key engineTranslateKey(Key key) {
        if (key instanceof GOST3410PublicKey) {
            return new BCGOST3410PublicKey((GOST3410PublicKey)key);
        }
        if (key instanceof GOST3410PrivateKey) {
            return new BCGOST3410PrivateKey((GOST3410PrivateKey)key);
        }
        throw new InvalidKeyException("key type unknown");
    }

    @Override
    public PrivateKey engineGeneratePrivate(KeySpec keySpec) {
        if (keySpec instanceof GOST3410PrivateKeySpec) {
            return new BCGOST3410PrivateKey((GOST3410PrivateKeySpec)keySpec);
        }
        return super.engineGeneratePrivate(keySpec);
    }

    @Override
    public PublicKey engineGeneratePublic(KeySpec keySpec) {
        if (keySpec instanceof GOST3410PublicKeySpec) {
            return new BCGOST3410PublicKey((GOST3410PublicKeySpec)keySpec);
        }
        return super.engineGeneratePublic(keySpec);
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        if (aSN1ObjectIdentifier.equals(CryptoProObjectIdentifiers.gostR3410_94)) {
            return new BCGOST3410PrivateKey(privateKeyInfo);
        }
        throw new IOException(a.a("algorithm identifier ", aSN1ObjectIdentifier, " in key not recognised"));
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = subjectPublicKeyInfo.getAlgorithm().getAlgorithm();
        if (aSN1ObjectIdentifier.equals(CryptoProObjectIdentifiers.gostR3410_94)) {
            return new BCGOST3410PublicKey(subjectPublicKeyInfo);
        }
        throw new IOException(a.a("algorithm identifier ", aSN1ObjectIdentifier, " in key not recognised"));
    }
}

