/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.misc.CAST5CBCParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherKeyGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.CAST5Engine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CBCBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.digest.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.digest.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public final class CAST5 {
    private CAST5() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = CAST5.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            ConfigurableProvider configurableProvider2 = configurableProvider;
            String string = PREFIX;
            d.a(new StringBuilder(), string, "$AlgParams", configurableProvider, "AlgorithmParameters.CAST5");
            d.a(com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.d.a(configurableProvider2, "AlgorithmParameterGenerator.CAST5", f.a(configurableProvider2, "Alg.Alias.AlgorithmParameters.1.2.840.113533.7.66.10", "CAST5", string, "$AlgParamGen"), "Alg.Alias.AlgorithmParameterGenerator.1.2.840.113533.7.66.10", "CAST5"), string, "$ECB", configurableProvider, "Cipher.CAST5");
            ASN1ObjectIdentifier aSN1ObjectIdentifier = MiscObjectIdentifiers.cast5CBC;
            String string2 = (String)string + "$CBC";
            configurableProvider2.addAlgorithm("Cipher", aSN1ObjectIdentifier, string2);
            d.a(new StringBuilder(), string, "$KeyGen", configurableProvider, "KeyGenerator.CAST5");
            configurableProvider2.addAlgorithm("Alg.Alias.KeyGenerator", aSN1ObjectIdentifier, "CAST5");
        }
    }

    public static class AlgParams
    extends BaseAlgorithmParameters {
        private byte[] iv;
        private int keyLength = 128;

        @Override
        public byte[] engineGetEncoded() {
            Object object = ((AlgParams)object).iv;
            byte[] byArray = new byte[((AlgParams)object).iv.length];
            Object object2 = object;
            int n = ((Object)object2).length;
            System.arraycopy(object2, 0, byArray, 0, n);
            return byArray;
        }

        @Override
        public byte[] engineGetEncoded(String string) {
            if (((BaseAlgorithmParameters)object).isASN1FormatString(string)) {
                AlgParams algParams = object;
                Object object = algParams.engineGetEncoded();
                return new CAST5CBCParameters((byte[])object, algParams.keyLength).getEncoded();
            }
            if (string.equals("RAW")) {
                return ((AlgParams)object).engineGetEncoded();
            }
            return null;
        }

        @Override
        public AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) {
            if (clazz != IvParameterSpec.class && clazz != AlgorithmParameterSpec.class) {
                throw new InvalidParameterSpecException("unknown parameter spec passed to CAST5 parameters object.");
            }
            return new IvParameterSpec(this.iv);
        }

        @Override
        public void engineInit(AlgorithmParameterSpec algorithmParameterSpec) {
            if (algorithmParameterSpec instanceof IvParameterSpec) {
                this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
                return;
            }
            throw new InvalidParameterSpecException("IvParameterSpec required to initialise a CAST5 parameters algorithm parameters object");
        }

        @Override
        public void engineInit(byte[] byArray) {
            byArray = new byte[byArray.length];
            this.iv = byArray;
            int n = byArray.length;
            System.arraycopy(byArray, 0, byArray, 0, n);
        }

        @Override
        public void engineInit(byte[] byArray, String string) {
            if (((BaseAlgorithmParameters)((Object)cAST5CBCParameters)).isASN1FormatString(string)) {
                AlgParams algParams = cAST5CBCParameters;
                CAST5CBCParameters cAST5CBCParameters = CAST5CBCParameters.getInstance(new ASN1InputStream(byArray).readObject());
                algParams.keyLength = cAST5CBCParameters.getKeyLength();
                algParams.iv = cAST5CBCParameters.getIV();
                return;
            }
            if (string.equals("RAW")) {
                ((AlgParams)((Object)cAST5CBCParameters)).engineInit(byArray);
                return;
            }
            throw new IOException("Unknown parameters format in IV parameters object");
        }

        @Override
        public String engineToString() {
            return "CAST5 Parameters";
        }
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        @Override
        public void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for CAST5 parameter generation.");
        }

        @Override
        public AlgorithmParameters engineGenerateParameters() {
            byte[] byArray = new byte[8];
            if (this.random == null) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
            AlgParamGen algParamGen = this;
            algParamGen.random.nextBytes(byArray);
            try {
                AlgorithmParameters algorithmParameters = algParamGen.createParametersInstance("CAST5");
                algorithmParameters.init(new IvParameterSpec(byArray));
                return algorithmParameters;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            CipherKeyGenerator cipherKeyGenerator;
            KeyGen keyGen = cipherKeyGenerator2;
            CipherKeyGenerator cipherKeyGenerator2 = cipherKeyGenerator;
            cipherKeyGenerator = new CipherKeyGenerator();
            super("CAST5", 128, cipherKeyGenerator2);
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            CAST5Engine cAST5Engine;
            CBCBlockCipher cBCBlockCipher;
            CBC cBC = cBCBlockCipher2;
            CBCBlockCipher cBCBlockCipher2 = cBCBlockCipher;
            CAST5Engine cAST5Engine2 = cAST5Engine;
            cAST5Engine = new CAST5Engine();
            cBCBlockCipher = new CBCBlockCipher(cAST5Engine2);
            super(cBCBlockCipher2, 64);
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            CAST5Engine cAST5Engine;
            ECB eCB = cAST5Engine2;
            CAST5Engine cAST5Engine2 = cAST5Engine;
            cAST5Engine = new CAST5Engine();
            super(cAST5Engine2);
        }
    }
}

