/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.digest.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseSecretKeyFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class OpenSSLPBKDF {
    private OpenSSLPBKDF() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = OpenSSLPBKDF.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            d.a(new StringBuilder(), PREFIX, "$PBKDF", configurableProvider, "SecretKeyFactory.PBKDF-OPENSSL");
        }
    }

    public static class PBKDF
    extends BaseSecretKeyFactory {
        public PBKDF() {
            super("PBKDF-OpenSSL", null);
        }

        @Override
        public SecretKey engineGenerateSecret(KeySpec object) {
            if (object instanceof PBEKeySpec) {
                PBEKeySpec pBEKeySpec = (PBEKeySpec)object;
                if (pBEKeySpec.getSalt() != null) {
                    if (pBEKeySpec.getIterationCount() > 0) {
                        if (pBEKeySpec.getKeyLength() > 0) {
                            if (pBEKeySpec.getPassword().length != 0) {
                                OpenSSLPBEParametersGenerator openSSLPBEParametersGenerator;
                                object = openSSLPBEParametersGenerator;
                                PBEKeySpec pBEKeySpec2 = pBEKeySpec;
                                ((OpenSSLPBEParametersGenerator)object)();
                                byte[] byArray = Strings.toUTF8ByteArray(pBEKeySpec2.getPassword());
                                openSSLPBEParametersGenerator.init(byArray, pBEKeySpec2.getSalt());
                                return new SecretKeySpec(((KeyParameter)((OpenSSLPBEParametersGenerator)object).generateDerivedParameters(pBEKeySpec.getKeyLength())).getKey(), "OpenSSLPBKDF");
                            }
                            throw new IllegalArgumentException("password empty");
                        }
                        throw new InvalidKeySpecException(b.a("positive key length required: ").append(pBEKeySpec.getKeyLength()).toString());
                    }
                    throw new InvalidKeySpecException(b.a("positive iteration count required: ").append(pBEKeySpec.getIterationCount()).toString());
                }
                throw new InvalidKeySpecException("missing required salt");
            }
            throw new InvalidKeySpecException("Invalid KeySpec");
        }
    }
}

