/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherKeyGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class BaseKeyGenerator
extends KeyGeneratorSpi {
    public String algName;
    public int keySize;
    public int defaultKeySize;
    public CipherKeyGenerator engine;
    public boolean uninitialised = true;

    public BaseKeyGenerator(String string, int n, CipherKeyGenerator cipherKeyGenerator) {
        this.algName = string;
        this.defaultKeySize = n;
        this.keySize = n;
        this.engine = cipherKeyGenerator;
    }

    @Override
    public void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        throw new InvalidAlgorithmParameterException("Not Implemented");
    }

    @Override
    public void engineInit(SecureRandom secureRandom) {
        if (secureRandom != null) {
            this.engine.init(new KeyGenerationParameters(secureRandom, this.defaultKeySize));
            this.uninitialised = false;
        }
    }

    @Override
    public void engineInit(int n, SecureRandom secureRandom) {
        if (secureRandom == null) {
            secureRandom = CryptoServicesRegistrar.getSecureRandom();
        }
        try {
            this.engine.init(new KeyGenerationParameters(secureRandom, n));
            this.uninitialised = false;
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidParameterException(illegalArgumentException.getMessage());
        }
    }

    @Override
    public SecretKey engineGenerateKey() {
        if (((BaseKeyGenerator)object).uninitialised) {
            SecureRandom secureRandom = CryptoServicesRegistrar.getSecureRandom();
            ((BaseKeyGenerator)object).engine.init(new KeyGenerationParameters(secureRandom, ((BaseKeyGenerator)object).defaultKeySize));
            ((BaseKeyGenerator)object).uninitialised = false;
        }
        BaseKeyGenerator baseKeyGenerator = object;
        Object object = baseKeyGenerator.engine.generateKey();
        return new SecretKeySpec((byte[])object, baseKeyGenerator.algName);
    }
}

