/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseSecretKeyFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.PBE;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;

public class PBESecretKeyFactory
extends BaseSecretKeyFactory {
    private boolean forCipher;
    private int scheme;
    private int digest;
    private int keySize;
    private int ivSize;

    public PBESecretKeyFactory(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl, int n, int n2, int n3, int n4) {
        super(string, aSN1ObjectIdentifier);
        this.forCipher = bl;
        this.scheme = n;
        this.digest = n2;
        this.keySize = n3;
        this.ivSize = n4;
    }

    @Override
    public SecretKey engineGenerateSecret(KeySpec keySpec) {
        if (keySpec instanceof PBEKeySpec) {
            CipherParameters cipherParameters;
            int n;
            int n2;
            int n3;
            Object object;
            if (((PBEKeySpec)(keySpec = (PBEKeySpec)keySpec)).getSalt() == null) {
                PBESecretKeyFactory pBESecretKeyFactory = object;
                object = pBESecretKeyFactory.algName;
                ASN1ObjectIdentifier aSN1ObjectIdentifier = pBESecretKeyFactory.algOid;
                int n4 = pBESecretKeyFactory.scheme;
                int n5 = pBESecretKeyFactory.digest;
                int n6 = pBESecretKeyFactory.keySize;
                int n7 = pBESecretKeyFactory.ivSize;
                return new BCPBEKey((String)object, aSN1ObjectIdentifier, n4, n5, n6, n7, (PBEKeySpec)keySpec, null);
            }
            if (((PBESecretKeyFactory)object).forCipher) {
                PBESecretKeyFactory pBESecretKeyFactory = object;
                int n8 = pBESecretKeyFactory.scheme;
                n3 = pBESecretKeyFactory.digest;
                n2 = pBESecretKeyFactory.keySize;
                n = pBESecretKeyFactory.ivSize;
                cipherParameters = PBE.Util.makePBEParameters((PBEKeySpec)keySpec, n8, n3, n2, n);
            } else {
                PBESecretKeyFactory pBESecretKeyFactory = object;
                int n9 = pBESecretKeyFactory.scheme;
                n3 = pBESecretKeyFactory.digest;
                n2 = pBESecretKeyFactory.keySize;
                cipherParameters = PBE.Util.makePBEMacParameters((PBEKeySpec)keySpec, n9, n3, n2);
            }
            Object object2 = object;
            object = ((BaseSecretKeyFactory)object2).algName;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ((BaseSecretKeyFactory)object2).algOid;
            n2 = ((PBESecretKeyFactory)object2).scheme;
            n = ((PBESecretKeyFactory)object2).digest;
            int n10 = ((PBESecretKeyFactory)object2).keySize;
            int n11 = ((PBESecretKeyFactory)object2).ivSize;
            return new BCPBEKey((String)object, aSN1ObjectIdentifier, n2, n, n10, n11, (PBEKeySpec)keySpec, cipherParameters);
        }
        throw new InvalidKeySpecException("Invalid KeySpec");
    }
}

