/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KDFParameters;

public class BrokenKDF2BytesGenerator
implements DerivationFunction {
    private Digest digest;
    private byte[] shared;
    private byte[] iv;

    public BrokenKDF2BytesGenerator(Digest digest) {
        this.digest = digest;
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (derivationParameters instanceof KDFParameters) {
            BrokenKDF2BytesGenerator brokenKDF2BytesGenerator = kDFParameters;
            KDFParameters kDFParameters = (KDFParameters)derivationParameters;
            brokenKDF2BytesGenerator.shared = kDFParameters.getSharedSecret();
            brokenKDF2BytesGenerator.iv = kDFParameters.getIV();
            return;
        }
        throw new IllegalArgumentException("KDF parameters required for generator");
    }

    public Digest getDigest() {
        return this.digest;
    }

    @Override
    public int generateBytes(byte[] byArray, int n, int n2) {
        if (byArray.length - n2 >= n) {
            long l = (long)n2 * 8L;
            if (l <= (long)this.digest.getDigestSize() * 8L * 0x80000000L) {
                int n3 = (int)(l / (long)this.digest.getDigestSize());
                int n4 = this.digest.getDigestSize();
                byte[] byArray2 = new byte[n4];
                for (int k = 1; k <= n3; ++k) {
                    BrokenKDF2BytesGenerator brokenKDF2BytesGenerator = this;
                    brokenKDF2BytesGenerator.digest.update(this.shared, 0, this.shared.length);
                    brokenKDF2BytesGenerator.digest.update((byte)(k & 0xFF));
                    brokenKDF2BytesGenerator.digest.update((byte)(k >> 8 & 0xFF));
                    brokenKDF2BytesGenerator.digest.update((byte)(k >> 16 & 0xFF));
                    brokenKDF2BytesGenerator.digest.update((byte)(k >> 24 & 0xFF));
                    brokenKDF2BytesGenerator.digest.update(this.iv, 0, this.iv.length);
                    brokenKDF2BytesGenerator.digest.doFinal(byArray2, 0);
                    int n5 = n2 - n;
                    if (n5 > n4) {
                        System.arraycopy(byArray2, 0, byArray, n, n4);
                        n += n4;
                        continue;
                    }
                    System.arraycopy(byArray2, 0, byArray, n, n5);
                }
                this.digest.reset();
                return n2;
            }
            throw new IllegalArgumentException("Output length too large");
        }
        throw new OutputLengthException("output buffer too small");
    }
}

