/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKeyStructure;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X962Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPointEncoder;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BouncyCastleProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.JCEECPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPrivateKeySpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.util.Enumeration;

public class JCEECPrivateKey
implements java.security.interfaces.ECPrivateKey,
ECPrivateKey,
PKCS12BagAttributeCarrier,
ECPointEncoder {
    private String algorithm;
    private BigInteger d;
    private ECParameterSpec ecSpec;
    private boolean withCompression;
    private DERBitString publicKey;
    private PKCS12BagAttributeCarrierImpl attrCarrier;

    public JCEECPrivateKey() {
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrier.algorithm = "EC";
        PKCS12BagAttributeCarrier pKCS12BagAttributeCarrier = pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrierImpl = new PKCS12BagAttributeCarrierImpl();
        v1.attrCarrier = pKCS12BagAttributeCarrier;
    }

    public JCEECPrivateKey(java.security.interfaces.ECPrivateKey eCPrivateKey) {
        this.algorithm = "EC";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.d = eCPrivateKey.getS();
        this.algorithm = eCPrivateKey.getAlgorithm();
        this.ecSpec = eCPrivateKey.getParams();
    }

    public JCEECPrivateKey(String string, ECPrivateKeySpec eCPrivateKeySpec) {
        this.algorithm = "EC";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.algorithm = string;
        this.d = eCPrivateKeySpec.getD();
        this.ecSpec = eCPrivateKeySpec.getParams() != null ? EC5Util.convertSpec(EC5Util.convertCurve(eCPrivateKeySpec.getParams().getCurve(), eCPrivateKeySpec.getParams().getSeed()), eCPrivateKeySpec.getParams()) : null;
    }

    public JCEECPrivateKey(String string, java.security.spec.ECPrivateKeySpec eCPrivateKeySpec) {
        this.algorithm = "EC";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.algorithm = string;
        this.d = eCPrivateKeySpec.getS();
        this.ecSpec = eCPrivateKeySpec.getParams();
    }

    public JCEECPrivateKey(String string, JCEECPrivateKey jCEECPrivateKey) {
        this.algorithm = "EC";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.algorithm = string;
        this.d = jCEECPrivateKey.d;
        this.ecSpec = jCEECPrivateKey.ecSpec;
        this.withCompression = jCEECPrivateKey.withCompression;
        this.attrCarrier = jCEECPrivateKey.attrCarrier;
        this.publicKey = jCEECPrivateKey.publicKey;
    }

    public JCEECPrivateKey(String object, ECPrivateKeyParameters object2, JCEECPublicKey jCEECPublicKey, ECParameterSpec eCParameterSpec) {
        this.algorithm = "EC";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.algorithm = object;
        this.d = ((ECPrivateKeyParameters)object2).getD();
        if (eCParameterSpec == null) {
            object = ((ECKeyParameters)object2).getParameters();
            Object object3 = object2 = EC5Util.convertCurve(((ECDomainParameters)object).getCurve(), ((ECDomainParameters)object).getSeed());
            Object object4 = object;
            object = EC5Util.convertPoint(((ECDomainParameters)object4).getG());
            object2 = ((ECDomainParameters)object4).getN();
            int n = ((ECDomainParameters)object4).getH().intValue();
            this.ecSpec = new ECParameterSpec((EllipticCurve)object3, (java.security.spec.ECPoint)object, (BigInteger)object2, n);
        } else {
            this.ecSpec = eCParameterSpec;
        }
        this.publicKey = this.getPublicKeyDetails(jCEECPublicKey);
    }

    public JCEECPrivateKey(String object, ECPrivateKeyParameters object2, JCEECPublicKey jCEECPublicKey, com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec) {
        this.algorithm = "EC";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.algorithm = object;
        this.d = ((ECPrivateKeyParameters)object2).getD();
        if (eCParameterSpec == null) {
            object = ((ECKeyParameters)object2).getParameters();
            Object object3 = object2 = EC5Util.convertCurve(((ECDomainParameters)object).getCurve(), ((ECDomainParameters)object).getSeed());
            Object object4 = object;
            object = EC5Util.convertPoint(((ECDomainParameters)object4).getG());
            object2 = ((ECDomainParameters)object4).getN();
            int n = ((ECDomainParameters)object4).getH().intValue();
            this.ecSpec = new ECParameterSpec((EllipticCurve)object3, (java.security.spec.ECPoint)object, (BigInteger)object2, n);
        } else {
            Object object5 = object = EC5Util.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getSeed());
            com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec2 = eCParameterSpec;
            object = EC5Util.convertPoint(eCParameterSpec2.getG());
            object2 = eCParameterSpec2.getN();
            int n = eCParameterSpec2.getH().intValue();
            this.ecSpec = new ECParameterSpec((EllipticCurve)object5, (java.security.spec.ECPoint)object, (BigInteger)object2, n);
        }
        this.publicKey = this.getPublicKeyDetails(jCEECPublicKey);
    }

    public JCEECPrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters) {
        JCEECPrivateKey jCEECPrivateKey = this;
        this.algorithm = "EC";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.algorithm = string;
        jCEECPrivateKey.d = eCPrivateKeyParameters.getD();
        jCEECPrivateKey.ecSpec = null;
    }

    public JCEECPrivateKey(PrivateKeyInfo privateKeyInfo) {
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl;
        JCEECPrivateKey jCEECPrivateKey = pKCS12BagAttributeCarrier;
        jCEECPrivateKey.algorithm = "EC";
        PKCS12BagAttributeCarrier pKCS12BagAttributeCarrier = pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrierImpl = new PKCS12BagAttributeCarrierImpl();
        jCEECPrivateKey.attrCarrier = pKCS12BagAttributeCarrier;
        jCEECPrivateKey.populateFromPrivKeyInfo(privateKeyInfo);
    }

    private void populateFromPrivKeyInfo(PrivateKeyInfo aSN1Encodable) {
        Object object = X962Parameters.getInstance(aSN1Encodable.getPrivateKeyAlgorithm().getParameters());
        if (((X962Parameters)object).isNamedCurve()) {
            Object object2 = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)(object = ASN1ObjectIdentifier.getInstance(((X962Parameters)object).getParameters())));
            if (object2 == null) {
                object2 = ECGOST3410NamedCurves.getByOID((ASN1ObjectIdentifier)object);
                EllipticCurve ellipticCurve = EC5Util.convertCurve(((ECDomainParameters)object2).getCurve(), ((ECDomainParameters)object2).getSeed());
                Object object3 = object2;
                object = ECGOST3410NamedCurves.getName((ASN1ObjectIdentifier)object);
                object2 = EC5Util.convertPoint(((ECDomainParameters)object3).getG());
                BigInteger bigInteger = ((ECDomainParameters)object3).getN();
                BigInteger bigInteger2 = ((ECDomainParameters)object3).getH();
                ((JCEECPrivateKey)((Object)eCPrivateKeyStructure2)).ecSpec = new ECNamedCurveSpec((String)object, ellipticCurve, (java.security.spec.ECPoint)object2, bigInteger, bigInteger2);
            } else {
                EllipticCurve ellipticCurve = EC5Util.convertCurve(((X9ECParameters)object2).getCurve(), ((X9ECParameters)object2).getSeed());
                Object object4 = object2;
                object = ECUtil.getCurveName((ASN1ObjectIdentifier)object);
                object2 = EC5Util.convertPoint(((X9ECParameters)object4).getG());
                BigInteger bigInteger = ((X9ECParameters)object4).getN();
                BigInteger bigInteger3 = ((X9ECParameters)object4).getH();
                ((JCEECPrivateKey)((Object)eCPrivateKeyStructure2)).ecSpec = new ECNamedCurveSpec((String)object, ellipticCurve, (java.security.spec.ECPoint)object2, bigInteger, bigInteger3);
            }
        } else if (((X962Parameters)object).isImplicitlyCA()) {
            ((JCEECPrivateKey)((Object)eCPrivateKeyStructure2)).ecSpec = null;
        } else {
            object = X9ECParameters.getInstance(((X962Parameters)object).getParameters());
            Object object5 = EC5Util.convertCurve(((X9ECParameters)object).getCurve(), ((X9ECParameters)object).getSeed());
            EllipticCurve ellipticCurve = object5;
            ASN1Object aSN1Object = object;
            object = EC5Util.convertPoint(((X9ECParameters)aSN1Object).getG());
            object5 = ((X9ECParameters)aSN1Object).getN();
            int n = ((X9ECParameters)aSN1Object).getH().intValue();
            ((JCEECPrivateKey)((Object)eCPrivateKeyStructure2)).ecSpec = new ECParameterSpec(ellipticCurve, (java.security.spec.ECPoint)object, (BigInteger)object5, n);
        }
        aSN1Encodable = aSN1Encodable.parsePrivateKey();
        if (aSN1Encodable instanceof ASN1Integer) {
            ((JCEECPrivateKey)((Object)eCPrivateKeyStructure2)).d = ASN1Integer.getInstance(aSN1Encodable).getValue();
        } else {
            ECPrivateKeyStructure eCPrivateKeyStructure;
            JCEECPrivateKey jCEECPrivateKey = eCPrivateKeyStructure2;
            ECPrivateKeyStructure eCPrivateKeyStructure2 = eCPrivateKeyStructure;
            jCEECPrivateKey.d = new ECPrivateKeyStructure((ASN1Sequence)aSN1Encodable).getKey();
            jCEECPrivateKey.publicKey = eCPrivateKeyStructure2.getPublicKey();
        }
    }

    private DERBitString getPublicKeyDetails(JCEECPublicKey jCEECPublicKey) {
        try {
            return SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(jCEECPublicKey.getEncoded())).getPublicKeyData();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl;
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl2;
        this.populateFromPrivKeyInfo(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray((byte[])objectInputStream.readObject())));
        this.algorithm = (String)objectInputStream.readObject();
        this.withCompression = objectInputStream.readBoolean();
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl3 = pKCS12BagAttributeCarrierImpl2 = pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrierImpl3();
        this.attrCarrier = pKCS12BagAttributeCarrierImpl3;
        pKCS12BagAttributeCarrierImpl.readObject(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeObject(this.getEncoded());
        objectOutputStream.writeObject(this.algorithm);
        objectOutputStream.writeBoolean(this.withCompression);
        this.attrCarrier.writeObject(objectOutputStream);
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] getEncoded() {
        AlgorithmIdentifier algorithmIdentifier;
        PrivateKeyInfo privateKeyInfo;
        Object object;
        Object object2;
        Object object3;
        block16: {
            AlgorithmIdentifier algorithmIdentifier2;
            PrivateKeyInfo privateKeyInfo2;
            Object object4;
            object3 = ((JCEECPrivateKey)object).ecSpec;
            if (object3 instanceof ECNamedCurveSpec) {
                X962Parameters x962Parameters;
                if ((object3 = ECUtil.getNamedCurveOid(((ECNamedCurveSpec)object3).getName())) == null) {
                    ASN1ObjectIdentifier aSN1ObjectIdentifier;
                    object3 = aSN1ObjectIdentifier;
                    aSN1ObjectIdentifier = new ASN1ObjectIdentifier(((ECNamedCurveSpec)((JCEECPrivateKey)object).ecSpec).getName());
                }
                object2 = x962Parameters;
                x962Parameters = new X962Parameters((ASN1ObjectIdentifier)object3);
            } else if (object3 == null) {
                X962Parameters x962Parameters;
                object2 = x962Parameters;
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
            } else {
                X962Parameters x962Parameters;
                X9ECPoint x9ECPoint;
                X9ECParameters x9ECParameters;
                object3 = EC5Util.convertCurve(((ECParameterSpec)object3).getCurve());
                object2 = x9ECParameters;
                Object object5 = object3;
                JCEECPrivateKey jCEECPrivateKey = object;
                object4 = x9ECPoint;
                object3 = EC5Util.convertPoint((ECCurve)object3, ((JCEECPrivateKey)object).ecSpec.getGenerator());
                x9ECPoint = new X9ECPoint((ECPoint)object3, ((JCEECPrivateKey)object).withCompression);
                object3 = jCEECPrivateKey.ecSpec.getOrder();
                BigInteger bigInteger = BigInteger.valueOf(jCEECPrivateKey.ecSpec.getCofactor());
                byte[] byArray = jCEECPrivateKey.ecSpec.getCurve().getSeed();
                x9ECParameters = new X9ECParameters((ECCurve)object5, (X9ECPoint)object4, (BigInteger)object3, bigInteger, byArray);
                object3 = x962Parameters;
                x962Parameters = new X962Parameters((X9ECParameters)object2);
                object2 = object3;
            }
            if (((JCEECPrivateKey)object).publicKey != null) {
                ECPrivateKeyStructure eCPrivateKeyStructure;
                object3 = eCPrivateKeyStructure;
                JCEECPrivateKey jCEECPrivateKey = object;
                object4 = jCEECPrivateKey.getS();
                eCPrivateKeyStructure = new ECPrivateKeyStructure((BigInteger)object4, jCEECPrivateKey.publicKey, (ASN1Encodable)object2);
            } else {
                ECPrivateKeyStructure eCPrivateKeyStructure;
                object3 = eCPrivateKeyStructure;
                eCPrivateKeyStructure = new ECPrivateKeyStructure(((JCEECPrivateKey)object).getS(), (ASN1Encodable)object2);
            }
            try {
                if (!((JCEECPrivateKey)object).algorithm.equals("ECGOST3410")) break block16;
            }
            catch (IOException iOException) {
                return null;
            }
            object = privateKeyInfo2;
            Object object6 = object3;
            object3 = algorithmIdentifier2;
            ASN1Object aSN1Object = object2;
            object2 = CryptoProObjectIdentifiers.gostR3410_2001;
            algorithmIdentifier2 = new AlgorithmIdentifier((ASN1ObjectIdentifier)object2, ((X962Parameters)aSN1Object).toASN1Primitive());
            privateKeyInfo2 = new PrivateKeyInfo((AlgorithmIdentifier)object3, ((ECPrivateKeyStructure)object6).toASN1Primitive());
            return ((ASN1Object)object).getEncoded("DER");
        }
        object = privateKeyInfo;
        Object object7 = object3;
        object3 = algorithmIdentifier;
        ASN1Object aSN1Object = object2;
        object2 = X9ObjectIdentifiers.id_ecPublicKey;
        algorithmIdentifier = new AlgorithmIdentifier((ASN1ObjectIdentifier)object2, ((X962Parameters)aSN1Object).toASN1Primitive());
        privateKeyInfo = new PrivateKeyInfo((AlgorithmIdentifier)object3, ((ECPrivateKeyStructure)object7).toASN1Primitive());
        return ((ASN1Object)object).getEncoded("DER");
    }

    @Override
    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    @Override
    public com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec getParameters() {
        ECParameterSpec eCParameterSpec = ((JCEECPrivateKey)((Object)eCParameterSpec)).ecSpec;
        if (eCParameterSpec == null) {
            return null;
        }
        return EC5Util.convertSpec(eCParameterSpec);
    }

    public com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec engineGetSpec() {
        ECParameterSpec eCParameterSpec = ((JCEECPrivateKey)((Object)eCParameterSpec)).ecSpec;
        if (eCParameterSpec != null) {
            return EC5Util.convertSpec(eCParameterSpec);
        }
        return BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    @Override
    public BigInteger getS() {
        return this.d;
    }

    @Override
    public BigInteger getD() {
        return this.d;
    }

    @Override
    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.attrCarrier.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    @Override
    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.attrCarrier.getBagAttribute(aSN1ObjectIdentifier);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }

    @Override
    public void setPointFormat(String string) {
        this.withCompression = "UNCOMPRESSED".equalsIgnoreCase(string) ^ true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JCEECPrivateKey)) {
            return false;
        }
        object = (JCEECPrivateKey)object;
        return this.getD().equals(((JCEECPrivateKey)object).getD()) && this.engineGetSpec().equals(((JCEECPrivateKey)object).engineGetSpec());
    }

    public int hashCode() {
        return this.getD().hashCode() ^ this.engineGetSpec().hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Strings.lineSeparator();
        stringBuffer.append("EC Private Key").append(string);
        stringBuffer.append("             S: ").append(this.d.toString(16)).append(string);
        return stringBuffer.toString();
    }
}

