/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.ElGamalParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ElGamalPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ElGamalParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ElGamalPublicKeySpec;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class JCEElGamalPublicKey
implements ElGamalPublicKey,
DHPublicKey {
    public static final long serialVersionUID = 8712728417091216948L;
    private BigInteger y;
    private ElGamalParameterSpec elSpec;

    public JCEElGamalPublicKey(ElGamalPublicKeySpec elGamalPublicKeySpec) {
        JCEElGamalPublicKey jCEElGamalPublicKey = this;
        jCEElGamalPublicKey.y = elGamalPublicKeySpec.getY();
        jCEElGamalPublicKey.elSpec = new ElGamalParameterSpec(elGamalPublicKeySpec.getParams().getP(), elGamalPublicKeySpec.getParams().getG());
    }

    public JCEElGamalPublicKey(DHPublicKeySpec dHPublicKeySpec) {
        JCEElGamalPublicKey jCEElGamalPublicKey = serializable;
        jCEElGamalPublicKey.y = dHPublicKeySpec.getY();
        DHPublicKeySpec dHPublicKeySpec2 = dHPublicKeySpec;
        Serializable serializable = dHPublicKeySpec2.getP();
        jCEElGamalPublicKey.elSpec = new ElGamalParameterSpec((BigInteger)serializable, dHPublicKeySpec2.getG());
    }

    public JCEElGamalPublicKey(ElGamalPublicKey elGamalPublicKey) {
        this.y = elGamalPublicKey.getY();
        this.elSpec = elGamalPublicKey.getParameters();
    }

    public JCEElGamalPublicKey(DHPublicKey dHPublicKey) {
        JCEElGamalPublicKey jCEElGamalPublicKey = this;
        jCEElGamalPublicKey.y = dHPublicKey.getY();
        jCEElGamalPublicKey.elSpec = new ElGamalParameterSpec(dHPublicKey.getParams().getP(), dHPublicKey.getParams().getG());
    }

    public JCEElGamalPublicKey(ElGamalPublicKeyParameters elGamalPublicKeyParameters) {
        JCEElGamalPublicKey jCEElGamalPublicKey = this;
        jCEElGamalPublicKey.y = elGamalPublicKeyParameters.getY();
        jCEElGamalPublicKey.elSpec = new ElGamalParameterSpec(elGamalPublicKeyParameters.getParameters().getP(), elGamalPublicKeyParameters.getParameters().getG());
    }

    public JCEElGamalPublicKey(BigInteger bigInteger, ElGamalParameterSpec elGamalParameterSpec) {
        this.y = bigInteger;
        this.elSpec = elGamalParameterSpec;
    }

    public JCEElGamalPublicKey(SubjectPublicKeyInfo aSN1Object) {
        JCEElGamalPublicKey jCEElGamalPublicKey = serializable;
        SubjectPublicKeyInfo subjectPublicKeyInfo = aSN1Object;
        aSN1Object = ElGamalParameter.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
        try {
            jCEElGamalPublicKey.y = ((ASN1Integer)subjectPublicKeyInfo.parsePublicKey()).getValue();
            ASN1Object aSN1Object2 = aSN1Object;
            Serializable serializable = ((ElGamalParameter)aSN1Object2).getP();
            jCEElGamalPublicKey.elSpec = new ElGamalParameterSpec((BigInteger)serializable, ((ElGamalParameter)aSN1Object2).getG());
            return;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid info structure in DSA public key");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        JCEElGamalPublicKey jCEElGamalPublicKey = this;
        jCEElGamalPublicKey.y = (BigInteger)objectInputStream.readObject();
        jCEElGamalPublicKey.elSpec = new ElGamalParameterSpec((BigInteger)objectInputStream.readObject(), (BigInteger)objectInputStream.readObject());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeObject(this.getY());
        objectOutputStream.writeObject(this.elSpec.getP());
        objectOutputStream.writeObject(this.elSpec.getG());
    }

    @Override
    public String getAlgorithm() {
        return "ElGamal";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(this.elSpec.getP(), this.elSpec.getG())), new ASN1Integer(this.y));
    }

    @Override
    public ElGamalParameterSpec getParameters() {
        return this.elSpec;
    }

    @Override
    public DHParameterSpec getParams() {
        return new DHParameterSpec(this.elSpec.getP(), this.elSpec.getG());
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }
}

