/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.DSAParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.DSAPrivateKeySpec;
import java.util.Enumeration;

public class JDKDSAPrivateKey
implements DSAPrivateKey,
PKCS12BagAttributeCarrier {
    private static final long serialVersionUID = -4677259546958385734L;
    public BigInteger x;
    public DSAParams dsaSpec;
    private PKCS12BagAttributeCarrierImpl attrCarrier;

    public JDKDSAPrivateKey() {
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl;
        PKCS12BagAttributeCarrier pKCS12BagAttributeCarrier = pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrierImpl = new PKCS12BagAttributeCarrierImpl();
        v1.attrCarrier = pKCS12BagAttributeCarrier;
    }

    public JDKDSAPrivateKey(DSAPrivateKey dSAPrivateKey) {
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.x = dSAPrivateKey.getX();
        this.dsaSpec = dSAPrivateKey.getParams();
    }

    public JDKDSAPrivateKey(DSAPrivateKeySpec object) {
        JDKDSAPrivateKey jDKDSAPrivateKey = serializable;
        serializable.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        jDKDSAPrivateKey.x = ((DSAPrivateKeySpec)object).getX();
        DSAPrivateKeySpec dSAPrivateKeySpec = object;
        Serializable serializable = dSAPrivateKeySpec.getP();
        object = dSAPrivateKeySpec.getQ();
        BigInteger bigInteger = dSAPrivateKeySpec.getG();
        jDKDSAPrivateKey.dsaSpec = new DSAParameterSpec((BigInteger)serializable, (BigInteger)object, bigInteger);
    }

    public JDKDSAPrivateKey(PrivateKeyInfo object) {
        JDKDSAPrivateKey jDKDSAPrivateKey = object2;
        PrivateKeyInfo privateKeyInfo = object;
        ((JDKDSAPrivateKey)object2).attrCarrier = new PKCS12BagAttributeCarrierImpl();
        Object object2 = DSAParameter.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
        jDKDSAPrivateKey.x = ASN1Integer.getInstance(privateKeyInfo.parsePrivateKey()).getValue();
        Object object3 = object2;
        object2 = ((DSAParameter)object3).getP();
        object = ((DSAParameter)object3).getQ();
        BigInteger bigInteger = ((DSAParameter)object3).getG();
        jDKDSAPrivateKey.dsaSpec = new DSAParameterSpec((BigInteger)object2, (BigInteger)object, bigInteger);
    }

    public JDKDSAPrivateKey(DSAPrivateKeyParameters dSAPrivateKeyParameters) {
        JDKDSAPrivateKey jDKDSAPrivateKey = serializable;
        serializable.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        jDKDSAPrivateKey.x = dSAPrivateKeyParameters.getX();
        DSAPrivateKeyParameters dSAPrivateKeyParameters2 = dSAPrivateKeyParameters;
        Serializable serializable = dSAPrivateKeyParameters2.getParameters().getQ();
        jDKDSAPrivateKey.dsaSpec = new DSAParameterSpec(dSAPrivateKeyParameters.getParameters().getP(), (BigInteger)serializable, dSAPrivateKeyParameters2.getParameters().getG());
    }

    private void readObject(ObjectInputStream objectInputStream) {
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl;
        JDKDSAPrivateKey jDKDSAPrivateKey = this;
        jDKDSAPrivateKey.x = (BigInteger)objectInputStream.readObject();
        ObjectInputStream objectInputStream2 = objectInputStream;
        Object object = (BigInteger)objectInputStream2.readObject();
        jDKDSAPrivateKey.dsaSpec = new DSAParameterSpec((BigInteger)objectInputStream.readObject(), (BigInteger)object, (BigInteger)objectInputStream2.readObject());
        Object object2 = object = pKCS12BagAttributeCarrierImpl;
        ((PKCS12BagAttributeCarrierImpl)object2)();
        this.attrCarrier = object2;
        pKCS12BagAttributeCarrierImpl.readObject(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeObject(this.x);
        objectOutputStream.writeObject(this.dsaSpec.getP());
        objectOutputStream.writeObject(this.dsaSpec.getQ());
        objectOutputStream.writeObject(this.dsaSpec.getG());
        this.attrCarrier.writeObject(objectOutputStream);
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        BigInteger bigInteger;
        JDKDSAPrivateKey jDKDSAPrivateKey;
        BigInteger bigInteger2;
        DSAParameter dSAParameter;
        DSAParameter dSAParameter2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        AlgorithmIdentifier algorithmIdentifier;
        AlgorithmIdentifier algorithmIdentifier2;
        PrivateKeyInfo privateKeyInfo;
        PrivateKeyInfo privateKeyInfo2;
        try {
            DSAParameter dSAParameter3;
            AlgorithmIdentifier algorithmIdentifier3;
            PrivateKeyInfo privateKeyInfo3;
            privateKeyInfo2 = privateKeyInfo3;
            privateKeyInfo = privateKeyInfo3;
            algorithmIdentifier2 = algorithmIdentifier3;
            algorithmIdentifier = algorithmIdentifier3;
            aSN1ObjectIdentifier = X9ObjectIdentifiers.id_dsa;
            dSAParameter2 = dSAParameter3;
            dSAParameter = dSAParameter3;
            bigInteger2 = this.dsaSpec.getP();
            JDKDSAPrivateKey jDKDSAPrivateKey2 = this;
            jDKDSAPrivateKey = jDKDSAPrivateKey2;
            bigInteger = jDKDSAPrivateKey2.dsaSpec.getQ();
        }
        catch (IOException iOException) {
            return null;
        }
        dSAParameter2(bigInteger2, bigInteger, jDKDSAPrivateKey.dsaSpec.getG());
        algorithmIdentifier2(aSN1ObjectIdentifier, dSAParameter);
        privateKeyInfo2(algorithmIdentifier, new ASN1Integer(this.getX()));
        return privateKeyInfo.getEncoded("DER");
    }

    @Override
    public DSAParams getParams() {
        return this.dsaSpec;
    }

    @Override
    public BigInteger getX() {
        return this.x;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DSAPrivateKey)) {
            return false;
        }
        object = (DSAPrivateKey)object;
        return this.getX().equals(object.getX()) && this.getParams().getG().equals(object.getParams().getG()) && this.getParams().getP().equals(object.getParams().getP()) && this.getParams().getQ().equals(object.getParams().getQ());
    }

    public int hashCode() {
        return this.getX().hashCode() ^ this.getParams().getG().hashCode() ^ this.getParams().getP().hashCode() ^ this.getParams().getQ().hashCode();
    }

    @Override
    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.attrCarrier.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    @Override
    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.attrCarrier.getBagAttribute(aSN1ObjectIdentifier);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }
}

