/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;

public abstract class AbstractECMultiplier
implements ECMultiplier {
    @Override
    public ECPoint multiply(ECPoint eCPoint, BigInteger bigInteger) {
        int n = bigInteger.signum();
        if (n != 0 && !eCPoint.isInfinity()) {
            eCPoint = this.multiplyPositive(eCPoint, bigInteger.abs());
            if (n <= 0) {
                eCPoint = eCPoint.negate();
            }
            return this.checkResult(eCPoint);
        }
        return eCPoint.getCurve().getInfinity();
    }

    public abstract ECPoint multiplyPositive(ECPoint var1, BigInteger var2);

    public ECPoint checkResult(ECPoint eCPoint) {
        return ECAlgorithms.implCheckResult(eCPoint);
    }
}

