/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.FixedPointPreCompInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.PreCompCallback;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.PreCompInfo;
import java.math.BigInteger;

public class FixedPointUtil {
    public static final String PRECOMP_NAME = "bc_fixed_point";

    public static int getCombSize(ECCurve eCCurve) {
        BigInteger bigInteger = eCCurve.getOrder();
        return bigInteger == null ? eCCurve.getFieldSize() + 1 : bigInteger.bitLength();
    }

    public static FixedPointPreCompInfo getFixedPointPreCompInfo(PreCompInfo preCompInfo) {
        return preCompInfo instanceof FixedPointPreCompInfo ? (FixedPointPreCompInfo)preCompInfo : null;
    }

    public static FixedPointPreCompInfo precompute(final ECPoint eCPoint) {
        PreCompCallback preCompCallback;
        final ECCurve eCCurve = eCPoint.getCurve();
        PreCompCallback preCompCallback2 = preCompCallback;
        preCompCallback = new PreCompCallback(){

            private boolean checkExisting(FixedPointPreCompInfo fixedPointPreCompInfo, int n) {
                return fixedPointPreCompInfo != null && this.checkTable(fixedPointPreCompInfo.getLookupTable(), n);
            }

            private boolean checkTable(ECLookupTable eCLookupTable, int n) {
                return eCLookupTable != null && eCLookupTable.getSize() >= n;
            }

            @Override
            public PreCompInfo precompute(PreCompInfo preCompInfo) {
                FixedPointPreCompInfo fixedPointPreCompInfo;
                int n;
                int n2;
                int n3;
                int n4;
                if (this.checkExisting((FixedPointPreCompInfo)(preCompInfo = preCompInfo instanceof FixedPointPreCompInfo ? (FixedPointPreCompInfo)preCompInfo : null), n4 = 1 << (n3 = (n2 = FixedPointUtil.getCombSize(eCCurve)) > 250 ? 6 : 5))) {
                    return preCompInfo;
                }
                int n5 = (n2 + n3 - 1) / n3;
                ECPoint[] eCPointArray = new ECPoint[n3 + 1];
                ECPoint[] eCPointArray2 = eCPointArray;
                eCPointArray[0] = eCPoint;
                for (n = 1; n < n3; ++n) {
                    eCPointArray2[n] = eCPointArray2[n - 1].timesPow2(n5);
                }
                eCPointArray2[n3] = eCPointArray2[0].subtract(eCPointArray2[1]);
                eCCurve.normalizeAll(eCPointArray2);
                ECPoint[] eCPointArray3 = new ECPoint[n4];
                ECPoint[] eCPointArray4 = eCPointArray3;
                eCPointArray3[0] = eCPointArray2[0];
                for (n = n3 - 1; n >= 0; --n) {
                    int n6;
                    ECPoint eCPoint2 = eCPointArray2[n];
                    for (int k = n6 = 1 << n; k < n4; k += n6 << 1) {
                        eCPointArray4[k] = eCPointArray4[k - n6].add(eCPoint2);
                    }
                }
                eCCurve.normalizeAll(eCPointArray4);
                FixedPointPreCompInfo fixedPointPreCompInfo2 = fixedPointPreCompInfo;
                fixedPointPreCompInfo2();
                fixedPointPreCompInfo2.setLookupTable(eCCurve.createCacheSafeLookupTable(eCPointArray4, 0, n4));
                fixedPointPreCompInfo2.setOffset(eCPointArray2[n3]);
                fixedPointPreCompInfo.setWidth(n3);
                return fixedPointPreCompInfo;
            }
        };
        return (FixedPointPreCompInfo)eCCurve.precompute(eCPoint, PRECOMP_NAME, preCompCallback2);
    }
}

