/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP160K1Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP160R2Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP160R2FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat160;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP160K1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q;
    private static final int SECP160K1_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SECP160K1_AFFINE_ZS;
    public SecP160K1Point infinity;

    public SecP160K1Curve() {
        SecP160K1Curve secP160K1Curve = this;
        super(q);
        secP160K1Curve.infinity = new SecP160K1Point(this, null, null);
        secP160K1Curve.a = secP160K1Curve.fromBigInteger(ECConstants.ZERO);
        secP160K1Curve.b = secP160K1Curve.fromBigInteger(BigInteger.valueOf(7L));
        secP160K1Curve.order = new BigInteger(1, Hex.decodeStrict("0100000000000000000001B8FA16DFAB9ACA16B6B3"));
        secP160K1Curve.cofactor = BigInteger.valueOf(1L);
        secP160K1Curve.coord = 2;
    }

    static {
        SecP160R2FieldElement secP160R2FieldElement;
        q = SecP160R2FieldElement.Q;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SecP160R2FieldElement secP160R2FieldElement2 = secP160R2FieldElement;
        secP160R2FieldElement = new SecP160R2FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = secP160R2FieldElement2;
        SECP160K1_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SecP160K1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        return n == 2;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP160R2FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecP160K1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecP160K1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final int[] nArray = new int[n2 * 5 * 2];
        int n3 = 0;
        for (int k = 0; k < n2; ++k) {
            ECPoint eCPoint = eCPointArray[n + k];
            Nat160.copy(((SecP160R2FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat160.copy(((SecP160R2FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 5);
            n3 += 5;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(int[] nArray3, int[] nArray2) {
                SecP160R2FieldElement secP160R2FieldElement;
                SecP160R2FieldElement secP160R2FieldElement2 = secP160R2FieldElement;
                secP160R2FieldElement = new SecP160R2FieldElement(nArray2);
                return secP160R2FieldElement2.SecP160K1Curve.this.createRawPoint(new SecP160R2FieldElement(nArray3), secP160R2FieldElement2, SECP160K1_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n2;
            }

            @Override
            public ECPoint lookup(int n) {
                int[] nArray4 = Nat160.create();
                int[] nArray2 = Nat160.create();
                int n22 = 0;
                for (int k = 0; k < n2; ++k) {
                    int n3 = (k ^ n) - 1 >> 31;
                    for (int i2 = 0; i2 < 5; ++i2) {
                        int[] nArray3 = nArray;
                        nArray4[i2] = nArray4[i2] ^ nArray[n22 + i2] & n3;
                        nArray2[i2] = nArray2[i2] ^ nArray3[n22 + 5 + i2] & n3;
                    }
                    n22 += 10;
                }
                return this.createPoint(nArray4, nArray2);
            }

            @Override
            public ECPoint lookupVar(int n) {
                int[] nArray4 = Nat160.create();
                int[] nArray2 = Nat160.create();
                int n22 = n * 5 * 2;
                for (int k = 0; k < 5; ++k) {
                    int[] nArray3 = nArray;
                    nArray4[k] = nArray3[n22 + k];
                    nArray2[k] = nArray[n22 + 5 + k];
                }
                return this.createPoint(nArray4, nArray2);
            }
        };
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat160.create();
        Object object = nArray;
        SecP160R2Field.random(secureRandom, nArray);
        return new SecP160R2FieldElement((int[])object);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat160.create();
        Object object = nArray;
        SecP160R2Field.randomMult(secureRandom, nArray);
        return new SecP160R2FieldElement((int[])object);
    }
}

