/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP192K1Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat192;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP192K1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFEE37"));
    public int[] x;

    public SecP192K1FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.compareTo(Q) < 0) {
            this.x = SecP192K1Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SecP192K1FieldElement");
    }

    public SecP192K1FieldElement() {
        this.x = Nat192.create();
    }

    public SecP192K1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    @Override
    public boolean isZero() {
        return Nat192.isZero(this.x);
    }

    @Override
    public boolean isOne() {
        return Nat192.isOne(this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat192.getBit(this.x, 0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat192.toBigInteger(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecP192K1Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SecP192K1FieldElement secP192K1FieldElement = object;
        Object object = Nat192.create();
        SecP192K1Field.add(secP192K1FieldElement.x, ((SecP192K1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP192K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SecP192K1FieldElement secP192K1FieldElement = object;
        Object object = Nat192.create();
        SecP192K1Field.addOne(secP192K1FieldElement.x, (int[])object);
        return new SecP192K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        SecP192K1FieldElement secP192K1FieldElement = object;
        Object object = Nat192.create();
        SecP192K1Field.subtract(secP192K1FieldElement.x, ((SecP192K1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP192K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SecP192K1FieldElement secP192K1FieldElement = object;
        Object object = Nat192.create();
        SecP192K1Field.multiply(secP192K1FieldElement.x, ((SecP192K1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP192K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat192.create();
        SecP192K1Field.inv(((SecP192K1FieldElement)eCFieldElement).x, nArray);
        SecP192K1Field.multiply(nArray, this.x, nArray);
        return new SecP192K1FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        SecP192K1FieldElement secP192K1FieldElement = object;
        Object object = Nat192.create();
        SecP192K1Field.negate(secP192K1FieldElement.x, (int[])object);
        return new SecP192K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement square() {
        SecP192K1FieldElement secP192K1FieldElement = object;
        Object object = Nat192.create();
        SecP192K1Field.square(secP192K1FieldElement.x, (int[])object);
        return new SecP192K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement invert() {
        SecP192K1FieldElement secP192K1FieldElement = object;
        Object object = Nat192.create();
        SecP192K1Field.inv(secP192K1FieldElement.x, (int[])object);
        return new SecP192K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        Object object = ((SecP192K1FieldElement)object2).x;
        if (!Nat192.isZero(((SecP192K1FieldElement)object2).x) && !Nat192.isOne(object)) {
            int[] nArray = object;
            int[] nArray2 = Nat192.create();
            Object object2 = nArray2;
            SecP192K1Field.square(object, (int[])object2);
            SecP192K1Field.multiply(nArray2, object, (int[])object2);
            int[] nArray3 = Nat192.create();
            SecP192K1Field.square((int[])object2, nArray3);
            SecP192K1Field.multiply(nArray3, object, nArray3);
            object = Nat192.create();
            Object object3 = object2;
            int[] nArray4 = object;
            SecP192K1Field.squareN(nArray3, 3, object);
            SecP192K1Field.multiply(object, nArray3, object);
            SecP192K1Field.squareN(object, 2, object);
            SecP192K1Field.multiply(nArray4, (int[])object2, object);
            SecP192K1Field.squareN(nArray4, 8, (int[])object2);
            SecP192K1Field.multiply((int[])object3, object, (int[])object2);
            SecP192K1Field.squareN((int[])object3, 3, object);
            SecP192K1Field.multiply(object, nArray3, object);
            int[] nArray5 = Nat192.create();
            Object object4 = object2;
            int[] nArray6 = nArray5;
            SecP192K1Field.squareN(object, 16, nArray5);
            SecP192K1Field.multiply(nArray6, (int[])object2, nArray5);
            SecP192K1Field.squareN(nArray6, 35, (int[])object2);
            SecP192K1Field.multiply((int[])object4, nArray5, (int[])object2);
            SecP192K1Field.squareN((int[])object4, 70, nArray5);
            SecP192K1Field.multiply(nArray5, (int[])object4, nArray5);
            SecP192K1Field.squareN(nArray5, 19, (int[])object2);
            SecP192K1Field.multiply(nArray2, object, (int[])object2);
            SecP192K1Field.squareN(nArray2, 20, (int[])object2);
            SecP192K1Field.multiply(nArray2, object, (int[])object2);
            SecP192K1Field.squareN(nArray2, 4, (int[])object2);
            SecP192K1Field.multiply(nArray2, nArray3, (int[])object2);
            SecP192K1Field.squareN(nArray2, 6, (int[])object2);
            SecP192K1Field.multiply(nArray2, nArray3, (int[])object2);
            SecP192K1Field.square(nArray2, nArray2);
            SecP192K1Field.square(nArray2, nArray3);
            if (Nat192.eq(nArray, nArray3)) {
                SecP192K1FieldElement secP192K1FieldElement;
                object = secP192K1FieldElement;
                secP192K1FieldElement = new SecP192K1FieldElement((int[])object2);
            } else {
                object = null;
            }
            return object;
        }
        return object2;
    }

    public boolean equals(Object object) {
        if (object == secP192K1FieldElement2) {
            return true;
        }
        if (!(object instanceof SecP192K1FieldElement)) {
            return false;
        }
        SecP192K1FieldElement secP192K1FieldElement = secP192K1FieldElement2;
        SecP192K1FieldElement secP192K1FieldElement2 = (SecP192K1FieldElement)object;
        return Nat192.eq(secP192K1FieldElement.x, secP192K1FieldElement2.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 6);
    }
}

